function [totalCoh, sumCoh, maxVal,locMax] = totalCoh(coh,freqList)
% compute total coherence totalCoh (average) at each time, average over
% time (sumCoh)  and maximum totalCoh over time, also compute where max occurs.
  
  tmp = size(coh);
  nfreqs = tmp(1);
  n = tmp(2);
  totalCoh = zeros(1,n);
  for k=1:nfreqs-1
    fk1 = freqList(k);
    fk2 = freqList(k+1);
    df = fk2-fk1;
    cohMean = (coh(k,:) + coh(k+1,:))/2;
    totalCoh = totalCoh + cohMean * df;
  end
  totalCoh = totalCoh/(freqList(end)-freqList(1));
  [maxVal,locMax] = max(totalCoh);
  sumCoh = sum(totalCoh)/n;
  

  