function [h,f,t] = morletTransform(x,fsamp,resolutionPar,freqList)
%
% function [h,f,t] = morletTransform(x,fsamp,resolutionPar,freqList)
%
% x time domain signal (must be even in length)  
% fsamp sampling rate (Hz)
% resolutionPar multiplies Morlet transform resolution parameter
% (normally 2*pi*sqrt(1/log(4)).
% Compute transform for range freqList
% h(i,j) is transform at frequency i and time j
% f(i) is the i'th freq. (in Hz)
% t(j) is the j'th time  (in s)
%  
% resolution is time:   sqrt(1/log(4))*resolutionPar / f    (about 1/f)*resolutionPar
%  freq:    f/(2*pi*sqrt(1/log(4)))                         (about f/5)/resolutionPar

  x = shiftdim(x);
  freqList = shiftdim(freqList);
  nfft = length(x);
  if(mod(nfft,2)==1)
    qq = 1;
  else
    qq=0;
  end
  f = freqList;
  t = (0:(nfft-1))/fsamp;
  y = fft(x');
  y = y';
  C = sqrt(fsamp*(2*pi));
  f0 = resolutionPar*sqrt(1/log(4));
  h = zeros(length(f),nfft);
  basef = zeros(length(f),nfft);
  

  basef = (fsamp./f * f0/nfft) * ([0:(nfft+qq)/2-1,-(nfft-qq)/2:-1]);
  basef = exp(-2*pi^2*( (basef-f0).^2));
  tmp = basef * diag(sparse(y));
  clear basef;
  h = ifft(tmp');
  h = h';
  h = C * sqrt(f0) * diag(sparse((1./sqrt(f)))) * h;
    
    
  return
  
  % old code:
      
  for k=1:length(f)
    a = f0/f(k);

    wavelet = exp(-2*(pi)^2*(([0:(nfft+qq)/2-1,-(nfft-qq)/2:-1]*(fsamp*a/nfft))- (f0)).^2);
    


    tmp = wavelet' .* y;
    t1 = ifft(tmp);
    h(k,:) = C*a^0.5*t1;
  end