#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Thu May 17 15:15:53 2018

@author: franckladam
"""

from random import randrange


#function that generates random pieces of chromosome intervals
def randcoord(numRanSeq, interval_size): 
    """ function that returns a list of random chromosomal coordinates
    
    Usage: randcoord(numRanSeq, interval_size)
    
            - numRanSeq: number of random cordinates needed
            - interval_size: size of the coordinates in bp"""

    # ZV11 zebrafish chromosome an sizes
    zv11 = [("chr1", 59578282), ("chr2", 59640629), ("chr3", 62628489), ("chr4", 78093715), ("chr5", 72500376), ("chr6", 60270059), ("chr7", 74282399), ("chr8", 54304671), ("chr9", 56459846), ("chr10", 45420867), ("chr11", 45484837), ("chr12", 49182954), ("chr13", 52186027), ("chr14", 52660232), ("chr15", 48040578), ("chr16", 55266484), ("chr17", 53461100), ("chr18", 51023478), ("chr19", 48449771), ("chr20", 55201332), ("chr21", 45934066), ("chr22", 39133080), ("chr23", 46223584), ("chr24", 42172926), ("chr25", 37502051)]
    
    Sum_size = 0
        
    for ch, s in zv11:
        Sum_size += s
        genome_frac = [(ch, s , s/Sum_size) for ch, s in zv11]

    print("\n\nYour genome is composed of {} chromosomes and contigs for a total size of {}bp".format(len(zv11), Sum_size))


    numSeq = [(ch, round(numRanSeq * f), s) for ch, s, f in genome_frac]
    print("\n\nthe number of random sequences to generate per chromosome is:")
    
    for ch, n, s in numSeq:
        print(ch , n)
    
    total = 0
    for ch, n, s in numSeq:
        total += n
    print("\n\nfor a total of {} random {}bp chromosomal coordinates".format(str(total), interval_size))
    
    liste_rand = list()
    
    for ch, n, s in numSeq:
        compte = n
        while compte !=0:
            rs1 = randrange(s) 
            
            if rs1 != s:
                compte -= 1
                rs2 = rs1 + interval_size
                liste_rand.append((ch, rs1, rs2))

    print(liste_rand)


  
