## NOTE: This code will allow you to plot all figures in the paper.

## Loading objects
load("quant_trait_plotting_objs_t4_elife.RData")

## Packages
library(ggplot2)

## Colors
brewer.pal(5, "Dark2")
display.brewer.pal(5, "Dark2")

## Fig. 4A
l100.var.1.plot <- ggplot(var.100.exp.obs[var.100.exp.obs$Species=="1",], aes(x=as.factor(ILS), y=Variance, group=Type)) +
  geom_point(size=3, color="#66A61E") + geom_line(aes(linetype=Type), color="#66A61E") +
  ylab("Var(A)") + xlab("Discordance (%)") +
  theme(
    panel.grid.major = element_blank(),
    panel.grid.minor = element_blank(),
    panel.border = element_blank(),
    panel.background = element_blank(),
    plot.background = element_blank(),
    axis.line = element_line(),
    axis.ticks = element_line(color="black"),
    axis.text.x = element_text(color="black", size=10),
    axis.text.y = element_text(color="black", size=10),
    axis.title.x = element_text(size=12),
    axis.title.y = element_text(size=12),
    legend.key = element_blank()
  ) + guides(linetype=guide_legend("")) + 
  scale_x_discrete(labels=c("1" = "0", "2" = "15", "3" = "30", "4" = "45", "5" = "60")) +
  scale_linetype_manual(values=c("dashed", "solid"))
l100.var.1.plot

## Fig. 4B
l100.cov.12.plot <- ggplot(cov.100.exp.obs[cov.100.exp.obs$Species=="1 and 2", ], aes(x=as.factor(ILS), y=Covariance, group=Type)) +
  geom_point(size=3, color="#66A61E") + geom_line(aes(linetype=Type), color="#66A61E") +
  ylab("Cov(A,B)") + xlab("Discorance (%)") +
  theme(
    panel.grid.major = element_blank(),
    panel.grid.minor = element_blank(),
    panel.border = element_blank(),
    panel.background = element_blank(),
    plot.background = element_blank(),
    axis.line = element_line(),
    axis.ticks = element_line(color="black"),
    axis.text.x = element_text(color="black", size=10),
    axis.text.y = element_text(color="black", size=10),
    axis.title.x = element_text(size=12),
    axis.title.y = element_text(size=12),
    legend.key = element_blank()
  ) + guides(linetype=guide_legend("")) + 
  scale_x_discrete(labels=c("1" = "0", "2" = "15", "3" = "30", "4" = "45", "5" = "60")) +
  scale_linetype_manual(values=c("dashed", "solid"))
l100.cov.12.plot

## Fig. 5A
l100.cov.13.plot <- ggplot(cov.100.exp.obs[cov.100.exp.obs$Species=="1 and 3", ], aes(x=as.factor(ILS), y=Covariance, group=Type)) +
  geom_point(size=3, color="#66A61E") + geom_line(aes(linetype=Type), color="#66A61E") +
  ylab("Cov(A,C)") + xlab("Discordance (%)") +
  theme(
    panel.grid.major = element_blank(),
    panel.grid.minor = element_blank(),
    panel.border = element_blank(),
    panel.background = element_blank(),
    plot.background = element_blank(),
    axis.line = element_line(),
    axis.ticks = element_line(color="black"),
    axis.text.x = element_text(color="black", size=10),
    axis.text.y = element_text(color="black", size=10),
    axis.title.x = element_text(size=12),
    axis.title.y = element_text(size=12),
    legend.key = element_blank()
  ) + guides(linetype=guide_legend("")) + 
  scale_x_discrete(labels=c("1" = "0", "2" = "15", "3" = "30", "4" = "45", "5" = "60")) +
  scale_linetype_manual(values=c("dashed", "solid"))
l100.cov.13.plot

## Fig 5B
l100.cov.var.plot <- ggplot(cov.var.ratio.100, aes(x=as.factor(ils), y=ratio, group=cov)) +
  geom_point(size=3, color="#66A61E", aes(shape=cov)) + geom_line(color="#66A61E") +
  ylab("Cov : Var")  + xlab("Discordance (%)") +
  theme(
    panel.grid.major = element_blank(),
    panel.grid.minor = element_blank(),
    panel.border = element_blank(),
    panel.background = element_blank(),
    plot.background = element_blank(),
    axis.line = element_line(),
    axis.ticks = element_line(color="black"),
    axis.text.x = element_text(color="black", size=10),
    axis.text.y = element_text(color="black", size=10),
    axis.title.x = element_text(size=12),
    axis.title.y = element_text(size=12),
    legend.key = element_blank()
  ) + guides(shape=guide_legend("")) + 
  scale_x_discrete(labels=c("1" = "0", "2" = "15", "3" = "30", "4" = "45", "5" = "60")) +
  scale_linetype_manual(values=c("dashed", "solid"))
l100.cov.var.plot

## This is part of "results not shown" we mention in the paper
l5.var.1.plot <- ggplot(var.5.exp.obs[var.5.exp.obs$Species=="1",], aes(x=as.factor(ILS), y=Variance, group=Type)) +
  geom_point(size=3, color="#1B9E77") + geom_line(aes(linetype=Type), color="#1B9E77") +
  ylab("Var(A)") + xlab("ILS") +
  theme(
    panel.grid.major = element_blank(),
    panel.grid.minor = element_blank(),
    panel.border = element_blank(),
    panel.background = element_blank(),
    plot.background = element_blank(),
    axis.line = element_line(),
    axis.ticks = element_line(color="black"),
    axis.text.x = element_text(color="black", size=10),
    axis.text.y = element_text(color="black", size=10),
    axis.title.x = element_text(size=12),
    axis.title.y = element_text(size=12),
    legend.key = element_blank()
  ) + guides(linetype=guide_legend(""))
l5.var.1.plot

## This is part of "results not shown" we mention in the paper
l5.cov.12.plot <- ggplot(cov.5.exp.obs[cov.5.exp.obs$Species=="1 and 2", ], aes(x=as.factor(ILS), y=Covariance, group=Type)) +
  geom_point(size=3, color="#1B9E77") + geom_line(aes(linetype=Type), color="#1B9E77") +
  ylab("Cov(A,B)")  + xlab("ILS") +
  theme(
    panel.grid.major = element_blank(),
    panel.grid.minor = element_blank(),
    panel.border = element_blank(),
    panel.background = element_blank(),
    plot.background = element_blank(),
    axis.line = element_line(),
    axis.ticks = element_line(color="black"),
    axis.text.x = element_text(color="black", size=10),
    axis.text.y = element_text(color="black", size=10),
    axis.title.x = element_text(size=12),
    axis.title.y = element_text(size=12),
    legend.key = element_blank()
  ) + guides(linetype=guide_legend(""))
l5.cov.12.plot

## This is part of "results not shown" we mention in the paper
l5.cov.13.plot <- ggplot(cov.5.exp.obs[cov.5.exp.obs$Species=="1 and 3", ], aes(x=as.factor(ILS), y=Covariance, group=Type)) +
  geom_point(size=3, color="#1B9E77") + geom_line(aes(linetype=Type), color="#1B9E77") +
  ylab("Cov(A,C)") + xlab("ILS") +
  theme(
    panel.grid.major = element_blank(),
    panel.grid.minor = element_blank(),
    panel.border = element_blank(),
    panel.background = element_blank(),
    plot.background = element_blank(),
    axis.line = element_line(),
    axis.ticks = element_line(color="black"),
    axis.text.x = element_text(color="black", size=10),
    axis.text.y = element_text(color="black", size=10),
    axis.title.x = element_text(size=12),
    axis.title.y = element_text(size=12),
    legend.key = element_blank()
  ) + guides(linetype=guide_legend(""))
l5.cov.13.plot

## This is part of "results not shown" mentioned in the paper
l5.cov.var.plot <- ggplot(cov.var.ratio.5, aes(x=as.factor(ils), y=ratio, group=cov)) +
  geom_point(size=3, color="#1B9E77", aes(shape=cov)) + geom_line(color="#1B9E77") +
  ylab("Cov : Var")  + xlab("Discordance (%)") +
  theme(
    panel.grid.major = element_blank(),
    panel.grid.minor = element_blank(),
    panel.border = element_blank(),
    panel.background = element_blank(),
    plot.background = element_blank(),
    axis.line = element_line(),
    axis.ticks = element_line(color="black"),
    axis.text.x = element_text(color="black", size=10),
    axis.text.y = element_text(color="black", size=10),
    axis.title.x = element_text(size=12),
    axis.title.y = element_text(size=12),
    legend.key = element_blank()
  ) + guides(shape=guide_legend("")) + 
  scale_x_discrete(labels=c("1" = "0", "2" = "15", "3" = "30", "4" = "45", "5" = "60")) +
  scale_linetype_manual(values=c("dashed", "solid"))
l5.cov.var.plot

## Fig. 6A
rate.plot <- ggplot(mean.rate.3[mean.rate.3$type=="DC + H",], aes(factor(ILS), mean.rate, colour=factor(nloci), group=factor(nloci))) +
  geom_point(size=2) + geom_line() + geom_errorbar(aes(ymin=mean.rate-se, ymax=mean.rate+se), width=.1) +
  ylab("Evolutionary rate") + xlab("Discordance (%)") + ylim(1, 12) +
  theme(
    panel.grid.major = element_blank(),
    panel.grid.minor = element_blank(),
    panel.border = element_blank(),
    panel.background = element_blank(),
    plot.background = element_blank(),
    axis.line = element_line(),
    axis.ticks = element_line(color="black"),
    axis.text.x = element_text(color="black", size=10),
    axis.text.y = element_text(color="black", size=10),
    axis.title.x = element_text(size=12),
    axis.title.y = element_text(size=12),
    legend.key = element_blank()
  ) + labs(colour="Number of loci") + 
  scale_colour_brewer(breaks=c("5", "15", "25", "50", "100"), palette="Dark2") +
  scale_x_discrete(labels=c("1" = "0", "2" = "20", "3" = "40", "4" = "60", "5" = "80"))
rate.plot 

## Not included in the paper (DC-H (2) is the analyses with Pagel's lambda, 
## and DC-H (1) is the "concordantized" data set. 
## The latter was not submitted, but here we made all asymmetric gene trees
## match the species tree -- and got rid of some of the hemiplastic effect on
## the estimated evolutionary rate)
rate.plot.5 <- ggplot(mean.rate.3[mean.rate.3$nloci==5,], aes(factor(ILS), mean.rate, linetype=factor(type), group=factor(type))) +
  geom_point(size=3, colour="#1B9E77") + geom_line(color="#1B9E77") + geom_errorbar(color="#1B9E77", aes(ymin=mean.rate-se, ymax=mean.rate+se), width=.1) +
  ylab("Evolutionary rate") + xlab("ILS") +
  theme(
    panel.grid.major = element_blank(),
    panel.grid.minor = element_blank(),
    panel.border = element_blank(),
    panel.background = element_blank(),
    plot.background = element_blank(),
    axis.line = element_line(),
    axis.ticks = element_line(color="black"),
    axis.text.x = element_text(color="black", size=10),
    axis.text.y = element_text(color="black", size=10),
    axis.title.x = element_text(size=12),
    axis.title.y = element_text(size=12),
    legend.key = element_blank()
  ) + labs(linetype="Observed effect") + scale_linetype_manual(breaks=c("DC + H", "DC - H (1)", "DC - H (2)"), values=c("dotted", "longdash", "solid"))
rate.plot.5

## Fig. 6C
rate.plot.100 <- ggplot(mean.rate.3[mean.rate.3$nloci==100 & mean.rate.3$type!="DC - H (1)",], aes(factor(ILS), mean.rate, linetype=factor(type), group=factor(type))) +
  geom_point(size=2, colour="#66A61E") + geom_line(color="#66A61E") + geom_errorbar(color="#66A61E", aes(ymin=mean.rate-se, ymax=mean.rate+se), width=.1) +
  ylab("Evolutionary rate") + xlab("Discordance (%)") + ylim(1, 12) +
  theme(
    panel.grid.major = element_blank(),
    panel.grid.minor = element_blank(),
    panel.border = element_blank(),
    panel.background = element_blank(),
    plot.background = element_blank(),
    axis.line = element_line(),
    axis.ticks = element_line(color="black"),
    axis.text.x = element_text(color="black", size=10),
    axis.text.y = element_text(color="black", size=10),
    axis.title.x = element_text(size=12),
    axis.title.y = element_text(size=12),
    legend.key = element_blank()
  ) + labs(linetype="Observed effect") +
  scale_linetype_manual(breaks=c("DC + H", "DC - H (2)"), values=c("longdash", "solid"), labels=c("DC + H", "DC - H")) +
  scale_x_discrete(labels=c("1" = "0", "2" = "20", "3" = "40", "4" = "60", "5" = "80"))
rate.plot.100 

## Not included in the paper (DC-H (1) is the "concordantized" data set. 
## The latter was not submitted, but here we made all asymmetric gene trees
## match the species tree -- and got rid of some of the hemiplastic effect on
## the estimated evolutionary rate)
## Note that this graph shows that "concordantization" works, especially when
## ILS is high
l5.cov.plot <- ggplot(mean.cov.5.both, aes(x=as.factor(ILS), y=Covariance, group=interaction(Species,type))) +
  geom_point(size=3, aes(color=Species)) + geom_line(aes(linetype=type, color=Species)) +
  ylab("Covariance between species") + xlab("Discordance (%)") +
  theme(
    panel.grid.major = element_blank(),
    panel.grid.minor = element_blank(),
    panel.border = element_blank(),
    panel.background = element_blank(),
    plot.background = element_blank(),
    axis.line = element_line(),
    axis.ticks = element_line(color="black"),
    axis.text.x = element_text(color="black", size=10),
    axis.text.y = element_text(color="black", size=10),
    axis.title.x = element_text(size=12),
    axis.title.y = element_text(size=12),
    legend.key = element_blank()
  ) + guides(linetype=guide_legend("Effect type", order=1), colour=guide_legend("Pair of species", order=2)) + scale_colour_manual(values=rev(c("#FFFFFF", "#D1EBE3", "#A3D8C8", "#76C4AD", "#48B192", "#1B9E77"))) +
  scale_linetype_manual(breaks=c("DC + H", "DC - H (1)"), values=c("longdash", "solid")) +
  scale_x_discrete(labels=c("1" = "0", "2" = "20", "3" = "40", "4" = "60", "5" = "80"))
l5.cov.plot

## Also did not make it to the paper. Same as above, but with 100 loci.
l100.cov.plot <- ggplot(mean.cov.100.both, aes(x=as.factor(ILS), y=Covariance, group=interaction(Species,type))) +
  geom_point(size=3, aes(color=Species)) + geom_line(aes(linetype=type, color=Species)) +
  ylab("Covariance between species") + xlab("ILS") +
  theme(
    panel.grid.major = element_blank(),
    panel.grid.minor = element_blank(),
    panel.border = element_blank(),
    panel.background = element_blank(),
    plot.background = element_blank(),
    axis.line = element_line(),
    axis.ticks = element_line(color="black"),
    axis.text.x = element_text(color="black", size=10),
    axis.text.y = element_text(color="black", size=10),
    axis.title.x = element_text(size=12),
    axis.title.y = element_text(size=12),
    legend.key = element_blank()
  ) + guides(colour=guide_legend("Pair of species", order=2), linetype=guide_legend("Effect type", order=1)) + scale_colour_manual(values=rev(c("#FFFFFF", "#E0EDD2", "#C1DBA4", "#A3C977", "#84B74A", "#66A61E"))) +
  scale_linetype_manual(breaks=c("DC + H", "DC - H (1)"), values=c("longdash", "solid"))
l100.cov.plot

## Did not make it to the paper. DC - H (1) is explained above.
## This was just verifying that variances go up with ILS, for 5 loci.
l5.var.plot <- ggplot(mean.var.5.both, aes(x=as.factor(ILS), y=Variance, group=interaction(Species,type))) +
  geom_point(size=3, aes(color=Species)) + geom_line(aes(linetype=type, color=Species)) +
  ylab("Variance within species") + xlab("ILS") +
  theme(
    panel.grid.major = element_blank(),
    panel.grid.minor = element_blank(),
    panel.border = element_blank(),
    panel.background = element_blank(),
    plot.background = element_blank(),
    axis.line = element_line(),
    axis.ticks = element_line(color="black"),
    axis.text.x = element_text(color="black", size=10),
    axis.text.y = element_text(color="black", size=10),
    axis.title.x = element_text(size=12),
    axis.title.y = element_text(size=12),
    legend.key = element_blank()
  ) + guides(linetype=guide_legend("Effect type", order=1), colour=guide_legend("Species", order=2)) + scale_colour_manual(values=rev(c("#FFFFFF", "#D1EBE3", "#A3D8C8", "#76C4AD", "#48B192", "#1B9E77"))) +
  scale_linetype_manual(breaks=c("DC + H", "DC - H (1)"), values=c("longdash", "solid"))
l5.var.plot

## Did not make it to the paper. DC - H (1) is explained above.
## This was just verifying that variances go up with ILS, for 100 loci.
l100.var.plot <- ggplot(mean.var.100.both, aes(x=as.factor(ILS), y=Variance, group=interaction(Species,type))) +
  geom_point(size=3, aes(color=Species)) + geom_line(aes(linetype=type, color=Species)) +
  ylab("Variance within species") + xlab("ILS") +
  theme(
    panel.grid.major = element_blank(),
    panel.grid.minor = element_blank(),
    panel.border = element_blank(),
    panel.background = element_blank(),
    plot.background = element_blank(),
    axis.line = element_line(),
    axis.ticks = element_line(color="black"),
    axis.text.x = element_text(color="black", size=10),
    axis.text.y = element_text(color="black", size=10),
    axis.title.x = element_text(size=12),
    axis.title.y = element_text(size=12),
    legend.key = element_blank()
  ) + guides(linetype=guide_legend("Effect type", order=1), colour=guide_legend("Species", order=2)) + scale_colour_manual(values=rev(c("#FFFFFF", "#E0EDD2", "#C1DBA4", "#A3C977", "#84B74A", "#66A61E"))) +
  scale_linetype_manual(breaks=c("DC + H", "DC - H (1)"), values=c("longdash", "solid"))
l100.var.plot

## Fig. 6B
lambda.plot <- ggplot(mean.lambda, aes(factor(ILS), mean.lambda, colour=factor(nloci), group=factor(nloci))) +
  geom_point(size=2) + geom_line() + geom_errorbar(aes(ymin=mean.lambda-se, ymax=mean.lambda+se), width=.1) +
  ylab(expression(paste("Pagel's ",lambda))) + xlab("Discordance (%)") +
  theme(
    panel.grid.major = element_blank(),
    panel.grid.minor = element_blank(),
    panel.border = element_blank(),
    panel.background = element_blank(),
    plot.background = element_blank(),
    axis.line = element_line(),
    axis.ticks = element_line(color="black"),
    axis.text.x = element_text(color="black", size=10),
    axis.text.y = element_text(color="black", size=10),
    axis.title.x = element_text(size=12),
    axis.title.y = element_text(size=12),
    legend.key = element_blank()
  ) + labs(colour="Number of loci") +
  scale_colour_brewer(breaks=c("5", "15", "25", "50", "100"), palette="Dark2") +
  scale_x_discrete(labels=c("1" = "0", "2" = "20", "3" = "40", "4" = "60", "5" = "80"))
lambda.plot

## Fig. 7
phaov.plot <- ggplot(mean.phaov, aes(factor(ILS), mean.phaov, colour=factor(nloci), group=factor(nloci))) +
  geom_point(size=2) + geom_line() + geom_errorbar(aes(ymin=mean.phaov-se, ymax=mean.phaov+se), width=.1) +
  ylab("Mean number of independent shifts\n(Pairwise phylogenetic ANOVA)") + xlab("Discordance (%)") + ylim(.4, .75) +
  theme(
    panel.grid.major = element_blank(),
    panel.grid.minor = element_blank(),
    panel.border = element_blank(),
    panel.background = element_blank(),
    plot.background = element_blank(),
    axis.line = element_line(),
    axis.ticks = element_line(color="black"),
    axis.text.x = element_text(color="black", size=10),
    axis.text.y = element_text(color="black", size=10),
    axis.title.x = element_text(size=12),
    axis.title.y = element_text(size=12),
    legend.key = element_blank()
  ) + labs(colour="Number of loci") +
  scale_colour_brewer(breaks=c("5", "15", "25", "50", "100"), palette="Dark2") +
  scale_x_discrete(labels=c("1" = "0", "2" = "20", "3" = "40", "4" = "60", "5" = "80"))
phaov.plot

## Fig. 8
trait.pats.plot <- ggplot(trait.5.pats.df.tab[trait.5.pats.df.tab$type=="Incongruent",], aes(factor(ILS), pctg, colour=factor(nloci), group=factor(nloci))) +
  geom_point(size=2) + geom_line() +
  ylab("Incongruent trait pattern percentage") + xlab("Discordance (%)") +
  theme(
    panel.grid.major = element_blank(),
    panel.grid.minor = element_blank(),
    panel.border = element_blank(),
    panel.background = element_blank(),
    plot.background = element_blank(),
    axis.line = element_line(),
    axis.ticks = element_line(color="black"),
    axis.text.x = element_text(color="black", size=10),
    axis.text.y = element_text(color="black", size=10),
    axis.title.x = element_text(size=12),
    axis.title.y = element_text(size=12),
    legend.key = element_blank()
  ) + labs(colour="Number of loci") +
  scale_colour_brewer(breaks=c("5", "15", "25", "50", "100"), palette="Dark2") +
  scale_x_discrete(labels=c("1" = "0", "2" = "20", "3" = "40", "4" = "60", "5" = "80"))
trait.pats.plot