function run_for_fig6()

% Christopher R. Fetsch, Naomi N. Odean, Danique Jeurissen,
% Yasmine El-Shamayleh, Gregory D. Horwitz, and Michael N. Shadlen
% Focal optogenetic suppression in macaque area MT biases direction
% discrimination and decision confidence, but only transiently

% CRF, with code from MNS and former lab members, especially Roozbeh Kiani

addpath('./functions')
load(fullfile('data','data.mat'));

% d is a struct with the following fields
% coh: signed motion coherence (positive = neurons' preferred direction)
% strg: presence/absence of sure-bet target (opt-out option)
% duration: viewing duration in ms
% trialNum*: trial number within session
% laser: presence/absence of laser (photosuppression)
% choice: 1 = null (antipreferred) direction, 2 = preferred direction, 3 = sure bet (opt-out)
% deltaFR: fractional change in firing rate due to photosuppression (see text)
% sessionID: index of behavioral+photosuppression sessions (1 through 23)

% *(In our setup, the trial number variable incremented even after an
% aborted trial (e.g. fixation break), and thus is slightly greater than
% the number of completed/valid trials. We made no assumptions about whether
% the most relevant variable is completed trials, all trials, or elapsed
% time, but typically treated this variable as a proxy for all three.)


% ***
% for Figure 6-figure supplement 2, uncomment lines 38 and 178
% ***

%% Fig 6A: behavioral effects as a function of trialNum (sliding window)

windowSize = 7000; % not the final number of trials in each window, see ntrials_sliding for that
windowStep = 50; % change to 10 for paper figure (slower)
minWindowSize = 5000;
% selectTrials = (d.deltaFR < -0.25 | isnan(d.deltaFR)) & d.duration < 300;
    %^ trials with at least moderate suppression, and short dur
% OR do this selection within each trialNum sliding window below (which is
% what we did for the paper, for legacy reasons), in which case start with all tr
selectTrials = true(size(d.trialNum));
% selectTrials = selectTrials & d.sessionID ~= 18; % exclude one 'paradoxical site' (see Methods, Figure 6 - figure supplement 2)

trialNum = d.trialNum;
% label excluded trials in a sortable way
trialNum(~selectTrials) = 0;
[trialNum_sorted,trialNum_sorted_ind] = sort(trialNum);
endOfDiscardedTrials = find(trialNum_sorted==0,1,'last');
if isempty(endOfDiscardedTrials); endOfDiscardedTrials=0; end;
nTrials = sum(selectTrials);

% generate sliding windows
startOfWindow = 1;
endOfWindow = windowSize;
w=0;
while endOfWindow < nTrials
    w = w + 1;
    windows{w} = startOfWindow:endOfWindow;
    startOfWindow = startOfWindow + windowStep;
    endOfWindow = endOfWindow + windowStep;
end

trialNum_set =    cell(1,length(windows));
trialNum_ind_set = cell(1,length(windows));
plotW = nan(size(trialNum_set));

% find trial indices corresponding to trialNum in each window
for w = 1:length(windows)
    trialNum_ind_set{w} = trialNum_sorted_ind(windows{w}+endOfDiscardedTrials);
    trialNum_set{w} = [min(trialNum(trialNum_ind_set{w})) max(trialNum(trialNum_ind_set{w}))];
    plotW(w) = nanmean(trialNum(trialNum_ind_set{w}));
end
lastWindowWouldBe = windows{end}(1)+windowStep:nTrials;
if length(lastWindowWouldBe) > minWindowSize
    w=w+1;
    windows{w} = lastWindowWouldBe;
    trialNum_ind_set{w} = trialNum_sorted_ind(windows{w}+endOfDiscardedTrials);
    trialNum_set{w} = [min(trialNum(trialNum_ind_set{w})) max(trialNum(trialNum_ind_set{w}))];
    plotW(w) = nanmean(trialNum(trialNum_ind_set{w}));
end
    
%
% fit Eqs 1 and 3 for each sliding window
%
var = nan(2,length(trialNum_set));
err = nan(2,length(trialNum_set));
ntrials_sliding = nan(1,length(trialNum_set));
for p = 1:length(trialNum_set)
      
    if mod(p,20)==0
        sprintf('Progress: %d out of %d',p,length(trialNum_set))
    end
        
    thisI = selectTrials; % reinitialize

    % here we select trials based on deltaFR and duration, *within* each
    % trialNum window; could also do it outside the loop (see above)
    thisI = thisI & (d.deltaFR < -0.25 | isnan(d.deltaFR)) & d.duration <= median(d.duration);
        %^ trials with at least moderate suppression, and short dur
    
    % now tag the right trialNums for this window
    tempind = false(size(thisI));
    tempind(trialNum_ind_set{p}) = true;
    thisI = thisI & tempind;

    ntrials_sliding(p) = sum(thisI);
    
    coh_ = d.coh(thisI);
    strg_ = d.strg(thisI);
    laser_ = d.laser(thisI);
    choice_ = d.choice(thisI);
    
    prefTarg = 2; % by convention, choice=2 corresponds to the pref dir

    % choice (logistic, Eq. 1 in text)
    I = ismember(choice_,[1 2]);
    X = [coh_(I) laser_(I) coh_(I).*laser_(I)];
    y = choice_(I)==prefTarg;
    [beta_glm, ~, stats] = glmfit(X, y, 'binomial');
    choice_shift = beta_glm(3)/beta_glm(2) * 100;
    choice_shift_se = stats.se(3)/beta_glm(2) * 100;

    % confidence (Eq. 3 in text)
    psure_fcn_b4 = @(b,coh,IL) min(max(b(1),0),1).*exp(-(coh+b(3)+b(4)*IL).^2 ./ (2*b(2).^2));
        % error to minimize is negative log likelihood of observing the data, which is: -[ log(Psurebet) + log(1-(~Psurebet)) ]
    err_fcn_b4 = @(param,choice,coh,IL) -(sum(log(psure_fcn_b4(param,coh(choice),IL(choice))))+sum(log(1-psure_fcn_b4(param,coh(~choice),IL(~choice)))));

    J = strg_==1; % trials with sure-bet target available
    x0 = [0.6 0.25 -.003 .02];
    opts = optimset('MaxFunEvals', 1e6, 'Algorithm','interior-point','LargeScale','off','Display','off');
    try
    [Psure_beta,~,~,~,~,hessian] = fminunc(@(x) err_fcn_b4(x,choice_(J)==3,coh_(J),laser_(J)==1), x0, opts);
    se = sqrt(diag(inv(hessian)));
    Psure_shift = Psure_beta(4)*100;
    Psure_shift_se = se(4)*100;
    catch
    Psure_shift = NaN;    
    Psure_shift_se = NaN;
    end

    var(1,p) = choice_shift;
    var(2,p) = Psure_shift;

    err(1,p) = choice_shift_se;
    err(2,p) = Psure_shift_se;

end


%
% plot it
%
figure; set(gcf, 'Color', [1 1 1], 'Position', [100 100 600 400], 'PaperPositionMode', 'auto');
[~, hp] = boundedline(plotW,var(1,:),err(1,:), 'r-', ...
           plotW,var(2,:),err(2,:),'b-','alpha','transparency', 0.15);
xlabel('Trial number within session');
ylabel('Behavioral effect (%coh)');
xlim([round(plotW(1)-0.2*plotW(1)) round(plotW(end)+0.2*plotW(1))]);
ylim([-13.5 13.5]);
set(gca,'Ytick',-12:4:12,'Xtick',0:200:1200,'Xticklabel',{'0' '200' '400' '600' '800' '1000' '1200'});

xl = xlim;
plot([xl(1) xl(2)],[0 0],'k--');
H = legend(hp,'choice','confidence','Location','Northwest');
set(H,'FontSize',20)
legend('boxoff');     
set(gca,'TickDir','out','box','off');
title('6A');
changeAxesFontSize(gca,17,17);


%% Fig 6B: behavioral effects as a function of duration (sliding window)

clear windows
windowSize = 4500; % not the final number of trials in each window, see ntrials_sliding for that
windowStep = 50; % change to 10 for paper figure (slower)
minWindowSize = 3500;
% selectTrials = (d.deltaFR < -0.25 | isnan(d.deltaFR)) & d.trialNum <= 540;;
    %^ trials with at least moderate suppression, and early in session
% OR do this selection within each trialNum sliding window below (which is
% what we did for the paper, for legacy reasons), in which case start with all tr
selectTrials = true(size(d.duration));
% selectTrials = selectTrials & d.sessionID ~= 18; % exclude one 'paradoxical site' (see Methods, Figure 6 - figure supplement 2)


dur = d.duration;
% label excluded trials in a sortable way
dur(~selectTrials) = 0;
[dur_sorted,dur_sorted_ind] = sort(dur);
endOfDiscardedTrials = find(dur_sorted==0,1,'last');
if isempty(endOfDiscardedTrials); endOfDiscardedTrials=0; end;
nTrials = sum(selectTrials);

% generate sliding windows
startOfWindow = 1;
endOfWindow = windowSize;
w=0;
while endOfWindow < nTrials
    w = w + 1;
    windows{w} = startOfWindow:endOfWindow;
    startOfWindow = startOfWindow + windowStep;
    endOfWindow = endOfWindow + windowStep;
end

dur_set =    cell(1,length(windows));
dur_ind_set = cell(1,length(windows));
plotW = nan(size(dur_set));

% find trial indices corresponding to dur in each window
for w = 1:length(windows)
    dur_ind_set{w} = dur_sorted_ind(windows{w}+endOfDiscardedTrials);
    dur_set{w} = [min(dur(dur_ind_set{w})) max(dur(dur_ind_set{w}))];
    plotW(w) = nanmean(dur(dur_ind_set{w}));
end
lastWindowWouldBe = windows{end}(1)+windowStep:nTrials;
if length(lastWindowWouldBe) > minWindowSize
    w = w + 1;
    windows{w} = lastWindowWouldBe;
    dur_ind_set{w} = dur_sorted_ind(windows{w}+endOfDiscardedTrials);
    dur_set{w} = [min(dur(dur_ind_set{w})) max(dur(dur_ind_set{w}))];
    plotW(w) = nanmean(dur(dur_ind_set{w}));
end


%
% fit Eqs 1 and 3 for each sliding window
%
var = nan(2,length(dur_set));
err = nan(2,length(dur_set));
ntrials_sliding = nan(1,length(dur_set));
for p = 1:length(dur_set)
      
    if mod(p,20)==0
        sprintf('Progress: %d out of %d',p,length(dur_set))
    end
        
    thisI = selectTrials; % reinitialize

%     % original
%     thisI = false(size(selectTrials));
%     thisI(dur_ind_set{p}) = true;
%     thisI = thisI & d.trialNum <= 540;
%     thisI = thisI & (d.deltaFR < -0.25 | isnan(d.deltaFR));

    % here we select trials based on deltaFR and duration, *within* each
    % dur window; could also do it outside the loop (see above)
    thisI = thisI & (d.deltaFR < -0.25 | isnan(d.deltaFR)) & d.trialNum <= 540;
        %^ trials with at least moderate suppression, and short dur
    % now tag the right durs for this window
    tempind = false(size(thisI));
    tempind(dur_ind_set{p}) = true;
    thisI = thisI & tempind;

    ntrials_sliding(p) = sum(thisI);
    
    coh_ = d.coh(thisI);
    strg_ = d.strg(thisI);
    laser_ = d.laser(thisI);
    choice_ = d.choice(thisI);
    
    prefTarg = 2; % by convention, choice=2 corresponds to the pref dir

    % choice (logistic, Eq. 1 in text)
    I = ismember(choice_,[1 2]);
    X = [coh_(I) laser_(I) coh_(I).*laser_(I)];
    y = choice_(I)==prefTarg;
    [beta_glm, ~, stats] = glmfit(X, y, 'binomial');
    choice_shift = beta_glm(3)/beta_glm(2) * 100;
    choice_shift_se = stats.se(3)/beta_glm(2) * 100;

    % confidence (Eq. 3 in text)
    psure_fcn_b4 = @(b,coh,IL) min(max(b(1),0),1).*exp(-(coh+b(3)+b(4)*IL).^2 ./ (2*b(2).^2));
        % error to minimize is negative log likelihood of observing the data, which is: -[ log(Psurebet) + log(1-(~Psurebet)) ]
    err_fcn_b4 = @(param,choice,coh,IL) -(sum(log(psure_fcn_b4(param,coh(choice),IL(choice))))+sum(log(1-psure_fcn_b4(param,coh(~choice),IL(~choice)))));

    J = strg_==1; % trials with sure-bet target available
    x0 = [0.6 0.25 -.003 .02];
    opts = optimset('MaxFunEvals', 1e6, 'Algorithm','interior-point','LargeScale','off','Display','off');
    try
    [Psure_beta,~,~,~,~,hessian] = fminunc(@(x) err_fcn_b4(x,choice_(J)==3,coh_(J),laser_(J)==1), x0, opts);
    se = sqrt(diag(inv(hessian)));
    Psure_shift = Psure_beta(4)*100;
    Psure_shift_se = se(4)*100;
    catch
    Psure_shift = NaN;    
    Psure_shift_se = NaN;
    end

    var(1,p) = choice_shift;
    var(2,p) = Psure_shift;

    err(1,p) = choice_shift_se;
    err(2,p) = Psure_shift_se;

end


%
% plot it
%
figure; set(gcf, 'Color', [1 1 1], 'Position', [100 100 600 400], 'PaperPositionMode', 'auto');
[~, hp] = boundedline(plotW,var(1,:),err(1,:), 'r-', ...
           plotW,var(2,:),err(2,:),'b-','alpha','transparency', 0.15);
xlabel('Stimulus/laser duration (ms)');
ylabel('Behavioral effect (%coh)');
% xlim([plotW(1) plotW(end)]);
xlim([148 650]);ylim([-13.5 13.5]);
set(gca,'Ytick',-12:4:12,'Xtick',150:100:650);
set(gca,'Xscale','log','TickDir','out','box','off');

xl = xlim;
plot([xl(1) xl(2)],[0 0],'k--');
H = legend(hp,'choice','confidence','Location','Northwest');
set(H,'FontSize',20)
legend('boxoff');     
set(gca,'TickDir','out','box','off');
title('6B');
changeAxesFontSize(gca,17,17);


%% Fig 6 - Fig Suppl 1: Effects of Stim (monkey D) as a function of trial number and duration

clear
load(fullfile('data','data_ustim_monkeyD.mat'));

%%%%%% A %%%%%% 

windowSize = 5500; % not the final number of trials in each window, see ntrials_sliding for that
windowStep = 100;
minWindowSize = 4500;
selectTrials = true(size(d.trialNum));

trialNum = d.trialNum;
% label excluded trials in a sortable way
trialNum(~selectTrials) = 0;
[trialNum_sorted,trialNum_sorted_ind] = sort(trialNum);
endOfDiscardedTrials = find(trialNum_sorted==0,1,'last');
if isempty(endOfDiscardedTrials); endOfDiscardedTrials=0; end;
nTrials = sum(selectTrials);

% generate sliding windows
startOfWindow = 1;
endOfWindow = windowSize;
w=0;
while endOfWindow < nTrials
    w = w + 1;
    windows{w} = startOfWindow:endOfWindow;
    startOfWindow = startOfWindow + windowStep;
    endOfWindow = endOfWindow + windowStep;
end

trialNum_set =    cell(1,length(windows));
trialNum_ind_set = cell(1,length(windows));
plotW = nan(size(trialNum_set));

% find trial indices corresponding to trialNum in each window
for w = 1:length(windows)
    trialNum_ind_set{w} = trialNum_sorted_ind(windows{w}+endOfDiscardedTrials);
    trialNum_set{w} = [min(trialNum(trialNum_ind_set{w})) max(trialNum(trialNum_ind_set{w}))];
    plotW(w) = nanmean(trialNum(trialNum_ind_set{w}));
end
lastWindowWouldBe = windows{end}(1)+windowStep:nTrials;
if length(lastWindowWouldBe) > minWindowSize
    w=w+1;
    windows{w} = lastWindowWouldBe;
    trialNum_ind_set{w} = trialNum_sorted_ind(windows{w}+endOfDiscardedTrials);
    trialNum_set{w} = [min(trialNum(trialNum_ind_set{w})) max(trialNum(trialNum_ind_set{w}))];
    plotW(w) = nanmean(trialNum(trialNum_ind_set{w}));
end
    
%
% fit Eqs 1 and 3 for each sliding window
%
var = nan(2,length(trialNum_set));
err = nan(2,length(trialNum_set));
ntrials_sliding = nan(1,length(trialNum_set));
for p = 1:length(trialNum_set)
      
    if mod(p,20)==0
        sprintf('Progress: %d out of %d',p,length(trialNum_set))
    end
        
    thisI = selectTrials; % reinitialize

    % now tag the right trialNums for this window
    tempind = false(size(thisI));
    tempind(trialNum_ind_set{p}) = true;
    thisI = thisI & tempind;

    ntrials_sliding(p) = sum(thisI);
    
    coh_ = d.coh(thisI);
    strg_ = d.strg(thisI);
    ustim_ = d.ustim(thisI);
    choice_ = d.choice(thisI);
    
    prefTarg = 2; % by convention, choice=2 corresponds to the pref dir

    % choice (logistic, Eq. 1 in text)
    I = ismember(choice_,[1 2]);
    X = [coh_(I) ustim_(I) coh_(I).*ustim_(I)];
    y = choice_(I)==prefTarg;
    [beta_glm, ~, stats] = glmfit(X, y, 'binomial');
    choice_shift = beta_glm(3)/beta_glm(2) * 100;
    choice_shift_se = stats.se(3)/beta_glm(2) * 100;

    % confidence (Eq. 3 in text)
    psure_fcn_b4 = @(b,coh,IL) min(max(b(1),0),1).*exp(-(coh+b(3)+b(4)*IL).^2 ./ (2*b(2).^2));
        % error to minimize is negative log likelihood of observing the data, which is: -[ log(Psurebet) + log(1-(~Psurebet)) ]
    err_fcn_b4 = @(param,choice,coh,IL) -(sum(log(psure_fcn_b4(param,coh(choice),IL(choice))))+sum(log(1-psure_fcn_b4(param,coh(~choice),IL(~choice)))));

    J = strg_==1; % trials with sure-bet target available
    x0 = [0.6 0.25 -.003 .02];
    opts = optimset('MaxFunEvals', 1e6, 'Algorithm','interior-point','LargeScale','off','Display','off');
    try
    [Psure_beta,~,~,~,~,hessian] = fminunc(@(x) err_fcn_b4(x,choice_(J)==3,coh_(J),ustim_(J)==1), x0, opts);
    se = sqrt(diag(inv(hessian)));
    Psure_shift = Psure_beta(4)*100;
    Psure_shift_se = se(4)*100;
    catch
    Psure_shift = NaN;    
    Psure_shift_se = NaN;
    end

    var(1,p) = choice_shift;
    var(2,p) = Psure_shift;

    err(1,p) = choice_shift_se;
    err(2,p) = Psure_shift_se;

end


%
% plot it
%
figure; set(gcf, 'Color', [1 1 1], 'Position', [100 100 600 400], 'PaperPositionMode', 'auto');
[~, hp] = boundedline(plotW,var(1,:),err(1,:), 'r-', ...
           plotW,var(2,:),err(2,:),'b-','alpha','transparency', 0.15);
xlabel('Trial number within session');
ylabel('Behavioral effect (%coh)');
xlim([round(plotW(1)-0.2*plotW(1)) 900]);
ylim([-4 12]);
set(gca,'Ytick',-4:4:12,'Xtick',100:200:900);

xl = xlim;
plot([xl(1) xl(2)],[0 0],'k--');
H = legend(hp,'choice','confidence','Location','Southwest');
set(H,'FontSize',20)
legend('boxoff');     
set(gca,'TickDir','out','box','off');
title('6-Supp1A');
changeAxesFontSize(gca,17,17);



%%%%%% B %%%%%% 

clear windows
windowSize = 6000; % not the final number of trials in each window, see ntrials_sliding for that
windowStep = 100; % change to 10 for paper figure (slower)
minWindowSize = 4500;
selectTrials = true(size(d.duration));


dur = d.duration;
% label excluded trials in a sortable way
dur(~selectTrials) = 0;
[dur_sorted,dur_sorted_ind] = sort(dur);
endOfDiscardedTrials = find(dur_sorted==0,1,'last');
if isempty(endOfDiscardedTrials); endOfDiscardedTrials=0; end;
nTrials = sum(selectTrials);

% generate sliding windows
startOfWindow = 1;
endOfWindow = windowSize;
w=0;
while endOfWindow < nTrials
    w = w + 1;
    windows{w} = startOfWindow:endOfWindow;
    startOfWindow = startOfWindow + windowStep;
    endOfWindow = endOfWindow + windowStep;
end

dur_set =    cell(1,length(windows));
dur_ind_set = cell(1,length(windows));
plotW = nan(size(dur_set));

% find trial indices corresponding to dur in each window
for w = 1:length(windows)
    dur_ind_set{w} = dur_sorted_ind(windows{w}+endOfDiscardedTrials);
    dur_set{w} = [min(dur(dur_ind_set{w})) max(dur(dur_ind_set{w}))];
    plotW(w) = nanmean(dur(dur_ind_set{w}));
end
lastWindowWouldBe = windows{end}(1)+windowStep:nTrials;
if length(lastWindowWouldBe) > minWindowSize
    w = w + 1;
    windows{w} = lastWindowWouldBe;
    dur_ind_set{w} = dur_sorted_ind(windows{w}+endOfDiscardedTrials);
    dur_set{w} = [min(dur(dur_ind_set{w})) max(dur(dur_ind_set{w}))];
    plotW(w) = nanmean(dur(dur_ind_set{w}));
end


%
% fit Eqs 1 and 3 for each sliding window
%
var = nan(2,length(dur_set));
err = nan(2,length(dur_set));
ntrials_sliding = nan(1,length(dur_set));
for p = 1:length(dur_set)
      
    if mod(p,20)==0
        sprintf('Progress: %d out of %d',p,length(dur_set))
    end
        
    thisI = selectTrials; % reinitialize

    % now tag the right durs for this window
    tempind = false(size(thisI));
    tempind(dur_ind_set{p}) = true;
    thisI = thisI & tempind;

    ntrials_sliding(p) = sum(thisI);
    
    coh_ = d.coh(thisI);
    strg_ = d.strg(thisI);
    ustim_ = d.ustim(thisI);
    choice_ = d.choice(thisI);
    
    prefTarg = 2; % by convention, choice=2 corresponds to the pref dir

    % choice (logistic, Eq. 1 in text)
    I = ismember(choice_,[1 2]);
    X = [coh_(I) ustim_(I) coh_(I).*ustim_(I)];
    y = choice_(I)==prefTarg;
    [beta_glm, ~, stats] = glmfit(X, y, 'binomial');
    choice_shift = beta_glm(3)/beta_glm(2) * 100;
    choice_shift_se = stats.se(3)/beta_glm(2) * 100;

    % confidence (Eq. 3 in text)
    psure_fcn_b4 = @(b,coh,IL) min(max(b(1),0),1).*exp(-(coh+b(3)+b(4)*IL).^2 ./ (2*b(2).^2));
        % error to minimize is negative log likelihood of observing the data, which is: -[ log(Psurebet) + log(1-(~Psurebet)) ]
    err_fcn_b4 = @(param,choice,coh,IL) -(sum(log(psure_fcn_b4(param,coh(choice),IL(choice))))+sum(log(1-psure_fcn_b4(param,coh(~choice),IL(~choice)))));

    J = strg_==1; % trials with sure-bet target available
    x0 = [0.6 0.25 -.003 .02];
    opts = optimset('MaxFunEvals', 1e6, 'Algorithm','interior-point','LargeScale','off','Display','off');
    try
    [Psure_beta,~,~,~,~,hessian] = fminunc(@(x) err_fcn_b4(x,choice_(J)==3,coh_(J),ustim_(J)==1), x0, opts);
    se = sqrt(diag(inv(hessian)));
    Psure_shift = Psure_beta(4)*100;
    Psure_shift_se = se(4)*100;
    catch
    Psure_shift = NaN;    
    Psure_shift_se = NaN;
    end

    var(1,p) = choice_shift;
    var(2,p) = Psure_shift;

    err(1,p) = choice_shift_se;
    err(2,p) = Psure_shift_se;

end


%
% plot it
%
figure; set(gcf, 'Color', [1 1 1], 'Position', [100 100 600 400], 'PaperPositionMode', 'auto');
[~, hp] = boundedline(plotW,var(1,:),err(1,:), 'r-', ...
           plotW,var(2,:),err(2,:),'b-','alpha','transparency', 0.15);
xlabel('Stimulus/stim duration (ms)');
ylabel('Behavioral effect (%coh)');
xlim([120 500]); ylim([-4 12]);
set(gca,'Ytick',-4:4:12,'Xtick',[120 200 300 400 500]);
set(gca,'Xscale','log','TickDir','out','box','off');

xl = xlim;
plot([xl(1) xl(2)],[0 0],'k--');
H = legend(hp,'choice','confidence','Location','Southwest');
set(H,'FontSize',20)
legend('boxoff');     
set(gca,'TickDir','out','box','off');
title('6-Supp1B');
changeAxesFontSize(gca,17,17);




