function [x_,y_,se_] = running_mean(x, y, chunklen, flag, data_type)
%
% function [x_,y_, se_] = running_mean ( x , y , chunklen , flag )
%
% calculate the running mean of y on the axis defined by x
%
% if flag is 'data_point', the default, chunklen defines the
% number of data points, around each value of x, that will be used for
% the calculation of running mean.
% if flag is 'window_width' chunklen will be interpreted as the size of the
% window, in units of x, that will be used for the calculation of running 
% mean.
% 

% RK, 12/19/2006 
% RK, 2/24/2010, the function also returns se_, the standard error of the running mean

if nargin<4 || isempty(flag)
    flag = 'data_point';
end

if nargin<5 || isempty(data_type)
    data_type = 'continuous';
end

I = ~isnan(x) & ~isnan(y);
x = x(I);
y = y(I);

[x_,I] = sort(x);
y = y(I);
y_ = nan(size(x_));
se_ = nan(size(y_));

switch flag
    case 'data_point'        
        for d = 1 : length(x_)
            I = find(x_==x_(d));
            prop = round((chunklen-length(I))/2);
            if prop<0
                prop = 0;
            end
            minI = max(1, I(1)-prop);
            maxI = min(I(end)+prop, length(y));
            y_(d) = mean(y(minI:maxI));
            if nargout>2
                switch data_type
                    case 'continuous'
                        se_(d) = std(y(minI:maxI))/sqrt(maxI-minI+1);
                    case 'binary'
                        se_(d) = sqrt(y_(d)*(1-y_(d))/(maxI-minI+1));
                end
            end
        end
        
    case 'window_width'
        for d = 1 : length(x_)
            I = (x_>=x_(d)-chunklen/2 & x_<=x_(d)+chunklen/2);
            y_(d) = mean(y(I));
            if nargout>2
                switch data_type
                    case 'continuous'
                        se_(d) = std(y(I))/sqrt(sum(I));
                    case 'binary'
                        se_(d) = sqrt(y_(d)*(1-y_(d))/sum(I));
                end
            end
        end        
end

    

    
