# Construction of a genetic map for Streblospio benedicti
# Step 1: a map of markers showing intercross segregation patterns

# Use setwd("FileS3.MapConstruction") to set the working directory. Adjust the path to the directory as necessary.

# The product of Step 1 is the file Clean.ML.ordered.004.csv, which is provided in this directory. To skip step 1, use that csv file in step 2.

# rqtl is required
library(qtl)

# Three files are required. Load them from the working directory:
wormIDs <- read.csv(file = "ColWormIDsPedChecked.csv") 
depths <- read.table(file = "FilteredSNPs.read.depths.txt") 
genos <- read.table(file = "FilteredAsGenotypes.txt")

#Generate a data.frame that consolidates the information about each worm
wormIDs[9:384,] -> IDmat
IDmat[,12] <- apply(depths[,10:385], 2, mean, na.rm = T)
IDmat[,13] <- apply(genos[,10:385], 2, function(x){sum(!is.na(x))})
names(IDmat)[2] <- "Worm"
names(IDmat)[12] <- "MeanReadDepth"
names(IDmat)[13] <- "SNPsCalled"

#Make a filtered dataset that only includes good data

#Are some SNPs missing lots of data?
#hist(apply(genos[,10:385], 1, function(x){sum(is.na(x))}), br = 100, main = "Missing Data Per SNP", xlab = "missing, out of 376")
#No.

#Establish Strain Inclusion Criteria
min.num.called.SNPs <- 1000
min.mean.read.depth <- 15

#Identify strains with cleanish data
which(apply(genos[,10:385], 2, function(x){sum(!is.na(x))}) > min.num.called.SNPs & apply(depths[,10:385], 2, mean, na.rm = T) > min.mean.read.depth & IDmat$Generation > 0) + 9 -> GoodStrainColumns 
# The +9 is to account for the 9 columns of snp descriptions at the start of the objects.

#Now get rid of duplicates: remove worms #166, 99, 101.
GoodStrainColumns  <- GoodStrainColumns[-c(which(GoodStrainColumns %in% c(166, 99, 101)))] #291 #100

#############
#Now remove strains that after much additional processing have problems.
#These have crappy data based on diverse statistics.
GoodStrainColumns  <- GoodStrainColumns[-c(which(GoodStrainColumns %in% c(168, 215, 259, 268, 373)))] 

#Remove the worms with pedigree errors
GoodStrainColumns  <- GoodStrainColumns[-c(which(GoodStrainColumns %in% c(113,121,149,171,201,206,219,240,265,267,285,288,306,364,374,378)))] 

#############

## Here are the cleaned datasets
clean.SNPs <- genos[,1:9]
clean.genos <- genos[,GoodStrainColumns]
clean.depths <- depths[,GoodStrainColumns]
clean.IDs <- IDmat[GoodStrainColumns -9,]

# Count the genotypes for each sex and family
CountGenos <- function(x){
	AA <- sum(x == 0, na.rm = T)
	Aa <- sum(x == 1, na.rm = T)
	aa <- sum(x == 2, na.rm = T)
	return(c(AA, Aa, aa))
}

F1genos <- apply(clean.genos[, which(clean.IDs$Family == "F1")], 1, CountGenos)
F1malegenos <- apply(clean.genos[, which(clean.IDs$Family == "F1" & clean.IDs$Sex == "M")], 1, CountGenos)
F1femalegenos <- apply(clean.genos[, which(clean.IDs$Family == "F1" & clean.IDs$Sex == "F")], 1, CountGenos)
SixFgenos <- apply(clean.genos[, which(clean.IDs$Family == "F")], 1, CountGenos)
SixFmales <- apply(clean.genos[, which(clean.IDs$Family == "F" & clean.IDs$Sex == "M")], 1, CountGenos)
SixFfemales <- apply(clean.genos[, which(clean.IDs$Family == "F" & clean.IDs$Sex == "F")], 1, CountGenos)
OneAgenos <- apply(clean.genos[, which(clean.IDs$Family == "A")], 1, CountGenos)
OneAmales <- apply(clean.genos[, which(clean.IDs$Family == "A" & clean.IDs$Sex == "M")], 1, CountGenos)
OneAfemales <- apply(clean.genos[, which(clean.IDs$Family == "A" & clean.IDs$Sex == "F")], 1, CountGenos)
ThreeCgenos <- apply(clean.genos[, which(clean.IDs$Family == "C")], 1, CountGenos)
ThreeCmales <- apply(clean.genos[, which(clean.IDs$Family == "C" & clean.IDs$Sex == "M")], 1, CountGenos)
ThreeCfemales <- apply(clean.genos[, which(clean.IDs$Family == "C" & clean.IDs$Sex == "F")], 1, CountGenos)
EightHgenos <- apply(clean.genos[, which(clean.IDs$Family == "H" )], 1, CountGenos)
EightHmales <- apply(clean.genos[, which(clean.IDs$Family == "H" & clean.IDs$Sex == "M")], 1, CountGenos)
EightHfemales <- apply(clean.genos[, which(clean.IDs$Family == "H" & clean.IDs$Sex == "F")], 1, CountGenos)

#Calculate a fisher exact test for heterogeneity between sexes in each family
F1sexheterogeneity <- NULL;
for(i in 1: length(clean.genos[,1])){
F1sexheterogeneity[i] <- fisher.test(matrix(data = cbind(F1malegenos[,i], F1femalegenos[,i]), nrow = 3))$p.value
}
SixFsexhet <- NULL;
for(i in 1: length(clean.genos[,1])){
SixFsexhet[i] <- fisher.test(matrix(data = cbind(SixFmales[,i], SixFfemales[,i]), nrow = 3))$p.value
}
ThreeCsexhet <- NULL;
for(i in 1: length(clean.genos[,1])){
ThreeCsexhet[i] <- fisher.test(matrix(data = cbind(ThreeCmales[,i], ThreeCfemales[,i]), nrow = 3))$p.value
}
EightHsexhet <- NULL;
for(i in 1: length(clean.genos[,1])){
EightHsexhet[i] <- fisher.test(matrix(data = cbind(EightHmales[,i],EightHfemales[,i]), nrow = 3))$p.value
}
OneAsexhet <- NULL;
for(i in 1: length(clean.genos[,1])){
OneAsexhet[i] <- fisher.test(matrix(data = cbind(OneAmales[,i],OneAfemales[,i]), nrow = 3))$p.value
}

#Combine these all in a Fisher meta-analysis.
sex.linked.fisher.log10p <-  -log(apply(cbind(F1sexheterogeneity, SixFsexhet, ThreeCsexhet, EightHsexhet, OneAsexhet), 1, function(x){pchisq(2*sum(-log(x)),10, lower = F)}), 10)

plot(sort(sex.linked.fisher.log10p), ylab = "-log10(p)", xlab = "SNP")

data.frame(t(F1genos), t(OneAgenos), t(ThreeCgenos), t(SixFgenos), t(EightHgenos), t(F1malegenos), t(F1femalegenos), t(OneAmales), t(OneAfemales), t(ThreeCmales), t(ThreeCfemales), t(SixFmales), t(SixFfemales), t(EightHmales), t(EightHfemales)) -> GenotypeCounts

names(GenotypeCounts) <- c("AA.F1", "Aa.F1", "aa.F1", "AA.1A","Aa.1A","aa.1A","AA.3C","Aa.3C","aa.3C","AA.6F","Aa.6F","aa.6F","AA.8H","Aa.8H","aa.8H" ,
"mAA.F1", "mAa.F1", "maa.F1", "fAA.F1", "fAa.F1", "faa.F1", "mAA.1A","mAa.1A","maa.1A","fAA.1A","fAa.1A","faa.1A", "mAA.3C","mAa.3C","maa.3C","fAA.3C","fAa.3C","faa.3C","mAA.6F","mAa.6F","maa.6F","fAA.6F","fAa.6F","faa.6F","mAA.8H","mAa.8H","maa.8H","fAA.8H","fAa.8H","faa.8H" )

rm(list = ls()[which(ls() %in% c("F1genos", "OneAgenos", "ThreeCgenos", "SixFgenos", "EightHgenos", "F1malegenos", "F1femalegenos", "OneAmales", "OneAfemales", "ThreeCmales", "ThreeCfemales", "SixFmales", "SixFfemales", "EightHmales", "EightHfemales", "F1sexheterogeneity", "SixFsexhet", "ThreeCsexhet", "EightHsexhet", "OneAsexhet", "CountGenos", "min.mean.read.depth", "min.num.called.SNPs", "GoodStrainColumns", "depths"))])

SNPFile <- which(sex.linked.fisher.log10p > -1)

#####################################

recoded.genos <- clean.genos
target <- c(16:17)
fams <- c("A","C", "H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(18,19)
fams <- c("A","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(29:30)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C", "H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))

target <- c(32,33)
fams <- c("A","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(35:36)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C", "H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(37:38)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C", "H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(42:43)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(46:47)
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C", "H", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(51:52)
fams <- c("A","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(55:56)
#THIS one has apparent very strong segregation distortion. 
fams <- c("A","H", "C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(57:58)
fams <- c("A","F", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))


target <- c(59:61)
fams <- c("A", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN","MN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN","PN"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN","MN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN","PN"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN","MN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN","PN"))

target <- c(91:92)
fams <- c("A","H", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))

target <- c(93:94)
fams <- c("A","H", "C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))



target <- c(95:97)
fams <- c("A","H", "C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))


target <- c(105:106)
fams <- c("A","H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))



target <- c(109:110)
fams <- c("A","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))




target <- c(116:118)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("H", "C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))



target <- c(122:123)
fams <- c("A","C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))

target <- c(128:129)
fams <- c("A","H", "C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(132:133)
fams <- c("A","H", "C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(134:135)
fams <- c("A","H", "C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(136:138)
fams <- c("A", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN", "PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN", "MN"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(142:143)
fams <- c("H", "C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


#SNPs 152:154 have four distinct haplotypes
#Fam A & C: 2,2,0==PP, 1,2,0 & 1,1,0 == MP; 0,1,0==MM
#Fams F & H: 1,1,1==PP, 0,0,1 & 1,2,0 == MP; 0,1,0 == MM
target <- c(152:154)
fams <- c("H",  "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("A",  "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))


target <- c(160:164)
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP","MP", "MP"))
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1 0 1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP","MP", "MP"))

target <- c(180:181)
fams <- c("A","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))


target <- c(187:188)
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F", "H", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))


target <- c(192:193)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F", "H", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(207:209)
fams <- c("A", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(223:224)
fams <- c("A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))

target <- c(227:228)
fams <- c("A","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(234:235)
fams <- c("A","H", "C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

#SNPs 241-242
#Fams A&C: 1,0 ==PP, 1,1 & 2,1 == MP, 2,2 == MM
#Fams F & H: 1,0 = P + M or P; 1,1 == M + M or P
target <- c(241:242)
fams <- c("A","C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("H","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))


target <- c(243:244)
fams <- c("A","H", "C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(247:248)
fams <- c("A","H", "C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(251:253)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN", "PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN", "MN"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(257:258)
fams <- c("A","H", "C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))



target <- c(262:263)
fams <- c("A","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))


target <- c(264:266)
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN", "PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN", "MN"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))


target <- c(272:273)
fams <- c("A","H", "C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(275:276)
fams <- c("A","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(277:278)
fams <- c("H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))


target <- c(281:282)
fams <- c("A","C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(294:296)
fams <- c("F", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN", "PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN", "MN"))
fams <- c("A", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))


target <- c(299:300)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C", "F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(302:304)
fams <- c("F", "C", "A", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(306:308)
fams <- c("F", "C", "A", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(309:310)
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C", "F", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(318:319)
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("F", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))



target <- c(320:321)
fams <- c("C", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
fams <- c("H")
#Family H is a special case where the PP and MM genotypes are identical (AA/BB and AB/BA), so they're treated as missing here.
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))


target <- c(322:323)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
fams <- c("F", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(324:325)
fams <- c("A","H", "C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(326:327)
fams <- c("H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))


target <- c(344:345)
fams <- c("A","H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(347:349)
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN", "PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN", "MN"))
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

#SNPs 351:353
#SNP 352 isn't in the lepmap defined chr, but it's in the same read as the others. It looks like it genotyped badly in the F1s but otherwise seems okay. 
#Fams A & C: 2,0,0 ==PP; 1,0,0 & 2,1,0 == MP; 1,1,0 == MM
#Fams F & H: 1,0,0 == PP; 2,1,0 & 0,0,1 ==MP; 1,1,0 == MM
target <- c(351:353)
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(354:356)
fams <- c("F", "H", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN", "PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN", "MN"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))


#SNPs 357-358 
#Fams A and C, 0,0 = P + MorP; 0,1=M + MorP
#Fams F and H: 0,1 == MM; 0,0 or 1,2 == MP; 1,1 == PP
target <- c(357:358)
fams <- c("C", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))


target <- c(363:364)
fams <- c("F", "H", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))



###These have some segreagation distortion in some families or else high error rate. 
target <- c(365:366)
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C", "A", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))



target <- c(367:368)
fams <- c("F", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))


target <- c(373:374)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

#SNPs 378-379
#Fams A and C: 0,0==MM, 1,0==MP, 2,0 == PP
#Fams F and H: 0,0==MM, 1,0 & 0,1 == MP; 1,1==PP
target <- c(378:379)
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
fams <- c("H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(381:383)
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))




target <- c(384:391)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 1 0 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP", "PP", "PP", "PP", "PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2 0 2 0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM", "MM", "MM", "MM", "MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2 0 1 0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP", "MP", "MP", "MP", "MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 1 1 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP", "MP", "MP", "MP", "MP", "MP"))
fams <- c("H","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 1 0 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP", "PP", "PP", "PP", "PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1 0 1 0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM", "MM", "MM", "MM", "MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1 0 0 0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP", "MP", "MP", "MP", "MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 1 1 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP", "MP", "MP", "MP", "MP", "MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2 0 0 0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP", "PP", "PP", "PP", "PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2 0 2 0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM", "MM", "MM", "MM", "MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2 0 1 0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP", "MP", "MP", "MP", "MP", "MP"))

target <- c(392:393)
fams <- c("A","H", "C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

#SNPs 394-395
#Fams A and C: 0,1 == MM; 1,0 & 1,1 == MP; 2,0 == PP
#Fams F and H: 1,1 == P + M or P; 0,1== M + M or P.
target <- c(394:395)
fams <- c("H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(396:397)
fams <- c("A","C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F")
#recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
#this spits an error; there's only one match, so it ends up as a vector instead of a 2x1 matrix. So here's a kluge:
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- c("PP","PP")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(404:405)
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
fams <- c("A","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))


target <- c(412:413)
fams <- c("A", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(423:424)
fams <- c("A","H", "C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(425:426)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C", "F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))


target <- c(427:428)
fams <- c("A","H", "C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(438:439)
fams <- c("A","H", "C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

#SNPs 441-443 are all on one read but segregate in an impossible pattern. These should be thrown out. 

target <- c(445:446)
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(448:449)
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A","H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(463:464)
fams <- c("H", "F","C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(469:471)
fams <- c("F", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN", "PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN", "MN"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))


target <- c(473:474)
fams <- c("A","H", "C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(476:477)
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))


target <- c(479:481)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(483:484)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(485:486)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(488:489)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(491:492)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(502:503)
fams <- c("F", "H", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(505:506)
fams <- c("H", "F","A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(507:508)
fams <- c("H", "F","A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(511:512)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("F","H", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(517:518)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(525:528)
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN","PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN","MN","MN"))
fams <- c("A", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))

target <- c(551:552)
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(558:559)
fams <- c("A", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("F", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(566:568)
fams <- c("A","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(569:570)
fams <- c("H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(574:575)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(594:596)
fams <- c("F","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("C", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(599:600)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(613:615)
fams <- c("F","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(633:637)
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2 2 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP","MP", "MP"))
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2 2 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP","MP", "MP"))


target <- c(639:640)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(643:646)
fams <- c("H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))

target <- c(674:675)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("F","H", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(678:679)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F",  "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(681:682)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F",  "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(685:686)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(690:691)
fams <- c("F",  "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(693:694)
fams <- c("H","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))


target <- c(703:704)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(706:708)
fams <- c("A","C", "F","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(725:726)
fams <- c("F",  "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(732:735) #iffy!
fams <- c("A", "C","H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))


target <- c(736:737)
fams <- c("F",  "H", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(738:739)
fams <- c("C",  "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(744:746) 
fams <- c("F","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(748:749)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(758:759)
fams <- c("F",  "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(761:763) 
fams <- c("F","H", "A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(766:767)
fams <- c("F",  "H", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(772:773)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(800:802) 
fams <- c("F","A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(803:805) 
fams <- c("F","C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(808:809)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

#Recoding 810-811
#The family C data includes a disproportionate number of anomalous/erroneous calls: 9/96. The others are quite clean.
#Fams A and C: 0,0==MM, 1,0 == MP, 2,0==PP;
#Fams F and H: 0,0==MM, 1,0 and 0,1 == MP, 1,1 == PP.
target <- c(810:811)
fams <- c("F",  "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(814:815)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(830:831)
fams <- c("F",  "H", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c( "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(834:835)
fams <- c("F",  "H", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c( "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(836:838) 
fams <- c("F","C", "A", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(839:840)
fams <- c("H","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))


target <- c(843:844)
fams <- c("F",  "H", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c( "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(845:846)
fams <- c("H",  "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F","C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(853:854)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(860:862) 
fams <- c("F","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("C", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(863:864)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(872:873)
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("A", "C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(888:889)
fams <- c("H",  "A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F")
#recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
#this spits an error; there's only one match, so it ends up as a vector instead of a 2x1 matrix. So here's a kluge:
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- c("PP","PP")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(904:906)
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN","MN"))
fams <- c("A", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))

target <- c(930:931)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(934:935)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(942:943) #skeptical
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(966:967)
fams <- c("H",  "F", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(968:969)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(978:980)
fams <- c("A", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
fams <- c("C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))

target <- c(981:982) 
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("A", "F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(986:987)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(989:990) 
fams <- c("A", "F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))


target <- c(993:995)
fams <- c("A", "H","C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))


target <- c(1003:1004)
fams <- c("H",  "F", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(1005,1008) #1006 and 1007 don't make any sense.
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
fams <- c("A","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(1019:1021)
fams <- c("A", "H","C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))

target <- c(1023:1024)
fams <- c("A",  "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("H", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1030:1031)
fams <- c("H",  "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1041:1042)
fams <- c("H",  "A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(1051:1052)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(1055:1056)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1063:1064)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(1065:1067)
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
fams <- c("F", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))

target <- c(1076:1078)
fams <- c("H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))

target <- c(1104:1105)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F", "H","C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1107:1109)
fams <- c("H", "F", "C", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))

target <- c(1111:1112)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F", "H","C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1130:1131)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1139:1140)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1142:1143)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1153:1154) #skeptical
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("F",  "H", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1158:1159) 
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("F",  "A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1181:1182)
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1186:1188)
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
fams <- c("H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))

target <- c(1191:1192)
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1204:1206)
fams <- c("H","A", "C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))

target <- c(1207:1209)
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
#recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
#this spits an error; there's only one match, so it ends up as a vector instead of a 2x1 matrix. So here's a kluge:
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 2" & clean.IDs$Fam %in% fams)] <- c("MM","MM","MM")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
fams <- c("H","A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))

target <- c(1210:1211) 
fams <- c("F",  "H", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1223:1224)
fams <- c("F", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1225:1228) 
fams <- c("A",  "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 2 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 2 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))


target <- c(1230:1231) 
fams <- c("F", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1232:1233)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1241:1242) #Family F is missing a genotype class
fams <- c("H", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1251:1252)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1253:1254)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(1265:1266) 
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("H", "C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1269:1271)
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN","MN"))
fams <- c("A", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))

target <- c(1277:1278)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(1308:1309) 
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1312:1313) 
fams <- c("H", "F","C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1316:1317) 
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A", "H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1319:1320) 
fams <- c("C", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1323:1325)
fams <- c("A", "C","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN","MN"))
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))


target <- c(1326:1327) 
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("H", "F", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1329:1330) 
fams <- c("H", "F", "C", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1331:1333)
fams <- c("F", "H", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))

target <- c(1350:1351) #iffy! 
fams <- c("C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("H", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1354:1357)
fams <- c("A","C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN","PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN","MN","MN"))
fams <- c("H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))

target <- c(1375:1377)
fams <- c("F", "H", "C", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))



################################

#A Function to Calculate Segregation Pattern Likelihoods and Error Probabilities
#Returns either a vector of log likelihoods for each of the six segregation classes ("logliks"), 
#or a the single highest likelihood segregation class ("best")

SegClassLikelihood <- function(x, output = c("logliks", "best")){
	
	AAxBB <- function(err.ab, x){
	pr.aa <- 0
	pr.ab <- 1
	pr.bb <- 0
	dmultinom(x, prob=c(pr.aa*(1-2*err.ab - err.ab^2) + pr.ab * err.ab + pr.bb*err.ab^2, pr.aa*2*err.ab + pr.ab* (1- err.ab - err.ab) + pr.bb*2*err.ab, pr.aa*err.ab^2 + pr.ab*err.ab + pr.bb*(1-2*err.ab - err.ab^2)))
	}
	
	f <- AAxBB
	AAxBBLikes <- log(apply(x, 1, function(x){optimize(f, x, interval = c(0,.1), maximum = T)$objective }), 10)
	
			
	AAxAB <- function(err.ab, x){	
	pr.aa <- 0.5
	pr.ab <- 0.5
	pr.bb <- 0	
	dmultinom(x, prob=c(pr.aa*(1-2*err.ab - err.ab^2) + pr.ab * err.ab + pr.bb*err.ab^2, pr.aa*2*err.ab + pr.ab* (1- err.ab - err.ab) + pr.bb*2*err.ab, pr.aa*err.ab^2 + pr.ab*err.ab + pr.bb*(1-2*err.ab - err.ab^2)))
	}
	
	f <- AAxAB
	AAxABLikes <- log(apply(x, 1, function(x){optimize(f, x, interval = c(0,.1), maximum = T)$objective }),10)
###	
	ABxBB <- function(err.ab, x){	
	pr.aa <- 0
	pr.ab <- 0.5
	pr.bb <- 0.5	
	dmultinom(x, prob=c(pr.aa*(1-2*err.ab - err.ab^2) + pr.ab * err.ab + pr.bb*err.ab^2, pr.aa*2*err.ab + pr.ab* (1- err.ab - err.ab) + pr.bb*2*err.ab, pr.aa*err.ab^2 + pr.ab*err.ab + pr.bb*(1-2*err.ab - err.ab^2)))
	}

	f <- ABxBB
	ABxBBLikes <- log(apply(x, 1, function(x){optimize(f, x, interval = c(0,.1), maximum = T)$objective }),10)

###
	ABxAB <- function(err.ab, x){	
	pr.aa <- 0.25
	pr.ab <- 0.5
	pr.bb <- 0.25
	dmultinom(x, prob=c(pr.aa*(1-2*err.ab - err.ab^2) + pr.ab * err.ab + pr.bb*err.ab^2, pr.aa*2*err.ab + pr.ab* (1- err.ab - err.ab) + pr.bb*2*err.ab, pr.aa*err.ab^2 + pr.ab*err.ab + pr.bb*(1-2*err.ab - err.ab^2)))
	}

	f <- ABxAB
	ABxABLikes <- log(apply(x, 1, function(x){optimize(f, x, interval = c(0,.1), maximum = T)$objective }),10)

	AAxAA <- function(err.ab, x){	
	pr.aa <- 1
	pr.ab <- 0
	pr.bb <- 0
	dmultinom(x, prob=c(pr.aa*(1-2*err.ab - err.ab^2) + pr.ab * err.ab + pr.bb*err.ab^2, pr.aa*2*err.ab + pr.ab* (1- err.ab - err.ab) + pr.bb*2*err.ab, pr.aa*err.ab^2 + pr.ab*err.ab + pr.bb*(1-2*err.ab - err.ab^2)))
	}

	f <- AAxAA
	AAxAALikes <- log(apply(x, 1, function(x){optimize(f, x, interval = c(0,.1), maximum = T)$objective }),10)

	BBxBB <- function(err.ab, x){	
	pr.aa <- 0
	pr.ab <- 0
	pr.bb <- 1
	dmultinom(x, prob=c(pr.aa*(1-2*err.ab - err.ab^2) + pr.ab * err.ab + pr.bb*err.ab^2, pr.aa*2*err.ab + pr.ab* (1- err.ab - err.ab) + pr.bb*2*err.ab, pr.aa*err.ab^2 + pr.ab*err.ab + pr.bb*(1-2*err.ab - err.ab^2)))
	}	
	
	f <- BBxBB
	BBxBBLikes <- log(apply(x, 1, function(x){optimize(f, x, interval = c(0,.1), maximum = T)$objective }),10)

	LikelihoodSequence <- c(AAxBBLikes, AAxABLikes, ABxBBLikes, ABxABLikes, AAxAALikes, BBxBBLikes)
	names(LikelihoodSequence) <- c("AAxBB", "AAxAB", "ABxBB", "ABxAB", "AAxAA", "BBxBB")

if(output == "logliks"){
	return(LikelihoodSequence)
	}
	else if (output == "best"){
	return(names(LikelihoodSequence) [which(LikelihoodSequence == max(LikelihoodSequence))])
	}
	else{stop("What is the desired output?")}
}
#######################################################

#Calculate the likelihood for each snp for each family for each segregation pattern


GenotypeFile <- GenotypeCounts[,1:15]	#OR autosomalGenotypeCounts

FamilySegLikelihoods <- matrix(nrow = dim(GenotypeFile)[1], ncol = 30);
for(j in 1:dim(GenotypeFile)[1]){
	
	for(i in 1:5){
		FamilySegLikelihoods[j,(i+5*i-5):(i+5*i)] <- SegClassLikelihood(GenotypeFile[j,(i+2*i-2):(i+2*i)], out = "logliks")
	
	}
}
likeseq <- c("AAxBB", "AAxAB", "ABxBB", "ABxAB", "AAxAA", "BBxBB")
names(FamilySegLikelihoods) <- c(paste("F1",likeseq),paste("1A",likeseq),paste("3C",likeseq),paste("6F",likeseq),paste("8H",likeseq)) 



#######################################################
#Calculate the likelihood for each snp for the whole pedigree, for every possible segregation pattern
n.f1families <- 4; 
n.patterns <- (1 + 3^n.f1families + 3^n.f1families + 6^n.f1families + 1 +1)

everysegpattern <- matrix(nrow = dim(GenotypeFile)[1], ncol = n.patterns)
MLgenotypes <- matrix(nrow = 1461, ncol = 5)
colnames(MLgenotypes) <-  c("P0","A1","C3","F6","H8")


#P0 AAxBB, F1 crosses must all be ABxAB
everysegpattern[,1] <- apply(FamilySegLikelihoods[,c(1,10,16,22,28)], 1, sum)
MLgenotypes[1,] <- likeseq[c(1,4,4,4,4)]

#P0 AAxAB, F1 crosses can be AAxAB, ABxAB, or AAxAA
x <- c(2,4,5)  #The seg classes of the F2 families
y <- 2 #The seg class of F1s
c<- 0;
for(i in 1:3){	#1A
	for(j in 1:3){	#3C
		for(k in 1:3){	#6F
			for(l in 1:3){	#8H
				c = c+1
				#The extra log(0.5,10) etc added to the likelihoods below are to account for the probability that the F1s that cross are of specific cross types, given the P0 genotypes. E.g., if P0s are AA x AB, the probability that a specific F1 cross is between AA and AA is .25.
				everysegpattern[,1+c] <- sum(c(i,j,k,l) == 1)*log(.5,10) + sum(c(i,j,k,l) == 2)*log(.25,10) + sum(c(i,j,k,l) == 3)*log(0.25,10) + apply(FamilySegLikelihoods[,c(y,6+x[i], 12+x[j], 18+x[k], 24+x[l])], 1,sum)
				MLgenotypes[1+c,] <- likeseq[c(y,x[i],x[j],x[k],x[l])]	
			}
		}
	}
}

#P0 ABxBB, F1 crosses can be ABxBB, ABxAB, or BBxBB
x <- c(3,4,6) #he seg classes fo the F2 families
y <- 3 #The seg class of F1s
c<- 0;
for(i in 1:3){	#1A
	for(j in 1:3){	#3C
		for(k in 1:3){	#6F
			for(l in 1:3){	#8H
				c = c+1
				everysegpattern[,82+c] <- sum(c(i,j,k,l) == 1)*log(.5,10) + sum(c(i,j,k,l) == 2)*log(.25,10) + sum(c(i,j,k,l) == 3)*log(0.25,10) + apply(FamilySegLikelihoods[,c(y,6+x[i], 12+x[j], 18+x[k], 24+x[l])], 1,sum)
				MLgenotypes[82+c,] <- likeseq[c(y,x[i],x[j],x[k],x[l])]					
			}
		}
	}
}

#P0 ABxAB, F1 crosses can be any of the six classes!
x <- c(1:6) #he seg classes fo the F2 families
y <- 4 #The seg class of F1s
c<- 0;
for(i in 1:6){	#1A
	for(j in 1:6){	#3C
		for(k in 1:6){	#6F
			for(l in 1:6){	#8H
				c = c+1
				everysegpattern[,82+81+c] <- sum(c(i,j,k,l) == 1)*log(2/16,10) + sum(c(i,j,k,l) == 2)*log(4/16,10) + sum(c(i,j,k,l) == 3)*log(4/16,10) + sum(c(i,j,k,l) == 4)*log(4/16,10) + sum(c(i,j,k,l) == 5)*log(1/16,10) + sum(c(i,j,k,l) == 6)*log(1/16,10) + apply(FamilySegLikelihoods[,c(y,6+x[i], 12+x[j], 18+x[k], 24+x[l])], 1,sum)
				MLgenotypes[82+81+c,] <- likeseq[c(y,x[i],x[j],x[k],x[l])]					
			}
		}
	}
}

#P0 AAxAA, F1 crosses must all be AAxAA
everysegpattern[,1460] <- apply(FamilySegLikelihoods[,c(5,11,17,23,29)], 1, sum)
MLgenotypes[1460,] <- likeseq[c(5,5,5,5,5)]

#P0 BBxBB, F1 crosses must all be BBxBB
everysegpattern[,1461] <- apply(FamilySegLikelihoods[,c(6,12,18,24,30)], 1, sum)
MLgenotypes[1461,] <- likeseq[c(6,6,6,6,6)]

#Many of the seg patterns above are not actually possible because male Z is in every cross. So here we'll remove the impossible patterns. 
impossible <- NULL;
for(i in 1:1461){
	p0 <- MLgenotypes[i,1];
	if(p0 == "AAxAB"){
		howmanyAAxAA <- sum(MLgenotypes[i,2:5] == "AAxAA")
		howmanyABxAB <- sum(MLgenotypes[i,2:5] == "ABxAB")
		if(howmanyAAxAA >0 & howmanyABxAB >0){
			impossible <- c(impossible, i)
		}
	}
	else if(p0 == "ABxBB"){
		howmanyBBxBB <- sum(MLgenotypes[i,2:5] == "BBxBB")
		howmanyABxAB <- sum(MLgenotypes[i,2:5] == "ABxAB")
		if(howmanyBBxBB >0 & howmanyABxAB >0){
			impossible <- c(impossible, i)
		}
	}
	else if(p0 == "ABxAB"){
		howmanyBBxBB <- sum(MLgenotypes[i,2:5] == "BBxBB")
		howmanyAAxAA <- sum(MLgenotypes[i,2:5] == "AAxAA")
		howmanyABxAB <- sum(MLgenotypes[i,2:5] == "ABxAB")
		howmanyAAxBB <- sum(MLgenotypes[i,2:5] == "AAxBB")
		howmanyAA <- sum(MLgenotypes[i,2:5] %in% c("AAxAA", "AAxAB", "AAxBB"))
		howmanyAB <- sum(MLgenotypes[i,2:5] %in% c("AAxAB", "ABxBB", "ABxAB"))
		howmanyBB <- sum(MLgenotypes[i,2:5] %in% c("AAxBB", "ABxBB", "BBxBB"))
		if(howmanyBBxBB >0 & howmanyAAxAA >0){
			impossible <- c(impossible, i)
		}
		else if(howmanyABxAB >0 & howmanyAAxAA >0){
			impossible <- c(impossible, i)
		}
		else if(howmanyABxAB >0 & howmanyBBxBB >0){
			impossible <- c(impossible, i)
		}	
		else if(howmanyABxAB >0 & howmanyAAxBB >0){
			impossible <- c(impossible, i)
		}	
		else if(howmanyAA < 4 & howmanyAB < 4 & howmanyBB <4 ){
			impossible <- c(impossible, i)
		}
	}
}

everysegpattern <- everysegpattern[,-impossible]
MLgenotypes <- MLgenotypes[-impossible,]

bestpattern <- MLgenotypes[apply(everysegpattern, 1, function(x){which(x == max(x))}),]
highestML <- apply(everysegpattern, 1, function(x){x[which(x == sort(x)[length(x)])] }) 
Firstvssecond <- apply(everysegpattern, 1, function(x){diff(sort(x))[length(x)-1]} )

rm(list = ls()[which(ls() %in% c("howmanyBBxBB" , "howmanyAAxAA", "howmanyABxAB", "howmanyAAxBB", "howmanyAA", "howmanyAB", "howmanyBB" , "i" ,"j", "k", "l", "impossible", "n.f1families","n.patterns"))])

########################
#Now combine recoded multi-snp markers with the rest of the dataset
contignames <- levels(clean.SNPs[,1])
snpspercontig <- NULL; for(i in 1:(length(contignames))){snpspercontig[i] <- sum(clean.SNPs[,1] == contignames[i])}
data.frame(contignames, snpspercontig) -> contigs
table(snpspercontig)

clean.SNPs[,7] <- sex.linked.fisher.log10p
clean.SNPs[,8] <- NA
for(i in 1:1389){clean.SNPs[i,8] <- contigs[which(contigs[,1] == clean.SNPs[i,1]),2]}
clean.SNPs[,9:13] <- NA
clean.SNPs[,9:13] <- bestpattern
clean.SNPs[,14] <- NA
clean.SNPs[,14] <- highestML
clean.SNPs[,15] <- NA
clean.SNPs[,15] <- Firstvssecond
clean.SNPs[,16] <- NA
clean.SNPs[,16] <- row.names(clean.SNPs)
names(clean.SNPs) <- c("contig", "pos", "dot", "ref","alt","qual","sexP","SNPsInContig", "F1seg", "Aseg","Cseg","Fseg", "Hseg", "ML","firstvssecond", "SNP.number")


###*RECODING THE MULTISNP CONTIGS*###*****************************
reco <- NULL
for(i in 1:1389){reco[i] <- "MP" %in% levels(as.factor(as.character(recoded.genos[i,])))}
sum(reco)  #445 recoded SNPs from multi-snp contigs

recoded.genos[reco == T & recoded.genos == 0] <- NA
recoded.genos[reco == T & recoded.genos == 1] <- NA
recoded.genos[reco == T & recoded.genos == 2] <- NA
recoded.genos[reco == T, clean.IDs$Gen == 1] <- "MP"

#Now, overwriting the "bestpattern" to convert the multi-snp contig snps to PTC
icpattern <- c("AAxBB" ,"ABxAB", "ABxAB", "ABxAB", "ABxAB")
for(i in 1:(sum(reco))){bestpattern[reco,][i,] <- icpattern}
###*****************************###*****************************

#Remove redundant SNPs

SNPtodelete <- duplicated(recoded.genos)
ContigProblem <- c(465:466, 607:608, 641:642, 1381:1382) #These are sites that don't segregate together with their contig-mates
Xlinked <- which(sex.linked.fisher.log10p > -log(0.05/1389, 10))
notIC <- which(bestpattern[,1] != "AAxBB")
SNPtodelete[notIC] <- TRUE
SNPtodelete[Xlinked] <- TRUE
SNPtodelete[ContigProblem] <- TRUE


integer.recoded.genos <- clean.genos

integer.recode <- function(x){
x[x == "MM"] <- 0
x[x == "MP"] <- 1
x[x == "PP"] <- 2
x[is.na(x)] <- 3
x[x == "MN"] <- 4   ##Apparently lepmap can't deal with these genotypes
x[x == "PN"] <- 5	##Apparently lepmap can't deal with these genotypes
x[x == "0"] <- 0
x[x == "1"] <- 1
x[x == "2"] <- 2
as.integer(x)	
}

for(i in 1: dim(recoded.genos)[2]){
integer.recoded.genos[,i] <- integer.recode(recoded.genos[,i])
}

snpstoinclude <- which(SNPtodelete ==F)
clean.snpstoinclude.SNPs <- clean.SNPs[snpstoinclude,]
genofile <- integer.recoded.genos[snpstoinclude, which(clean.IDs$Gen ==2)]
IDfile <- clean.IDs[which(clean.IDs$Gen ==2),]

#Make an rqtl file
rqtlGenos <- t(data.frame(paste0("SNP", row.names(genofile)), "1", genofile))
data.frame(c("worm", "", IDfile[, 1]),c("Sex", "", as.character(IDfile[, 3])), c("Family", "", as.character(IDfile[, 5])), c("Ind", "", as.character(IDfile[, 6])), rqtlGenos) -> frame.rqtl
row.names(frame.rqtl) <- NULL
colnames(frame.rqtl) <- NULL
write.csv(frame.rqtl, file = "IC.frame.qtl.csv", quote = F, row.names = F)
library(qtl)
read.cross(file = "IC.frame.qtl.csv", format = "csv", geno = c("0","1","2","4","5"), na.strings = c("3","NA","-")) -> IC.rqtl

#Summaries
gt <- geno.table(IC.rqtl)

# geno.table doesn't account for the dominant markers correctly in this setting, so we recalculate their p-values here
exp.geno <- c(0.25, 0.5, 0.25, 0.5, 0.5)
for(i in 1: dim(gt)[1]){
	if(gt$not.BB[i] > 0){
		gt$P.value[i] <- pchisq( 2*(-log(chisq.test(gt[i, 6:7], p = exp.geno[4:5])$p.value) + -log(chisq.test(gt[i, 3:5], p= exp.geno[1:3])$p.value)), 4, lower = F)	
	}	
}
exclude.segdist <- rownames(gt[gt$P.value < 1e-10,]) # remove markers with strong segregation distortion
exclude.missing <- rownames(gt[gt$missing > (nind(IC.rqtl)*0.1),]) # remove markers missing > 10%
IC.rqtl <- drop.markers(IC.rqtl, exclude.segdist)
IC.rqtl <- drop.markers(IC.rqtl, exclude.missing)
summary(ntyped(IC.rqtl))
summary(ntyped(IC.rqtl, "mar"))


IC.rqtl <- est.rf(IC.rqtl)
IC.rqtl <- formLinkageGroups(IC.rqtl, max.rf = 0.2, min.lod = 10, reorgMarkers= T)
flipthese <- markernames(IC.rqtl, chr = c(6,8, 10, 13,15,16,17,18,19,20))
IC.rqtl <- switchAlleles(IC.rqtl, flipthese)
IC.rqtl <- formLinkageGroups(IC.rqtl, max.rf = 0.1, min.lod = 6, reorg = T)



#Individual SNPs don't fall into the map at that threshold
#These are manually assigned to chromosomes by inspecting plots like these:
par(mfrow = c(2,1))
plot(pull.rf(IC.rqtl), "SNP462", ylim = c(0,1)); abline(h=0.5);
plot(pull.rf(IC.rqtl, "lod"), "SNP462")
movemarker(IC.rqtl, "SNP462", 1) -> IC.rqtl
#Linked to LG1, lod 30, rf ~ 0.15

plot(pull.rf(IC.rqtl), "SNP998", ylim = c(0,1)); abline(h=0.5);
plot(pull.rf(IC.rqtl, "lod"), "SNP998")
movemarker(IC.rqtl, "SNP998", 9) -> IC.rqtl
#Linked to LG9, lod 10, rf ~ 0.25

plot(pull.rf(IC.rqtl), "SNP309", ylim = c(0,1)); abline(h=0.5);
plot(pull.rf(IC.rqtl, "lod"), "SNP309")
movemarker(IC.rqtl, "SNP309", 5) -> IC.rqtl
#Linked to LG5, lod 8, rf ~ 0.3

plot(pull.rf(IC.rqtl), "SNP365", ylim = c(0,1)); abline(h=0.5);
plot(pull.rf(IC.rqtl, "lod"), "SNP365")
IC.rqtl <- switchAlleles(IC.rqtl, "SNP365")
movemarker(IC.rqtl, "SNP365", 1) -> IC.rqtl
#Linked to LG1, lod 8, rf ~ 0.35

plot(pull.rf(IC.rqtl), "SNP942", ylim = c(0,1)); abline(h=0.5);
plot(pull.rf(IC.rqtl, "lod"), "SNP942")
movemarker(IC.rqtl, "SNP942", 4) -> IC.rqtl
#Linked to LG4, lod 6, rf ~ 0.3

#Three markers are dropped: these are markers from recoded multi-SNP contigs, and they may represent erroneous assignments to single contigs. 
IC.rqtl <- drop.markers(IC.rqtl, c("SNP294","SNP1023", "SNP1153"))
IC.rqtl <- est.rf(IC.rqtl)

Ordered.IC <- IC.rqtl

for(i in 1:10){
Ordered.IC <- orderMarkers(Ordered.IC, chr = i, error = 0.015)
}

#Twenty reps of ordering the markers along each LG:
n.order.reps <- 20
maplikes <- matrix(nrow = n.order.reps, ncol = 10)
for(j in 1:n.order.reps){
tempOIC <- Ordered.IC
	for(i in 1:10){
	tempOIC <- orderMarkers(tempOIC, chr = i, error = 0.015)
 	}
assign(paste0("tempOIC.rep", j), tempOIC)
maplikes[j,] <- sapply(pull.map(tempOIC), attr, "loglik")
print(paste("Rep", j , "Loglikelihood =", sum(sapply(pull.map(tempOIC), attr, "loglik")), date()))
 }
 
#Combine the ML orders into one map
ML.ordered.IC <- Ordered.IC
for(q in 1:10){
tempML <- get(paste0("tempOIC.rep", which(maplikes[,q] == max(maplikes[,q]))))	
ML.ordered.IC$geno[[q]] <- tempML$geno[[q]]	
} 
 
#Now look for individuals with too many crossovers, suggesting bad data, and remove them
summary(countXO(ML.ordered.IC))
plot(countXO(ML.ordered.IC))
#There are outliers with a large excess of crossovers
ML.ordered.IC $pheno[which(countXO(ML.ordered.IC) > 35),] #These are problem individuals
ML.ordered.IC <- subset(ML.ordered.IC, ind = (countXO(ML.ordered.IC) < 35))


#Estimate genotyping error in the reduced dataset
loglik <- err <- c(.01,.011,.012,.013,.014,.015,.016,.017,.018,.019, .02)
for(i in seq(along=err)){
	cat(i, "of",length(err), "\n")
	tempmap <- est.map(ML.ordered.IC, error.prob = err[i])
	loglik[i] <- sum(sapply(tempmap, attr, "loglik"))
	}

#Another 20 reps with the newly reduced dataset and new ML error rate
n.order.reps <- 20
maplikes2 <- matrix(nrow = n.order.reps, ncol = 10)
for(j in 1:n.order.reps){
tempOIC <- ML.ordered.IC
	for(i in 1:10){
	tempOIC <- orderMarkers(tempOIC, chr = i, error = 0.013)
 	}
assign(paste0("tempOIC.rep", j), tempOIC)
maplikes2[j,] <- sapply(pull.map(tempOIC), attr, "loglik")
print(paste("Rep", j , "Loglikelihood =", sum(sapply(pull.map(tempOIC), attr, "loglik")), date()))
 }

#Combine the ML orders into one map
ML.ordered.IC.013 <- ML.ordered.IC
for(q in 1:10){
tempML <- get(paste0("tempOIC.rep", which(maplikes2[,q] == max(maplikes2[,q]))))	
ML.ordered.IC.013$geno[[q]] <- tempML$geno[[q]]	
} 

#Save the cross object
write.cross(ML.ordered.IC.013, format = "csv", filestem="ML.ordered.IC.013")

#How bad are individuals' genotypes?
ML.ordered.IC.013 <- calc.errorlod(ML.ordered.IC.013, 0.013)
inderrorsums <- apply(ML.ordered.IC.013$geno[[1]]$errorlod, 1, sum)
for(i in 2:10){inderrorsums <- inderrorsums + apply(ML.ordered.IC.013$geno[[i]]$errorlod, 1, sum)}
hist(inderrorsums, br = 100)
ML.ordered.IC.013$pheno[which(inderrorsums < -6000),]
#Five individuals have pretty bad error lods

snperrorsums <- apply(ML.ordered.IC.013$geno[[1]]$errorlod, 2, sum)
for(i in 2:10){snperrorsums <- c(snperrorsums, apply(ML.ordered.IC.013$geno[[i]]$errorlod, 2, sum))}
#SNPs all look okay

#Find and remove erroneous genotypes (mostly of the form e.g. 00000200000)
toperr <- top.errorlod(ML.ordered.IC.013, cutoff= 6)
ML.ordered.IC.013$pheno[,5] <- seq(1:nind(ML.ordered.IC.013))
names(ML.ordered.IC.013$pheno)[5] <- "id"
Clean.ML.ordered <- ML.ordered.IC.013
for(i in 1:nrow(toperr)){
	chr <- toperr$chr[i]
	id <- toperr$id[i]
	mar <- toperr$marker[i]
	Clean.ML.ordered$geno[[chr]]$data[Clean.ML.ordered$pheno$id == id, mar] <- NA
}

#Estimate genotyping error in the reduced dataset
loglik <- err <- c(.003, .004, .005,.006,.007,.008,.009,.01,.011,.012,.013,.014,.015)
for(i in seq(along=err)){
	cat(i, "of",length(err), "\n")
	tempmap <- est.map(Clean.ML.ordered, error.prob = err[i])
	loglik[i] <- sum(sapply(tempmap, attr, "loglik"))
	}

#Another 50 reps with the newly reduced dataset and new ML error rate
n.order.reps <- 50
maplikes3 <- matrix(nrow = n.order.reps, ncol = 10)
for(j in 1:n.order.reps){
tempOIC <- Clean.ML.ordered
	for(i in 1:10){
	tempOIC <- orderMarkers(tempOIC, chr = i, error = 0.004)
 	}
assign(paste0("tempOIC.rep", j), tempOIC)
maplikes3[j,] <- sapply(pull.map(tempOIC), attr, "loglik")
print(paste("Rep", j , "Loglikelihood =", sum(sapply(pull.map(tempOIC), attr, "loglik")), date()))
 }

#Combine the ML orders into one map
#This is hacky because some of the chromosomes had better likelihoods with tempmap above
Clean.ML.ordered.004 <- Clean.ML.ordered
for(q in c(1,2,6,8)){
tempML <- get(paste0("tempOIC.rep", which(maplikes3[,q] == max(maplikes3[,q]))))	
Clean.ML.ordered.004 $geno[[q]] <- tempML$geno[[q]]	
} 
newmap <- est.map(Clean.ML.ordered.004, error = 0.004)
replace.map(Clean.ML.ordered.004, newmap) -> Clean.ML.ordered.004

#Here's the final cross object
write.cross(Clean.ML.ordered.004, format = "csv", filestem="Clean.ML.ordered.004")
