# Construction of a genetic map for Streblospio benedicti

# Step 2: Imputation of parental genotypes, substitution of refined intercross markers, assignment of markers to linkage groups by LepMap, marker ordering, and phase inference for autosomal linkage groups

# The first part of the workflow is the same as Step 1, except that several worms that step 1 identified as having high error rates are removed; consequently the workflow should be run from this file despite the apparent duplication of step 1 workflow. 

# Later parts of step 2 require that lepmap2 and lepmap3 be installed in the Applications directory.

# The lepmap steps can be bypassed by 


# rqtl is required
library(qtl)

# Several files are required. Load them from the working directory:
wormIDs <- read.csv(file = "ColWormIDsPedChecked.csv") 
depths <- read.table(file = "FilteredSNPs.read.depths.txt") 
genos <- read.table(file = "FilteredAsGenotypes.txt")
# Clean.ML.ordered.004.csv is also required: it is the product of Step 1 of map construction. 
# lepmap2 and lepmap3 are required. These should be directories within /Applications. 
# lepmap requires java.
# perl is required and the perl script "ConvertLepmapToRqtl.pl"

#Generate a data.frame that consolidates the information about each worm
wormIDs[9:384,] -> IDmat
IDmat[,12] <- apply(depths[,10:385], 2, mean, na.rm = T)
IDmat[,13] <- apply(genos[,10:385], 2, function(x){sum(!is.na(x))})
names(IDmat)[2] <- "Worm"
names(IDmat)[12] <- "MeanReadDepth"
names(IDmat)[13] <- "SNPsCalled"

#Make a filtered dataset that only includes good data

#Are some SNPs missing lots of data?
#hist(apply(genos[,10:385], 1, function(x){sum(is.na(x))}), br = 100, main = "Missing Data Per SNP", xlab = "missing, out of 376")
#No.

#Establish Strain Inclusion Criteria
min.num.called.SNPs <- 1000
min.mean.read.depth <- 15

#Identify strains with cleanish data
which(apply(genos[,10:385], 2, function(x){sum(!is.na(x))}) > min.num.called.SNPs & apply(depths[,10:385], 2, mean, na.rm = T) > min.mean.read.depth & IDmat$Generation > 0) + 9 -> GoodStrainColumns 
# The +9 is to account for the 9 columns of snp descriptions at the start of the objects.

#Now get rid of duplicates: should remove worms #166, 99, 101.
GoodStrainColumns  <- GoodStrainColumns[-c(which(GoodStrainColumns %in% c(166, 99, 101)))] #291 #100

#############
#Now remove strains that after much additional processing have problems.
#These have crappy data based on diverse statistics.
GoodStrainColumns  <- GoodStrainColumns[-c(which(GoodStrainColumns %in% c(168, 215, 259, 268, 373)))] 

#Remove the worms with pedigree errors
GoodStrainColumns  <- GoodStrainColumns[-c(which(GoodStrainColumns %in% c(113,121,149,171,201,206,219,240,265,267,285,288,306,364,374,378)))] 

#Remove the worms with high genotyping errors based on Rqtl analysis (Step 1)
GoodStrainColumns  <- GoodStrainColumns[-c(which(GoodStrainColumns %in% c(139,191,203,233)))] 

#############

## Here are the cleaned datasets
clean.SNPs <- genos[,1:9]
clean.genos <- genos[,GoodStrainColumns]
clean.depths <- depths[,GoodStrainColumns]
clean.IDs <- IDmat[GoodStrainColumns -9,]

CountGenos <- function(x){
	AA <- sum(x == 0, na.rm = T)
	Aa <- sum(x == 1, na.rm = T)
	aa <- sum(x == 2, na.rm = T)
	return(c(AA, Aa, aa))
}

F1genos <- apply(clean.genos[, which(clean.IDs$Family == "F1")], 1, CountGenos)
F1malegenos <- apply(clean.genos[, which(clean.IDs$Family == "F1" & clean.IDs$Sex == "M")], 1, CountGenos)
F1femalegenos <- apply(clean.genos[, which(clean.IDs$Family == "F1" & clean.IDs$Sex == "F")], 1, CountGenos)
SixFgenos <- apply(clean.genos[, which(clean.IDs$Family == "F")], 1, CountGenos)
SixFmales <- apply(clean.genos[, which(clean.IDs$Family == "F" & clean.IDs$Sex == "M")], 1, CountGenos)
SixFfemales <- apply(clean.genos[, which(clean.IDs$Family == "F" & clean.IDs$Sex == "F")], 1, CountGenos)
OneAgenos <- apply(clean.genos[, which(clean.IDs$Family == "A")], 1, CountGenos)
OneAmales <- apply(clean.genos[, which(clean.IDs$Family == "A" & clean.IDs$Sex == "M")], 1, CountGenos)
OneAfemales <- apply(clean.genos[, which(clean.IDs$Family == "A" & clean.IDs$Sex == "F")], 1, CountGenos)
ThreeCgenos <- apply(clean.genos[, which(clean.IDs$Family == "C")], 1, CountGenos)
ThreeCmales <- apply(clean.genos[, which(clean.IDs$Family == "C" & clean.IDs$Sex == "M")], 1, CountGenos)
ThreeCfemales <- apply(clean.genos[, which(clean.IDs$Family == "C" & clean.IDs$Sex == "F")], 1, CountGenos)
EightHgenos <- apply(clean.genos[, which(clean.IDs$Family == "H" )], 1, CountGenos)
EightHmales <- apply(clean.genos[, which(clean.IDs$Family == "H" & clean.IDs$Sex == "M")], 1, CountGenos)
EightHfemales <- apply(clean.genos[, which(clean.IDs$Family == "H" & clean.IDs$Sex == "F")], 1, CountGenos)

#Calculate a fisher exact test for heterogeneity between sexes in each family
F1sexheterogeneity <- NULL;
for(i in 1: length(clean.genos[,1])){
F1sexheterogeneity[i] <- fisher.test(matrix(data = cbind(F1malegenos[,i], F1femalegenos[,i]), nrow = 3))$p.value
}
SixFsexhet <- NULL;
for(i in 1: length(clean.genos[,1])){
SixFsexhet[i] <- fisher.test(matrix(data = cbind(SixFmales[,i], SixFfemales[,i]), nrow = 3))$p.value
}
ThreeCsexhet <- NULL;
for(i in 1: length(clean.genos[,1])){
ThreeCsexhet[i] <- fisher.test(matrix(data = cbind(ThreeCmales[,i], ThreeCfemales[,i]), nrow = 3))$p.value
}
EightHsexhet <- NULL;
for(i in 1: length(clean.genos[,1])){
EightHsexhet[i] <- fisher.test(matrix(data = cbind(EightHmales[,i],EightHfemales[,i]), nrow = 3))$p.value
}
OneAsexhet <- NULL;
for(i in 1: length(clean.genos[,1])){
OneAsexhet[i] <- fisher.test(matrix(data = cbind(OneAmales[,i],OneAfemales[,i]), nrow = 3))$p.value
}

#Combine these all in a Fisher meta-analysis.
sex.linked.fisher.log10p <-  -log(apply(cbind(F1sexheterogeneity, SixFsexhet, ThreeCsexhet, EightHsexhet, OneAsexhet), 1, function(x){pchisq(2*sum(-log(x)),10, lower = F)}), 10)

plot(sort(sex.linked.fisher.log10p), ylab = "-log10(p)", xlab = "SNP")

data.frame(t(F1genos), t(OneAgenos), t(ThreeCgenos), t(SixFgenos), t(EightHgenos), t(F1malegenos), t(F1femalegenos), t(OneAmales), t(OneAfemales), t(ThreeCmales), t(ThreeCfemales), t(SixFmales), t(SixFfemales), t(EightHmales), t(EightHfemales)) -> GenotypeCounts

names(GenotypeCounts) <- c("AA.F1", "Aa.F1", "aa.F1", "AA.1A","Aa.1A","aa.1A","AA.3C","Aa.3C","aa.3C","AA.6F","Aa.6F","aa.6F","AA.8H","Aa.8H","aa.8H" ,
"mAA.F1", "mAa.F1", "maa.F1", "fAA.F1", "fAa.F1", "faa.F1", "mAA.1A","mAa.1A","maa.1A","fAA.1A","fAa.1A","faa.1A", "mAA.3C","mAa.3C","maa.3C","fAA.3C","fAa.3C","faa.3C","mAA.6F","mAa.6F","maa.6F","fAA.6F","fAa.6F","faa.6F","mAA.8H","mAa.8H","maa.8H","fAA.8H","fAa.8H","faa.8H" )

rm(list = ls()[which(ls() %in% c("F1genos", "OneAgenos", "ThreeCgenos", "SixFgenos", "EightHgenos", "F1malegenos", "F1femalegenos", "OneAmales", "OneAfemales", "ThreeCmales", "ThreeCfemales", "SixFmales", "SixFfemales", "EightHmales", "EightHfemales", "F1sexheterogeneity", "SixFsexhet", "ThreeCsexhet", "EightHsexhet", "OneAsexhet", "CountGenos", "min.mean.read.depth", "min.num.called.SNPs", "GoodStrainColumns", "depths"))])

SNPFile <- which(sex.linked.fisher.log10p > -1)

#####################################

recoded.genos <- clean.genos
target <- c(16:17)
fams <- c("A","C", "H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(18,19)
fams <- c("A","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(29:30)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C", "H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))

target <- c(32,33)
fams <- c("A","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(35:36)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C", "H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(37:38)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C", "H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(42:43)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(46:47)
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C", "H", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(51:52)
fams <- c("A","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(55:56)
#THIS one has apparent very strong segregation distortion. 
fams <- c("A","H", "C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(57:58)
fams <- c("A","F", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))


target <- c(59:61)
fams <- c("A", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN","MN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN","PN"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN","MN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN","PN"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN","MN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN","PN"))

target <- c(91:92)
fams <- c("A","H", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))

target <- c(93:94)
fams <- c("A","H", "C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))



target <- c(95:97)
fams <- c("A","H", "C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))


target <- c(105:106)
fams <- c("A","H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))



target <- c(109:110)
fams <- c("A","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))




target <- c(116:118)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("H", "C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))



target <- c(122:123)
fams <- c("A","C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))

target <- c(128:129)
fams <- c("A","H", "C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(132:133)
fams <- c("A","H", "C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(134:135)
fams <- c("A","H", "C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(136:138)
fams <- c("A", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN", "PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN", "MN"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(142:143)
fams <- c("H", "C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


#SNPs 152:154 have four distinct haplotypes
#Fam A & C: 2,2,0==PP, 1,2,0 & 1,1,0 == MP; 0,1,0==MM
#Fams F & H: 1,1,1==PP, 0,0,1 & 1,2,0 == MP; 0,1,0 == MM
target <- c(152:154)
fams <- c("H",  "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("A",  "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))


target <- c(160:164)
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP","MP", "MP"))
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1 0 1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP","MP", "MP"))

target <- c(180:181)
fams <- c("A","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))


target <- c(187:188)
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F", "H", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))


target <- c(192:193)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F", "H", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(207:209)
fams <- c("A", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(223:224)
fams <- c("A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))

target <- c(227:228)
fams <- c("A","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(234:235)
fams <- c("A","H", "C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

#SNPs 241-242
#Fams A&C: 1,0 ==PP, 1,1 & 2,1 == MP, 2,2 == MM
#Fams F & H: 1,0 = P + M or P; 1,1 == M + M or P
target <- c(241:242)
fams <- c("A","C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("H","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))


target <- c(243:244)
fams <- c("A","H", "C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(247:248)
fams <- c("A","H", "C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(251:253)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN", "PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN", "MN"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(257:258)
fams <- c("A","H", "C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))



target <- c(262:263)
fams <- c("A","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))


target <- c(264:266)
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN", "PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN", "MN"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))


target <- c(272:273)
fams <- c("A","H", "C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(275:276)
fams <- c("A","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(277:278)
fams <- c("H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))


target <- c(281:282)
fams <- c("A","C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(294:296)
fams <- c("F", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN", "PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN", "MN"))
fams <- c("A", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))


target <- c(299:300)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C", "F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(302:304)
fams <- c("F", "C", "A", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(306:308)
fams <- c("F", "C", "A", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(309:310)
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C", "F", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(318:319)
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("F", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))



target <- c(320:321)
fams <- c("C", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
fams <- c("H")
#Family H is a special case where the PP and MM genotypes are identical (AA/BB and AB/BA), so they're treated as missing here.
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))


target <- c(322:323)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
fams <- c("F", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(324:325)
fams <- c("A","H", "C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(326:327)
fams <- c("H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))


target <- c(344:345)
fams <- c("A","H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(347:349)
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN", "PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN", "MN"))
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

#SNPs 351:353
#SNP 352 isn't in the lepmap defined chr, but it's in the same read as the others. It looks like it genotyped badly in the F1s but otherwise seems okay. 
#Fams A & C: 2,0,0 ==PP; 1,0,0 & 2,1,0 == MP; 1,1,0 == MM
#Fams F & H: 1,0,0 == PP; 2,1,0 & 0,0,1 ==MP; 1,1,0 == MM
target <- c(351:353)
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(354:356)
fams <- c("F", "H", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN", "PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN", "MN"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))


#SNPs 357-358 
#Fams A and C, 0,0 = P + MorP; 0,1=M + MorP
#Fams F and H: 0,1 == MM; 0,0 or 1,2 == MP; 1,1 == PP
target <- c(357:358)
fams <- c("C", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))


target <- c(363:364)
fams <- c("F", "H", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))



###These have some segreagation distortion in some families or else high error rate. 
target <- c(365:366)
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C", "A", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))



target <- c(367:368)
fams <- c("F", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))


target <- c(373:374)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

#SNPs 378-379
#Fams A and C: 0,0==MM, 1,0==MP, 2,0 == PP
#Fams F and H: 0,0==MM, 1,0 & 0,1 == MP; 1,1==PP
target <- c(378:379)
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
fams <- c("H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(381:383)
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))




target <- c(384:391)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 1 0 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP", "PP", "PP", "PP", "PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2 0 2 0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM", "MM", "MM", "MM", "MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2 0 1 0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP", "MP", "MP", "MP", "MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 1 1 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP", "MP", "MP", "MP", "MP", "MP"))
fams <- c("H","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 1 0 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP", "PP", "PP", "PP", "PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1 0 1 0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM", "MM", "MM", "MM", "MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1 0 0 0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP", "MP", "MP", "MP", "MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 1 1 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP", "MP", "MP", "MP", "MP", "MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2 0 0 0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP", "PP", "PP", "PP", "PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2 0 2 0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM", "MM", "MM", "MM", "MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2 0 1 0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP", "MP", "MP", "MP", "MP", "MP"))

target <- c(392:393)
fams <- c("A","H", "C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

#SNPs 394-395
#Fams A and C: 0,1 == MM; 1,0 & 1,1 == MP; 2,0 == PP
#Fams F and H: 1,1 == P + M or P; 0,1== M + M or P.
target <- c(394:395)
fams <- c("H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(396:397)
fams <- c("A","C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F")
#recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
#this spits an error; there's only one match, so it ends up as a vector instead of a 2x1 matrix. So here's a kluge:
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- c("PP","PP")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(404:405)
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
fams <- c("A","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))


target <- c(412:413)
fams <- c("A", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(423:424)
fams <- c("A","H", "C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(425:426)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C", "F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))


target <- c(427:428)
fams <- c("A","H", "C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(438:439)
fams <- c("A","H", "C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

#SNPs 441-443 are all on one read but segregate in an impossible pattern. These should be thrown out. 

target <- c(445:446)
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(448:449)
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A","H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(463:464)
fams <- c("H", "F","C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(469:471)
fams <- c("F", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN", "PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN", "MN"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))


target <- c(473:474)
fams <- c("A","H", "C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(476:477)
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))


target <- c(479:481)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(483:484)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(485:486)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(488:489)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(491:492)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(502:503)
fams <- c("F", "H", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(505:506)
fams <- c("H", "F","A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(507:508)
fams <- c("H", "F","A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(511:512)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("F","H", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(517:518)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(525:528)
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN","PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN","MN","MN"))
fams <- c("A", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))

target <- c(551:552)
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(558:559)
fams <- c("A", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("F", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(566:568)
fams <- c("A","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(569:570)
fams <- c("H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(574:575)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(594:596)
fams <- c("F","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("C", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(599:600)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(613:615)
fams <- c("F","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(633:637)
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2 2 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP","MP", "MP"))
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2 2 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP","MP", "MP"))


target <- c(639:640)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(643:646)
fams <- c("H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))

target <- c(674:675)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("F","H", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(678:679)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F",  "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(681:682)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F",  "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(685:686)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(690:691)
fams <- c("F",  "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(693:694)
fams <- c("H","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))


target <- c(703:704)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(706:708)
fams <- c("A","C", "F","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(725:726)
fams <- c("F",  "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(732:735) #iffy!
fams <- c("A", "C","H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))


target <- c(736:737)
fams <- c("F",  "H", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(738:739)
fams <- c("C",  "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(744:746) 
fams <- c("F","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(748:749)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(758:759)
fams <- c("F",  "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(761:763) 
fams <- c("F","H", "A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(766:767)
fams <- c("F",  "H", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(772:773)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(800:802) 
fams <- c("F","A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(803:805) 
fams <- c("F","C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(808:809)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

#Recoding 810-811
#The family C data includes a disproportionate number of anomalous/erroneous calls: 9/96. The others are quite clean.
#Fams A and C: 0,0==MM, 1,0 == MP, 2,0==PP;
#Fams F and H: 0,0==MM, 1,0 and 0,1 == MP, 1,1 == PP.
target <- c(810:811)
fams <- c("F",  "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(814:815)
fams <- c("F", "A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(830:831)
fams <- c("F",  "H", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c( "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(834:835)
fams <- c("F",  "H", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c( "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(836:838) 
fams <- c("F","C", "A", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(839:840)
fams <- c("H","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))


target <- c(843:844)
fams <- c("F",  "H", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c( "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(845:846)
fams <- c("H",  "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F","C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(853:854)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(860:862) 
fams <- c("F","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))
fams <- c("C", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP", "MP"))

target <- c(863:864)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(872:873)
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("A", "C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(888:889)
fams <- c("H",  "A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F")
#recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
#this spits an error; there's only one match, so it ends up as a vector instead of a 2x1 matrix. So here's a kluge:
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- c("PP","PP")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(904:906)
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN","MN"))
fams <- c("A", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))

target <- c(930:931)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(934:935)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(942:943) #skeptical
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("A", "C", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(966:967)
fams <- c("H",  "F", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(968:969)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(978:980)
fams <- c("A", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
fams <- c("C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))

target <- c(981:982) 
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("A", "F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(986:987)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(989:990) 
fams <- c("A", "F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))


target <- c(993:995)
fams <- c("A", "H","C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))


target <- c(1003:1004)
fams <- c("H",  "F", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(1005,1008) #1006 and 1007 don't make any sense.
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
fams <- c("A","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP", "PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM", "MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("MP", "MP"))

target <- c(1019:1021)
fams <- c("A", "H","C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))

target <- c(1023:1024)
fams <- c("A",  "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("H", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1030:1031)
fams <- c("H",  "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1041:1042)
fams <- c("H",  "A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(1051:1052)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(1055:1056)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1063:1064)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(1065:1067)
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
fams <- c("F", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))

target <- c(1076:1078)
fams <- c("H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))

target <- c(1104:1105)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F", "H","C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1107:1109)
fams <- c("H", "F", "C", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))

target <- c(1111:1112)
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F", "H","C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1130:1131)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1139:1140)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1142:1143)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1153:1154) #skeptical
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("F",  "H", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1158:1159) 
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("F",  "A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1181:1182)
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1186:1188)
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
fams <- c("H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))

target <- c(1191:1192)
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("F", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1204:1206)
fams <- c("H","A", "C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))

target <- c(1207:1209)
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
#recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
#this spits an error; there's only one match, so it ends up as a vector instead of a 2x1 matrix. So here's a kluge:
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 2" & clean.IDs$Fam %in% fams)] <- c("MM","MM","MM")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
fams <- c("H","A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))

target <- c(1210:1211) 
fams <- c("F",  "H", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1223:1224)
fams <- c("F", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A", "H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1225:1228) 
fams <- c("A",  "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 2 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 2 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))


target <- c(1230:1231) 
fams <- c("F", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1232:1233)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1241:1242) #Family F is missing a genotype class
fams <- c("H", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1251:1252)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1253:1254)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(1265:1266) 
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("H", "C","F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1269:1271)
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN","MN"))
fams <- c("A", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
fams <- c("H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))

target <- c(1277:1278)
fams <- c("F",  "H","A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))


target <- c(1308:1309) 
fams <- c("A", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1312:1313) 
fams <- c("H", "F","C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1316:1317) 
fams <- c("C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("A", "H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1319:1320) 
fams <- c("C", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 2" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1323:1325)
fams <- c("A", "C","H")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN","MN"))
fams <- c("F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))


target <- c(1326:1327) 
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("H", "F", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1329:1330) 
fams <- c("H", "F", "C", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1331:1333)
fams <- c("F", "H", "C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
fams <- c("A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))

target <- c(1350:1351) #iffy! 
fams <- c("C", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
fams <- c("H", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP"))

target <- c(1354:1357)
fams <- c("A","C")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("PN","PN","PN","PN"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MN","MN","MN","MN"))
fams <- c("H", "F")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 1 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "2 2 0 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP","MP"))

target <- c(1375:1377)
fams <- c("F", "H", "C", "A")
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 2 0" & clean.IDs$Fam %in% fams)] <- t(c("PP","PP","PP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 0 1" & clean.IDs$Fam %in% fams)] <- t(c("MM","MM","MM"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "1 1 1" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))
recoded.genos[target,which(apply(clean.genos[target,], 2, function(x){paste0(x, collapse = " ")}) == "0 1 0" & clean.IDs$Fam %in% fams)] <- t(c("MP","MP","MP"))

################################

#A Function to Calculate Segregation Pattern Likelihoods and Error Probabilities
#Returns either a vector of log likelihoods for each of the six segregation classes ("logliks"), 
#or a the single highest likelihood segregation class ("best")

SegClassLikelihood <- function(x, output = c("logliks", "best")){
	
	AAxBB <- function(err.ab, x){
	pr.aa <- 0
	pr.ab <- 1
	pr.bb <- 0
	dmultinom(x, prob=c(pr.aa*(1-2*err.ab - err.ab^2) + pr.ab * err.ab + pr.bb*err.ab^2, pr.aa*2*err.ab + pr.ab* (1- err.ab - err.ab) + pr.bb*2*err.ab, pr.aa*err.ab^2 + pr.ab*err.ab + pr.bb*(1-2*err.ab - err.ab^2)))
	}
	
	f <- AAxBB
	AAxBBLikes <- log(apply(x, 1, function(x){optimize(f, x, interval = c(0,.1), maximum = T)$objective }), 10)
	
			
	AAxAB <- function(err.ab, x){	
	pr.aa <- 0.5
	pr.ab <- 0.5
	pr.bb <- 0	
	dmultinom(x, prob=c(pr.aa*(1-2*err.ab - err.ab^2) + pr.ab * err.ab + pr.bb*err.ab^2, pr.aa*2*err.ab + pr.ab* (1- err.ab - err.ab) + pr.bb*2*err.ab, pr.aa*err.ab^2 + pr.ab*err.ab + pr.bb*(1-2*err.ab - err.ab^2)))
	}
	
	f <- AAxAB
	AAxABLikes <- log(apply(x, 1, function(x){optimize(f, x, interval = c(0,.1), maximum = T)$objective }),10)
###	
	ABxBB <- function(err.ab, x){	
	pr.aa <- 0
	pr.ab <- 0.5
	pr.bb <- 0.5	
	dmultinom(x, prob=c(pr.aa*(1-2*err.ab - err.ab^2) + pr.ab * err.ab + pr.bb*err.ab^2, pr.aa*2*err.ab + pr.ab* (1- err.ab - err.ab) + pr.bb*2*err.ab, pr.aa*err.ab^2 + pr.ab*err.ab + pr.bb*(1-2*err.ab - err.ab^2)))
	}

	f <- ABxBB
	ABxBBLikes <- log(apply(x, 1, function(x){optimize(f, x, interval = c(0,.1), maximum = T)$objective }),10)

###
	ABxAB <- function(err.ab, x){	
	pr.aa <- 0.25
	pr.ab <- 0.5
	pr.bb <- 0.25
	dmultinom(x, prob=c(pr.aa*(1-2*err.ab - err.ab^2) + pr.ab * err.ab + pr.bb*err.ab^2, pr.aa*2*err.ab + pr.ab* (1- err.ab - err.ab) + pr.bb*2*err.ab, pr.aa*err.ab^2 + pr.ab*err.ab + pr.bb*(1-2*err.ab - err.ab^2)))
	}

	f <- ABxAB
	ABxABLikes <- log(apply(x, 1, function(x){optimize(f, x, interval = c(0,.1), maximum = T)$objective }),10)

	AAxAA <- function(err.ab, x){	
	pr.aa <- 1
	pr.ab <- 0
	pr.bb <- 0
	dmultinom(x, prob=c(pr.aa*(1-2*err.ab - err.ab^2) + pr.ab * err.ab + pr.bb*err.ab^2, pr.aa*2*err.ab + pr.ab* (1- err.ab - err.ab) + pr.bb*2*err.ab, pr.aa*err.ab^2 + pr.ab*err.ab + pr.bb*(1-2*err.ab - err.ab^2)))
	}

	f <- AAxAA
	AAxAALikes <- log(apply(x, 1, function(x){optimize(f, x, interval = c(0,.1), maximum = T)$objective }),10)

	BBxBB <- function(err.ab, x){	
	pr.aa <- 0
	pr.ab <- 0
	pr.bb <- 1
	dmultinom(x, prob=c(pr.aa*(1-2*err.ab - err.ab^2) + pr.ab * err.ab + pr.bb*err.ab^2, pr.aa*2*err.ab + pr.ab* (1- err.ab - err.ab) + pr.bb*2*err.ab, pr.aa*err.ab^2 + pr.ab*err.ab + pr.bb*(1-2*err.ab - err.ab^2)))
	}	
	
	f <- BBxBB
	BBxBBLikes <- log(apply(x, 1, function(x){optimize(f, x, interval = c(0,.1), maximum = T)$objective }),10)

	LikelihoodSequence <- c(AAxBBLikes, AAxABLikes, ABxBBLikes, ABxABLikes, AAxAALikes, BBxBBLikes)
	names(LikelihoodSequence) <- c("AAxBB", "AAxAB", "ABxBB", "ABxAB", "AAxAA", "BBxBB")

if(output == "logliks"){
	return(LikelihoodSequence)
	}
	else if (output == "best"){
	return(names(LikelihoodSequence) [which(LikelihoodSequence == max(LikelihoodSequence))])
	}
	else{stop("What is the desired output?")}
}
#######################################################

#Calculate the likelihood for each snp for each family for each segregation pattern

GenotypeFile <- GenotypeCounts[,1:15]	

FamilySegLikelihoods <- matrix(nrow = dim(GenotypeFile)[1], ncol = 30);
for(j in 1:dim(GenotypeFile)[1]){
	
	for(i in 1:5){
		FamilySegLikelihoods[j,(i+5*i-5):(i+5*i)] <- SegClassLikelihood(GenotypeFile[j,(i+2*i-2):(i+2*i)], out = "logliks")
	
	}
}
likeseq <- c("AAxBB", "AAxAB", "ABxBB", "ABxAB", "AAxAA", "BBxBB")
names(FamilySegLikelihoods) <- c(paste("F1",likeseq),paste("1A",likeseq),paste("3C",likeseq),paste("6F",likeseq),paste("8H",likeseq)) 

#######################################################
#Calculate the likelihood for each snp for the whole set of families, for every possible segregation pattern
n.f1families <- 4; 
n.patterns <- (1 + 3^n.f1families + 3^n.f1families + 6^n.f1families + 1 +1)

everysegpattern <- matrix(nrow = dim(GenotypeFile)[1], ncol = n.patterns)
MLgenotypes <- matrix(nrow = 1461, ncol = 5)
colnames(MLgenotypes) <-  c("P0","A1","C3","F6","H8")


#P0 AAxBB, F1 crosses must all be ABxAB
everysegpattern[,1] <- apply(FamilySegLikelihoods[,c(1,10,16,22,28)], 1, sum)
MLgenotypes[1,] <- likeseq[c(1,4,4,4,4)]

#P0 AAxAB, F1 crosses can be AAxAB, ABxAB, or AAxAA
x <- c(2,4,5)  #The seg classes of the F2 families
y <- 2 #The seg class of F1s
c<- 0;
for(i in 1:3){	#1A
	for(j in 1:3){	#3C
		for(k in 1:3){	#6F
			for(l in 1:3){	#8H
				c = c+1
				#The extra log(0.5,10) etc added to the likelihoods below are to account for the probability that the F1s that cross are of specific cross types, given the P0 genotypes. E.g., if P0s are AA x AB, the probability that a specific F1 cross is between AA and AA is .25.
				everysegpattern[,1+c] <- sum(c(i,j,k,l) == 1)*log(.5,10) + sum(c(i,j,k,l) == 2)*log(.25,10) + sum(c(i,j,k,l) == 3)*log(0.25,10) + apply(FamilySegLikelihoods[,c(y,6+x[i], 12+x[j], 18+x[k], 24+x[l])], 1,sum)
				MLgenotypes[1+c,] <- likeseq[c(y,x[i],x[j],x[k],x[l])]	
			}
		}
	}
}

#P0 ABxBB, F1 crosses can be ABxBB, ABxAB, or BBxBB
x <- c(3,4,6) #he seg classes fo the F2 families
y <- 3 #The seg class of F1s
c<- 0;
for(i in 1:3){	#1A
	for(j in 1:3){	#3C
		for(k in 1:3){	#6F
			for(l in 1:3){	#8H
				c = c+1
				everysegpattern[,82+c] <- sum(c(i,j,k,l) == 1)*log(.5,10) + sum(c(i,j,k,l) == 2)*log(.25,10) + sum(c(i,j,k,l) == 3)*log(0.25,10) + apply(FamilySegLikelihoods[,c(y,6+x[i], 12+x[j], 18+x[k], 24+x[l])], 1,sum)
				MLgenotypes[82+c,] <- likeseq[c(y,x[i],x[j],x[k],x[l])]					
			}
		}
	}
}

#P0 ABxAB, F1 crosses can be any of the six classes!
x <- c(1:6) #he seg classes fo the F2 families
y <- 4 #The seg class of F1s
c<- 0;
for(i in 1:6){	#1A
	for(j in 1:6){	#3C
		for(k in 1:6){	#6F
			for(l in 1:6){	#8H
				c = c+1
				everysegpattern[,82+81+c] <- sum(c(i,j,k,l) == 1)*log(2/16,10) + sum(c(i,j,k,l) == 2)*log(4/16,10) + sum(c(i,j,k,l) == 3)*log(4/16,10) + sum(c(i,j,k,l) == 4)*log(4/16,10) + sum(c(i,j,k,l) == 5)*log(1/16,10) + sum(c(i,j,k,l) == 6)*log(1/16,10) + apply(FamilySegLikelihoods[,c(y,6+x[i], 12+x[j], 18+x[k], 24+x[l])], 1,sum)
				MLgenotypes[82+81+c,] <- likeseq[c(y,x[i],x[j],x[k],x[l])]					
			}
		}
	}
}

#P0 AAxAA, F1 crosses must all be AAxAA
everysegpattern[,1460] <- apply(FamilySegLikelihoods[,c(5,11,17,23,29)], 1, sum)
MLgenotypes[1460,] <- likeseq[c(5,5,5,5,5)]

#P0 BBxBB, F1 crosses must all be BBxBB
everysegpattern[,1461] <- apply(FamilySegLikelihoods[,c(6,12,18,24,30)], 1, sum)
MLgenotypes[1461,] <- likeseq[c(6,6,6,6,6)]

#Many of the seg patterns above are not actually possible because male Z is in every cross. So here we'll remove the impossible patterns. 
impossible <- NULL;
for(i in 1:1461){
	p0 <- MLgenotypes[i,1];
	if(p0 == "AAxAB"){
		howmanyAAxAA <- sum(MLgenotypes[i,2:5] == "AAxAA")
		howmanyABxAB <- sum(MLgenotypes[i,2:5] == "ABxAB")
		if(howmanyAAxAA >0 & howmanyABxAB >0){
			impossible <- c(impossible, i)
		}
	}
	else if(p0 == "ABxBB"){
		howmanyBBxBB <- sum(MLgenotypes[i,2:5] == "BBxBB")
		howmanyABxAB <- sum(MLgenotypes[i,2:5] == "ABxAB")
		if(howmanyBBxBB >0 & howmanyABxAB >0){
			impossible <- c(impossible, i)
		}
	}
	else if(p0 == "ABxAB"){
		howmanyBBxBB <- sum(MLgenotypes[i,2:5] == "BBxBB")
		howmanyAAxAA <- sum(MLgenotypes[i,2:5] == "AAxAA")
		howmanyABxAB <- sum(MLgenotypes[i,2:5] == "ABxAB")
		howmanyAAxBB <- sum(MLgenotypes[i,2:5] == "AAxBB")
		howmanyAA <- sum(MLgenotypes[i,2:5] %in% c("AAxAA", "AAxAB", "AAxBB"))
		howmanyAB <- sum(MLgenotypes[i,2:5] %in% c("AAxAB", "ABxBB", "ABxAB"))
		howmanyBB <- sum(MLgenotypes[i,2:5] %in% c("AAxBB", "ABxBB", "BBxBB"))
		if(howmanyBBxBB >0 & howmanyAAxAA >0){
			impossible <- c(impossible, i)
		}
		else if(howmanyABxAB >0 & howmanyAAxAA >0){
			impossible <- c(impossible, i)
		}
		else if(howmanyABxAB >0 & howmanyBBxBB >0){
			impossible <- c(impossible, i)
		}	
		else if(howmanyABxAB >0 & howmanyAAxBB >0){
			impossible <- c(impossible, i)
		}	
		else if(howmanyAA < 4 & howmanyAB < 4 & howmanyBB <4 ){
			impossible <- c(impossible, i)
		}
	}
}

everysegpattern <- everysegpattern[,-impossible]
MLgenotypes <- MLgenotypes[-impossible,]

bestpattern <- MLgenotypes[apply(everysegpattern, 1, function(x){which(x == max(x))}),]
highestML <- apply(everysegpattern, 1, function(x){x[which(x == sort(x)[length(x)])] }) 
Firstvssecond <- apply(everysegpattern, 1, function(x){diff(sort(x))[length(x)-1]} )

rm(list = ls()[which(ls() %in% c("howmanyBBxBB" , "howmanyAAxAA", "howmanyABxAB", "howmanyAAxBB", "howmanyAA", "howmanyAB", "howmanyBB" , "i" ,"j", "k", "l", "impossible", "n.f1families","n.patterns"))])

########################
#Now combine recoded multi-snp markers with the rest of the dataset
contignames <- levels(clean.SNPs[,1])
snpspercontig <- NULL; for(i in 1:(length(contignames))){snpspercontig[i] <- sum(clean.SNPs[,1] == contignames[i])}
data.frame(contignames, snpspercontig) -> contigs
table(snpspercontig)

clean.SNPs[,7] <- sex.linked.fisher.log10p
clean.SNPs[,8] <- NA
for(i in 1:1389){clean.SNPs[i,8] <- contigs[which(contigs[,1] == clean.SNPs[i,1]),2]}
clean.SNPs[,9:13] <- NA
clean.SNPs[,9:13] <- bestpattern
clean.SNPs[,14] <- NA
clean.SNPs[,14] <- highestML
clean.SNPs[,15] <- NA
clean.SNPs[,15] <- Firstvssecond
clean.SNPs[,16] <- NA
clean.SNPs[,16] <- row.names(clean.SNPs)
names(clean.SNPs) <- c("contig", "pos", "dot", "ref","alt","qual","sexP","SNPsInContig", "F1seg", "Aseg","Cseg","Fseg", "Hseg", "ML","firstvssecond", "SNP.number")

###*RECODING THE MULTISNP CONTIGS*###*****************************
reco <- NULL
for(i in 1:1389){reco[i] <- "MP" %in% levels(as.factor(as.character(recoded.genos[i,])))}
sum(reco)  #448 recoded SNPs from multi-snp contigs

recoded.genos[reco == T & recoded.genos == 0] <- NA
recoded.genos[reco == T & recoded.genos == 1] <- NA
recoded.genos[reco == T & recoded.genos == 2] <- NA
recoded.genos[reco == T, clean.IDs$Gen == 1] <- "MP"

#Now, overwriting the "bestpattern" to convert the multi-snp contig snps to IC
icpattern <- c("AAxBB" ,"ABxAB", "ABxAB", "ABxAB", "ABxAB")
for(i in 1:(sum(reco))){bestpattern[reco,][i,] <- icpattern}

###*****************************###*****************************

#Impute parental genotypes
parentgenotypes <- matrix(nrow = length(SNPFile), ncol = 7)

for(i in 1:length(SNPFile)){
	if(bestpattern[i,1] == "AAxBB"){
		parentgenotypes[i,] <- c("AA","BB","AB","AB","AB","AB","AB")
	}
	else if(bestpattern[i,1] == "AAxAA"){
		parentgenotypes[i,] <- c("AA","AA","AA","AA","AA","AA","AA")
	}
	else if(bestpattern[i,1] == "BBxBB"){
		parentgenotypes[i,] <- c("BB","BB","BB","BB","BB","BB","BB")
	}
	else if(bestpattern[i,1] == "AAxAB"){
	if(sum(bestpattern[i,2:5] == "AAxAA") == 4 )
		{
	parentgenotypes[i,] <- c("AA","AB","AA","AA","AA","AA","AA")
		}
	else if(sum(bestpattern[i,2:5] == "ABxAB") == 4 )
		{
	parentgenotypes[i,] <- c("AA","AB","AB","AB","AB","AB","AB")
		}
	else if(sum(bestpattern[i,2:5] == "AAxAB") == 4 )
		{
	parentgenotypes[i,] <- c("AA","AB","N","N","N","N","N")
		}				
	else if(sum(bestpattern[i,2:5] == "ABxAB") %in% c(1,2,3) )
		{
			parentgenotypes[i,1:3] <- c("AA", "AB", "AB")
			for(q in 2:5){
				if(bestpattern[i,q] == "ABxAB"){
					parentgenotypes[i,2+q] <- "AB"
				}
				else if(bestpattern[i,q] == "AAxAB"){
					parentgenotypes[i,2+q] <- "AA"
				}
			}
		}
	else if(sum(bestpattern[i,2:5] == "AAxAA") %in% c(1,2,3) )
		{
			parentgenotypes[i,1:3] <- c("AA", "AB", "AA")
			for(q in 2:5){
				if(bestpattern[i,q] == "AAxAB"){
					parentgenotypes[i,2+q] <- "AB"
				}
				else if(bestpattern[i,q] == "AAxAA"){
					parentgenotypes[i,2+q] <- "AA"
				}
			}
		}

	}
	else if(bestpattern[i,1] == "ABxBB"){
	if(sum(bestpattern[i,2:5] == "BBxBB") == 4 )
		{
	parentgenotypes[i,] <- c("BB","AB","BB","BB","BB","BB","BB")
		}
	else if(sum(bestpattern[i,2:5] == "ABxAB") == 4 )
		{
	parentgenotypes[i,] <- c("BB","AB","AB","AB","AB","AB","AB")
		}
	else if(sum(bestpattern[i,2:5] == "ABxBB") == 4 )
		{
	parentgenotypes[i,] <- c("BB","AB","N","N","N","N","N")
		}				
	else if(sum(bestpattern[i,2:5] == "ABxAB") %in% c(1,2,3) )
		{
			parentgenotypes[i,1:3] <- c("BB", "AB", "AB")
			for(q in 2:5){
				if(bestpattern[i,q] == "ABxAB"){
					parentgenotypes[i,2+q] <- "AB"
				}
				else if(bestpattern[i,q] == "ABxBB"){
					parentgenotypes[i,2+q] <- "BB"
				}
			}
		}
	else if(sum(bestpattern[i,2:5] == "BBxBB") %in% c(1,2,3) )
		{
			parentgenotypes[i,1:3] <- c("BB", "AB", "BB")
			for(q in 2:5){
				if(bestpattern[i,q] == "ABxBB"){
					parentgenotypes[i,2+q] <- "AB"
				}
				else if(bestpattern[i,q] == "BBxBB"){
					parentgenotypes[i,2+q] <- "BB"
				}
			}
		}

	}

	else if(bestpattern[i,1] == "ABxAB"){
		if(sum(bestpattern[i,2:5] == "AAxAA") == 4){
			parentgenotypes[i,] <- c("AB","AB","AA","AA","AA","AA","AA")			
		}
		else if(sum(bestpattern[i,2:5] == "BBxBB") == 4){
			parentgenotypes[i,] <- c("AB","AB","BB","BB","BB","BB","BB")
		}
		else if(sum(bestpattern[i,2:5] == "ABxAB") == 4){
			parentgenotypes[i,] <- c("AB","AB","AB","AB","AB","AB","AB")		
		}
		else if(sum(bestpattern[i,2:5] == "AAxAB") == 4){
			parentgenotypes[i,] <- c("AB","AB","N","N","N","N","N")			
		}
		else if(sum(bestpattern[i,2:5] == "ABxBB") == 4){
			parentgenotypes[i,] <- c("AB","AB","N","N","N","N","N")		
		}
		else if(sum(bestpattern[i,2:5] == "AAxBB") == 4){
			parentgenotypes[i,] <- c("AB","AB","N","N","N","N","N")					
		}
		
		#Next block: if Z = AA
		
		else if(sum(bestpattern[i,2:5] == "AAxBB") >0 & sum(bestpattern[i,2:5] == "AAxAB") > 0){	
			parentgenotypes[i,1:3] <- c("AB","AB","AA")					
			for(q in 2:5){
				if(bestpattern[i,q] == "AAxBB"){
					parentgenotypes[i,2+q] <- "BB"
				}
				else if(bestpattern[i,q] == "AAxAB"){
					parentgenotypes[i,2+q] <- "AB"
				}
				else if(bestpattern[i,q] == "AAxAA"){
					parentgenotypes[i,2+q] <- "AA"
				}
			}
		}
		else if(sum(bestpattern[i,2:5] == "AAxBB") >0 & sum(bestpattern[i,2:5] == "AAxAA") > 0){	
			parentgenotypes[i,1:3] <- c("AB","AB","AA")			
			for(q in 2:5){
				if(bestpattern[i,q] == "AAxBB"){
					parentgenotypes[i,2+q] <- "BB"
				}
				else if(bestpattern[i,q] == "AAxAB"){
					parentgenotypes[i,2+q] <- "AB"
				}
				else if(bestpattern[i,q] == "AAxAA"){
					parentgenotypes[i,2+q] <- "AA"
				}
			}
		}
		else if(sum(bestpattern[i,2:5] == "AAxAB") >0 & sum(bestpattern[i,2:5] == "AAxAA") > 0){	
			parentgenotypes[i,1:3] <- c("AB","AB","AA")			
			for(q in 2:5){
				if(bestpattern[i,q] == "AAxBB"){
					parentgenotypes[i,2+q] <- "BB"
				}
				else if(bestpattern[i,q] == "AAxAB"){
					parentgenotypes[i,2+q] <- "AB"
				}
				else if(bestpattern[i,q] == "AAxAA"){
					parentgenotypes[i,2+q] <- "AA"
				}  
			}
		}
		
		
		
		#Next block: if Z = BB
		else if(sum(bestpattern[i,2:5] == "AAxBB") >0 & sum(bestpattern[i,2:5] == "ABxBB") > 0){	
			parentgenotypes[i,1:3] <- c("AB","AB","BB")					
			for(q in 2:5){
				if(bestpattern[i,q] == "AAxBB"){
					parentgenotypes[i,2+q] <- "AA"
				}
				else if(bestpattern[i,q] == "ABxBB"){
					parentgenotypes[i,2+q] <- "AB"
				}
				else if(bestpattern[i,q] == "BBxBB"){
					parentgenotypes[i,2+q] <- "BB"
				}
			}
		}
		else if(sum(bestpattern[i,2:5] == "AAxBB") >0 & sum(bestpattern[i,2:5] == "BBxBB") > 0){	
			parentgenotypes[i,1:3] <- c("AB","AB","BB")			
			for(q in 2:5){
				if(bestpattern[i,q] == "AAxBB"){
					parentgenotypes[i,2+q] <- "AA"
				}
				else if(bestpattern[i,q] == "ABxBB"){
					parentgenotypes[i,2+q] <- "AB"
				}
				else if(bestpattern[i,q] == "BBxBB"){
					parentgenotypes[i,2+q] <- "BB"
				}
			}
		}
		else if(sum(bestpattern[i,2:5] == "ABxBB") >0 & sum(bestpattern[i,2:5] == "BBxBB") > 0){	
			parentgenotypes[i,1:3] <- c("AB","AB","BB")			
			for(q in 2:5){
				if(bestpattern[i,q] == "AAxBB"){
					parentgenotypes[i,2+q] <- "AA"
				}
				else if(bestpattern[i,q] == "ABxBB"){
					parentgenotypes[i,2+q] <- "AB"
				}
				else if(bestpattern[i,q] == "BBxBB"){
					parentgenotypes[i,2+q] <- "BB"
				}
			}
		}



		#Next block: if Z = AB
		else if(sum(bestpattern[i,2:5] == "AAxAB") >0 & sum(bestpattern[i,2:5] == "ABxBB") > 0){	
			parentgenotypes[i,1:3] <- c("AB","AB","AB")					
			for(q in 2:5){
				if(bestpattern[i,q] == "AAxAB"){
					parentgenotypes[i,2+q] <- "AA"
				}
				else if(bestpattern[i,q] == "ABxBB"){
					parentgenotypes[i,2+q] <- "BB"
				}
				else if(bestpattern[i,q] == "ABxAB"){
					parentgenotypes[i,2+q] <- "AB"
				}
			}
		}
		else if(sum(bestpattern[i,2:5] == "AAxAB") >0 & sum(bestpattern[i,2:5] == "ABxAB") > 0){	
			parentgenotypes[i,1:3] <- c("AB","AB","AB")			
			for(q in 2:5){
				if(bestpattern[i,q] == "AAxAB"){
					parentgenotypes[i,2+q] <- "AA"
				}
				else if(bestpattern[i,q] == "ABxBB"){
					parentgenotypes[i,2+q] <- "BB"
				}
				else if(bestpattern[i,q] == "ABxAB"){
					parentgenotypes[i,2+q] <- "AB"
				}
			}
		}
		else if(sum(bestpattern[i,2:5] == "ABxBB") >0 & sum(bestpattern[i,2:5] == "ABxAB") > 0){	
			parentgenotypes[i,1:3] <- c("AB","AB","AB")			
			for(q in 2:5){
				if(bestpattern[i,q] == "AAxAB"){
					parentgenotypes[i,2+q] <- "AA"
				}
				else if(bestpattern[i,q] == "ABxBB"){
					parentgenotypes[i,2+q] <- "BB"
				}
				else if(bestpattern[i,q] == "ABxAB"){
					parentgenotypes[i,2+q] <- "AB"
				}
			}
		}
	}
}

#Remove redundant SNPs
SNPtodelete <- duplicated(recoded.genos)

###*****************************###*****************************
#Replace raw genotypes with rqtl-processed recoded inter-cross genotypes
rqtlMap <- read.cross(file = "Clean.ML.ordered.004.csv", format = "csv", geno = c("AA","AB","BB", "not BB", "not AA"), na.strings = c("NA","-")) 

rqtlrecoded.genos <- recoded.genos

rqtld.snps <- rep(F, 1389)
for(a in 1:10){
	markercount <- nmar(rqtlMap)[a]
	for(w in 1:markercount){
		snp.name <- as.numeric(strsplit(names(rqtlMap$geno[[a]]$map), "P")[[w]][2])	
		rqtld.snps[snp.name] <- T
		for(r in 1:nind(rqtlMap)){
			focalworm <- which(clean.IDs$X1 == rqtlMap$pheno[r,"worm"])
			rqtlrecoded.genos[snp.name, focalworm] <- rqtlMap$geno[[a]]$data[r,w] -1 #The minus-one makes these calls into 0,1,2 rather than 1,2,3.

		}
		
	}
	
}

integer.recoded.genos <- clean.genos

integer.recode <- function(x){
x[x == "MM"] <- 0
x[x == "MP"] <- 1
x[x == "PP"] <- 2
x[is.na(x)] <- 3
x[x == "MN"] <- 0 #####4   ##Apparently lepmap can't deal with these genotypes
x[x == "PN"] <- 0 #####5
x[x == "0"] <- 0
x[x == "1"] <- 1
x[x == "2"] <- 2
x[x == "4"] <- 0
x[x == "5"] <- 0
as.integer(x)	
}

for(i in 1: dim(rqtlrecoded.genos)[2]){
integer.recoded.genos[,i] <- integer.recode(rqtlrecoded.genos[,i])
}

#Recode the MM MP and PP genotypes
makemakepedsnps <- function(x){
	x[x == 0] <- "1 1"
	x[x == 1] <- "1 2"
	x[x == 2] <- "2 2"
	x[is.na(x)] <- "0 0"
	x[x == 3] <- "0 0"	
	x
	}

snpstoinclude <- which(SNPtodelete ==F)
rqtld.snpstoinclude <- rqtld.snps[snpstoinclude]
clean.snpstoinclude.SNPs <- clean.SNPs[snpstoinclude,]
genofile <- integer.recoded.genos[snpstoinclude,]
inferredgenos <- parentgenotypes[snpstoinclude,]


P0dad <- 103	
P0mom <- 104
MaleZid <- 291

genofile[,which(clean.IDs$Ind == "F1.M.Z")] 		<- as.numeric(as.factor(inferredgenos[,3])) -1
genofile[,which(clean.IDs$Ind == "F1.F.1Aa")] 		<- as.numeric(as.factor(inferredgenos[,4])) -1
genofile[,which(clean.IDs$Ind == "F1.F.3Cb")] 		<- as.numeric(as.factor(inferredgenos[,5])) -1
genofile[,which(clean.IDs$Ind == "F1.F.6Fb")] 		<- as.numeric(as.factor(inferredgenos[,6])) -1
genofile[,which(clean.IDs$Ind == "F1.F.8H")] 		<- as.numeric(as.factor(inferredgenos[,7])) -1

makeped <- matrix(nrow = dim(genofile)[2], ncol = 6 + dim(genofile)[1], data = NA)

for(i in 1:dim(genofile)[2]){
	
	if(clean.IDs$Generation[i] ==1){

	makeped[i,1] <- which(levels(clean.IDs[,5]) == clean.IDs[i,5]) #family as integer

	makeped[i,2] <- clean.IDs[i,1] #individual as integer

	makeped[i,3] <- P0dad 			
	
	makeped[i,4] <- P0mom  #Mom is ID 103 				
	
	makeped[i,5] <- as.numeric(clean.IDs[i,3])
	
	makeped[i,6] <- 0	
	
	makeped[i,7:dim(makeped)[2]] <- makemakepedsnps(genofile[,i])
	
	}
	else{
		if(clean.IDs$Generation[i] ==2){
			
	makeped[i,1] <- which(levels(clean.IDs[,5]) == clean.IDs[i,5]) #family as integer

	makeped[i,2] <- clean.IDs[i,1] #individual as integer

	makeped[i,3] <- 1000 + 	which(levels(clean.IDs[,5]) == clean.IDs[i,5])
	
	makeped[i,4] <- 2000 + 	which(levels(clean.IDs[,5]) == clean.IDs[i,5])
	
	makeped[i,5] <- as.numeric(clean.IDs[i,3])
	
	makeped[i,6] <- 0	
	
	makeped[i,7:dim(makeped)[2]] <- makemakepedsnps(genofile[,i])			
		}
		
		}
	
}
makeped[makeped[,5] == 3, 5] <- 1  ##### This is necessary to convert the sex integers to M = 1 and F = 2.
makeped[is.na(makeped[,5]),5] <- 0


dadgeno <- NULL
for(i in 1:(dim(genofile)[1])){
	if(rqtld.snpstoinclude[i] == F){
		dadgeno[i] <- "0 0"
	}else if(rqtld.snpstoinclude[i] == T){
		dadgeno[i] <- "1 1"
	}
}
dadline <- c(5,P0dad,0,0,1,0,dadgeno)

momgeno <- NULL
for(i in 1:(dim(genofile)[1])){
	if(rqtld.snpstoinclude[i] == F){
		momgeno[i] <- "0 0"
	}else if(rqtld.snpstoinclude[i] == T){
		momgeno[i] <- "2 2"
	}
}
momline <- c(5,P0mom, 0,0,2,0,momgeno)


ZxAdad <- c(which(levels(clean.IDs[,5]) == "A") , 1000+  which(levels(clean.IDs[,5]) == "A"), 0,0,1,0, makemakepedsnps(genofile[,which(clean.IDs$Ind == "F1.M.Z")]))

ZxCdad <- c(which(levels(clean.IDs[,5]) == "C") , 1000+  which(levels(clean.IDs[,5]) == "C"), 0,0,1,0, makemakepedsnps(genofile[,which(clean.IDs$Ind == "F1.M.Z")]))

ZxFdad <- c(which(levels(clean.IDs[,5]) == "F") , 1000+  which(levels(clean.IDs[,5]) == "F"), 0,0,1,0, makemakepedsnps(genofile[,which(clean.IDs$Ind == "F1.M.Z")]))

ZxHdad <- c(which(levels(clean.IDs[,5]) == "H") , 1000+  which(levels(clean.IDs[,5]) == "H"), 0,0,1,0, makemakepedsnps(genofile[,which(clean.IDs$Ind == "F1.M.Z")]))

ZxAmom <- c(which(levels(clean.IDs[,5]) == "A") , 2000+  which(levels(clean.IDs[,5]) == "A"), 0,0,2,0, makemakepedsnps(genofile[,which(clean.IDs$Ind == "F1.F.1Aa")]))

ZxCmom <- c(which(levels(clean.IDs[,5]) == "C") , 2000+  which(levels(clean.IDs[,5]) == "C"), 0,0,2,0, makemakepedsnps(genofile[,which(clean.IDs$Ind == "F1.F.3Cb")]))

ZxFmom <- c(which(levels(clean.IDs[,5]) == "F") , 2000+  which(levels(clean.IDs[,5]) == "F"), 0,0,2,0, makemakepedsnps(genofile[,which(clean.IDs$Ind == "F1.F.6Fb")]))

ZxHmom <- c(which(levels(clean.IDs[,5]) == "H") , 2000+  which(levels(clean.IDs[,5]) == "H"), 0,0,2,0, makemakepedsnps(genofile[,which(clean.IDs$Ind == "F1.F.8H")]))

makeped <- rbind(dadline, momline,  ZxAdad, ZxCdad, ZxFdad, ZxHdad, ZxAmom, ZxCmom, ZxFmom, ZxHmom, makeped)
rm(list = ls()[which(ls() %in% c("dadline", "momline", "ZxAdad", "ZxCdad", "ZxFdad", "ZxHdad", "ZxAmom", "ZxCmom", "ZxFmom", "ZxHmom"))])

#Next we will be switching to lepmap2 and lepmap3. These need to be directories within /Applications 
#First copy the perl script ConvertLepmapToRqtl.pl into the working directory of lepmap3

system("cp ConvertLepmapToRqtl.pl /Applications/lepmap3/")

setwd("/Applications/lepmap2")

write.table(makeped, file = paste0("W",dim(genofile)[2],".S",dim(genofile)[1],".makeped.txt"), sep = "\t", quot=F, row.names = F, col.names = F)

system("awk -f scripts/linkage2post.awk W288.S1111.makeped.txt | java -cp binary+code/bin/ Transpose >W288.S1111.post")
system("java -cp binary+code/bin/ ParentCallGrandparents data=W288.S1111.post XLimit=8 ZLimit=8 >W288.S1111.call.X")
system("awk -f scripts/simpleConvert.awk W288.S1111.call.X | cut -f 3- | java -cp binary+code/bin/ Transpose >W288.S1111.imp.linkage.X")
system("java -cp binary+code/bin/ Filtering data=W288.S1111.imp.linkage.X epsilon=0.02 dataTolerance=0.0001 >W288.S1111.filtered.X")
system("java -cp binary+code/bin/ SeparateChromosomes data=W288.S1111.filtered.X lodLimit=15 >W288.S1111.imp.fil.X.map")
initial.map <- read.table(file = "W288.S1111.imp.fil.X.map")
system("java -cp binary+code/bin/ JoinSingles W288.S1111.imp.fil.X.map data= W288.S1111.filtered.X lodLimit=10 lodDifference=5 >W288.S1111.imp.fil.X.js.map")
js.map <- read.table(file = "W288.S1111.imp.fil.X.map")

SNPsInTheMap  <- data.frame(clean.snpstoinclude.SNPs, js.map, initial.map) 
names(SNPsInTheMap)[17] <- "Initial"
names(SNPsInTheMap)[18] <- "JS"
table(js.map[,1])
boxplot(clean.snpstoinclude.SNPs$sexP ~ js.map[,1])

#Switching to lepmap3 for faster marker ordering
setwd("/Applications/lepmap3")
system("java -cp binary+code/bin/ Filtering2 data=/Applications/lepmap2/W288.S1111.call.X dataTolerance = 0.0001 >W288.S1111.lm3.filtered")
write.table(SNPsInTheMap, file = "W288.S1111.SNPsInTheMap.txt", sep = "\t", quote = F, row.names = F)

#Identify the autosomes
autostatus <- NULL; for(q in 1: (dim(table(js.map)) -1)){autostatus[q] <- mean(SNPsInTheMap$sexP[SNPsInTheMap$JS == q]) }
autosomal.lgs <- which(autostatus[(which(table(SNPsInTheMap$JS) >10) -1)[-c(1)]] <2) #LGs with >10 markers and no sex linkage

####################################
#NB: there is some manual intervention required here to find the phasing with the highest likelihood for each chromosome
# The .rp files used to construct the genetic map are included in File S3 in the directory MLchromosomephases. To bypass the manual interventions here, simply use these .rp files. Copy the rp files into the lepmap3 directory and skip to the SKIP TO HERE block 40 lines down. 

num.iter <- 100

#This block runs OrderMarkers2 with randomPhase=1 for the phasing
for(m in 1: length(autosomal.lgs)){
targetchr <- autosomal.lgs[m]
system(paste0("java -cp binary+code/bin/ OrderMarkers2 data= W288.S1111.lm3.filtered map=/Applications/lepmap2/W288.S1111.imp.fil.X.map numMergeIterations=",num.iter, " randomPhase=1 outputPhasedData=1 chromosome=", targetchr, " >WithRandomPhaseW288.S1111.ch",targetchr))
}

#This block runs OrderMarkers2 without randomPhase=1 for the phasing
for(m in 1: length(autosomal.lgs)){
targetchr <- autosomal.lgs[m]
system(paste0("java -cp binary+code/bin/ OrderMarkers2 data=W288.S1111.lm3.filtered map=/Applications/lepmap2/W288.S1111.imp.fil.X.map numMergeIterations=",num.iter, " outputPhasedData=1 chromosome=", targetchr, " >W288.S1111.ch",targetchr))
}

randlep <- NULL
notrandlep <- NULL
for(i in 1:length(autosomal.lgs)){
	targetchr <- autosomal.lgs[i]
	notrandlep[i] <- as.numeric(as.character(read.delim(file = paste0("/Applications/lepmap3/W288.S1111.ch", targetchr), comment = "", head = F, sep = " ")[2,7]))
	randlep[i] <- as.numeric(as.character(read.delim(file = paste0("/Applications/lepmap3/WithRandomPhaseW288.S1111.ch", targetchr), comment = "", head = F, sep = " ")[2,7]))
}
data.frame(autosomal.lgs, randlep, notrandlep)


#These two approaches gave reasonably different results for a few chromosomes, with one having higher likelihood for some and the other for others. 
#We used the following approach to find the highest likelihood phasing.
#We repeatedly ran evaluateOrder FOR EACH CHROMOSOME, with randomPhase=1, using both available orders for each chromosome. 
#Then we retained the best one as ws.targetchr.rp 
#That's the phasing output used below.
system(paste0("java -cp binary+code/bin/ OrderMarkers2 data= W288.S1111.lm3.filtered map=/Applications/lepmap2/W288.S1111.imp.fil.X.map evaluateOrder= W288.S1111.ch",targetchr, " improveOrder=0 randomPhase=1 outputPhasedData=1 >ws.",targetchr,".rp" ))
system(paste0("java -cp binary+code/bin/ OrderMarkers2 data= W288.S1111.lm3.filtered map=/Applications/lepmap2/W288.S1111.imp.fil.X.map evaluateOrder=WithRandomPhaseW288.S1111.ch",targetchr, " improveOrder=0 randomPhase=1 outputPhasedData=1 >ws.",targetchr,".rp" ))
#Run each of these a few times to find the highest likelihood and then keep that one. 
#improvements: 	lg2 -> -2695.7
#				lg7 -> -2863.3

#Make sure the .rp files have the highest observed likelihoods		

################
## SKIP TO HERE if using the .rp files from the MLchromosomephases directory. 
################		

rpln <- NULL				
for(i in 1:length(autosomal.lgs)){
	targetchr <- autosomal.lgs[i]
	rpln[i] <- as.numeric(as.character(read.delim(file = paste0("/Applications/lepmap3/ws.", targetchr, ".rp"), comment = "", head = F, sep = " ")[2,7]))
}
data.frame(autosomal.lgs, randlep, notrandlep, rpln)
				
####################################
#Reformat the phase inferences for rqtl 

library(qtl)
inputs <- c("Fam2", "Fam3", "Fam4", "Fam6")

############
#still in working directory /Applications/lepmap3

for(z in 1: length(autosomal.lgs)){
	
targetchr <- autosomal.lgs[z]

system(paste0("perl ConvertLepmapToRqtl.pl /Applications/lepmap2/W288.S1111.makeped.txt /Applications/lepmap3/ws.", targetchr, ".rp /Applications/lepmap3/W288.S1111.SNPsInTheMap.txt"))

#And now, rqtl
fullcross <- NULL;
par(mfrow =c(2,2))
for(i in 1:4){
lepchrin <- read.cross(file = paste0("/Applications/lepmap3/",inputs[i], ".csv"), geno = NULL, crosstype ="4way", estimate.map =F, format = "csv")

#if phase is right, linkage of intercross genetic markers will be high
markerphenotypes <- 1 + which(SNPsInTheMap$JS == targetchr & SNPsInTheMap$F1seg == "AAxBB")
phaseAlods <- NULL;
phaseBlods <- NULL;

#Try phase A
lepchr <- lepchrin
lepchr$geno[[1]]$data[lepchr$geno[[1]]$data == 3] <- 2
lepchr$geno[[1]]$data[lepchr$geno[[1]]$data == 4] <- 3
class(lepchr)[1] <- "f2"
calc.genoprob(lepchr, step = 1) -> lepchr

phaseAlods <- as.numeric(apply(t(markerphenotypes), 2, function(x){if(sum(!is.na(lepchr$pheno[,x])) > 2) {summary(scanone(lepchr, pheno = lepchr$pheno[,x] + rnorm(nind(lepchr),0,.03)))$lod}else{return("NA")}}))
phaseAscore <- mean(phaseAlods, na.rm=T)

#Try phase B
lepchr <- lepchrin
lepchr$geno[[1]]$data[lepchr$geno[[1]]$data == 1] <- 5
lepchr$geno[[1]]$data[lepchr$geno[[1]]$data == 2] <- 1
lepchr$geno[[1]]$data[lepchr$geno[[1]]$data == 4] <- 2
lepchr$geno[[1]]$data[lepchr$geno[[1]]$data == 5] <- 2
class(lepchr)[1] <- "f2"
calc.genoprob(lepchr, step = 1) -> lepchr

phaseBlods <- as.numeric(apply(t(markerphenotypes), 2, function(x){if(sum(!is.na(lepchr$pheno[,x])) > 2) {summary(scanone(lepchr, pheno = lepchr$pheno[,x] + rnorm(nind(lepchr),0,.03)))$lod}else{return("NA")}}))
phaseBscore <- mean(phaseBlods, na.rm=T)

plot(phaseAlods, phaseBlods, main = median(apply(t(markerphenotypes), 2, function(x){sum(!is.na(lepchr$pheno[,x]))})))
abline(0,1)

if(median(apply(t(markerphenotypes), 2, function(x){sum(!is.na(lepchr$pheno[,x]))})) <10){
	stop(paste0("All missing data for this family! i is", i, "and Chr is", targetchr))
	}


if(phaseAscore > phaseBscore){
	lepchr <- lepchrin
	lepchr$geno[[1]]$data[lepchr$geno[[1]]$data == 3] <- 2
	lepchr$geno[[1]]$data[lepchr$geno[[1]]$data == 4] <- 3
	class(lepchr)[1] <- "f2"
	} else if(phaseAscore < phaseBscore){
	lepchr <- lepchrin
	lepchr$geno[[1]]$data[lepchr$geno[[1]]$data == 1] <- 5
	lepchr$geno[[1]]$data[lepchr$geno[[1]]$data == 2] <- 1
	lepchr$geno[[1]]$data[lepchr$geno[[1]]$data == 4] <- 2
	lepchr$geno[[1]]$data[lepchr$geno[[1]]$data == 5] <- 2
	class(lepchr)[1] <- "f2"
	} else if(phaseAlod == phaseBlod){
	stop("the phased lods are equal")
} else {stop("what's the deal with the phaselods?")}


#Take the first intercross marker and declare that the "1" homozygous class carries Bayonne haplotypes. This is a way of getting all the families to have the same allele assignments. 
testgeno <-  paste0("SNP", SNPsInTheMap$SNP.number[markerphenotypes[1]-1])
testmarker <- markerphenotypes[1]
if(cor(lepchr$pheno[,testmarker], lepchr$geno[[1]]$data[,testgeno], use = "pairwise") > 0.5){
	print("Markers are phased")
	}else if(cor(lepchr$pheno[,testmarker], lepchr$geno[[1]]$data[,testgeno], use = "pairwise") < -0.5)
	{
	print("Flipping markers")
	lepchr$geno[[1]]$data[lepchr$geno[[1]]$data == 1 ]  <- 9
	lepchr$geno[[1]]$data[lepchr$geno[[1]]$data == 3 ]  <- 1
	lepchr$geno[[1]]$data[lepchr$geno[[1]]$data == 9 ]  <- 3
	}else {stop ("Why are the markers not correlated?")
		}
assign(paste(inputs[i], "cross", sep = ""), lepchr)
}

#Now combine all the families into one big F2
fullcross <- c(Fam2cross, Fam3cross, Fam4cross, Fam6cross)
fullcross <- replace.map(fullcross, est.map(fullcross))

assign(paste0("lg",targetchr), fullcross)
write.cross(fullcross, format = "csv", filestem = paste0("W288.S1111.rp.fullcross.chr", targetchr))
}

############

#Combine all the chromosomes into one cross object
allrqtl <- lg1
formLinkageGroups(allrqtl, max = 0, min = 0, reorg = T) -> allrqtl
allrqtl <- allrqtl[1:10]

for(z in 1: 10){

jschr <- median(SNPsInTheMap[SNPsInTheMap$SNP.number %in% sapply(strsplit(names(rqtlMap$geno[[z]]$map), "P"), function(x){as.numeric(x[2])}),18])

allrqtl$geno[[z]] <- get(paste0("lg",jschr))$geno[[1]]
	
}

#Rename the chromosomes according to their genetic length

SbMap676 <- allrqtl
SbMap676$geno <- SbMap676$geno[c(as.numeric(names(sort(chrlen(allrqtl), dec = T))))] 
names(SbMap676$geno) <- c(1:10)

SbMap271 <- rqtlMap
SbMap271$geno <- SbMap271$geno[c(as.numeric(names(sort(chrlen(allrqtl), dec = T))))] 
names(SbMap271$geno) <- c(1:10)

write.cross(SbMap676, format = "csv", filestem="SbMap676")
write.cross(SbMap271, format = "csv", filestem="SbMap271")






