% Giovanna Catavitello
% 9/10/2018 
% email g.catavitello@gmail.com

clear
close all
figurehandle = PCA_sin_model_figure6A;

%%
% foldernameSD1 = insert folder path of Source Data 1-Figure 1
foldernameSD1 = cd;
S = what(foldernameSD1);
loadingname = '';
if not(isempty(S.mat))
    cont = 1;
    while cont <= length(S.mat)
        if strfind(S.mat{cont},'data')
            loadingname = S.mat{cont};
            cont = length(S.mat)+1;
        end
        cont = cont + 1;
    end
else
    error('wrong path: select Source Data 1-Figure 1 folder');
end
if isempty(loadingname)
    error('wrong path: select Source Data 1-Figure 1 folder');
else
    
end
cd(foldernameSD1)

load(loadingname,'ELIFEdati');
dati = ELIFEdati;

load('Figure6A.mat','SourceDataFig6')
disp('Figure6A.mat loaded')

markersize = 7;
color2 = dati(1,1).colore.color2;
sbjlabel = dati(1,1).sbjlabel;
nmotion = length(dati.motionlabel);
gambe = dati(1,1).gambe;


sbjdaplot = {'Elefante','Gibbone','Uomo','Macaco','Lince','Orice','Asino','Capybara'};

gp = 60;
lg = 10;
linewidth = 2;
gg = 1;

n = 1;
cont = 1;
while cont <= length(sbjdaplot)
    jj = strcmp(sbjdaplot{cont},dati(1,1).sbjlabel);
    %  il loop lo plotto con gli angoli
    %  medi e la griglia rispetto alla PCA
    %  calcolata sui vettori medi
    figure(figurehandle)
    subplot(3,8,cont+2*8)
    hold on
    
    xxgrid = SourceDataFig6{1,cont+1};
    z3 = SourceDataFig6{2,cont+1};
    X = SourceDataFig6{3,cont+1};
    
    
    plot3(X(:,1),X(:,2),X(:,3),'-','Color',[0,0,0],'LineWidth',linewidth);
    hold on
    set(gca,'FontSize',6);
    box on
    set(surf(xxgrid,xxgrid,z3),'Facecolor','none','edgecolor',[0.6 0.6 0.6],'LineWidth',0.5);
    lighting phong
    azim_view = -40;
    elev_view = 15;
    view(azim_view,elev_view)
    axis([-gp gp -gp gp -gp gp]); axis('square');
    set(gca,'Color','none')
    set(gca,'XTick',[-gp 0 gp],'XTickLabel','')
    set(gca,'YTick',[-gp 0 gp],'YTickLabel','')
    set(gca,'ZTick',[-gp 0 gp],'ZTickLabel','')
    
    Utemp = SourceDataFig6{4,cont+1};
    % per plottare
    % autovettore
    % decommenta
    % queste righe
    markertype = dati.colore.markertype;
    dimspazio = 3;
    for aa = 1:dimspazio
        ctemp = color2(n,:,jj);%colortemp(aa,:); colortemp = lines(dimspazio);
        plot3([0 Utemp(1,aa)*(gp*3/4)],[0 Utemp(2,aa)*(gp*3/4)],[0, Utemp(3,aa)*(gp*3/4)],'Color',ctemp,'LineWidth',3);
        plot3(Utemp(1,aa)*(gp*3/4),Utemp(2,aa)*(gp*3/4),Utemp(3,aa)*(gp*3/4),'Marker',markertype{jj},'MarkerSize',6,...
            'MarkerFaceColor',ctemp,'MarkerEdgeColor',ctemp,'Color',ctemp,'LineWidth',3);
    end
    set(gca,'XTick',[-gp 0 gp],'XTickLabel',{[sprintf('%d',-gp),'°'], '0', [sprintf('%d',gp),'°']})
    set(gca,'YTick',[-gp 0 gp],'YTickLabel',{[sprintf('%d',-gp),'°'], '0', [sprintf('%d',gp),'°']})
    set(gca,'ZTick',[-gp 0 gp],'ZTickLabel',{[sprintf('%d',-gp),'°'], '0', [sprintf('%d',gp),'°']})
    
    cont = cont+ 1;
end
