 function [xxgrid,z3] = faigriglia(gp,lg,U)
% U  il vettore (in caso di matrice prende l'ultima colonna) 
% ortogonale al piano di cui si vuole calcolare la griglia,
% gp  il valore massimo del plot, lg  la larghezza della griglia
l=size(U,2);
if gp<lg
    xxgrid = -gp:(2*gp)/lg:gp;
else
    xxgrid = -gp:round(2*gp/lg):gp;
end
xy_grid = ones(length(xxgrid),1)*xxgrid;
z3 = - (xy_grid*U(1,l)/U(3,l) + xy_grid'*U(2,l)/U(3,l)); % z = -((a/c)x + (b/c)y))
for ii1=1:length(z3)
    for ii2=1:length(z3)
        if abs(z3(ii1,ii2))>gp, z3(ii1,ii2)=gp*sign(z3(ii1,ii2)); end
    end
end