library(phytools)
library(geiger)
library(nlme)
library(readr)
fileName <- 'PhylogeneticTree_completo'
GionnaPhy <- read.newick(fileName)
#plotTree.singletons(GionnaPhy)

GionnaPhy$edge.length
GionnaPhy <- compute.brlen(GionnaPhy,method = "MB")
GionnaPhy$edge.length
#plotTree.singletons(GionnaPhy)
plotTree(GionnaPhy,type="fan",fsize=0.7,lwd=1,
         ftype="i")
nodelabels(cex=0.5)
tiplabels(cex=0.5)

tr <- GionnaPhy

has.singles(tr)
## the following shows that node #4 (ie, the root) is a singleton
## and node #6 is the first bifurcating node
tr$edge
## A bifurcating tree has less nodes than it has tips:
## the following used to fail with ape 4.1 or lower:
plotTree(tr, fsize = 0.9)
tr <- collapse.singles(tr) # only 2 nodes
## give branch lengths to use the 'root.edge' option:
str(collapse.singles(tr, TRUE)) # has a 'root.edge'
tr <- multi2di(tr)

library(readr)

# load data and change it into a vector
namevar = c("HL","FL1","FL2")
s <- 1
filename <- paste("T3new",namevar[s],".csv", sep="")
Tnew <- read_csv(filename)
x<-as.matrix(Tnew$Phyloazim)
x <- as.matrix(x[order(Tnew$Row),1])
rownames(x) <- t(Tnew$Row[order(Tnew$Row)])
x <- as.matrix(x)[,1]

phenogram(tr,x, fsize = 0.9)
# estimate ancestral states
fit <- fastAnc(tr,x,vars=TRUE, CI=TRUE)


#explore the continuous character mapping function
## plot contMap
obj<-contMap(tr,x, fsize = 0.9)

## plot fan style tree
plot(obj,type="fan",lwd=2) ## for example


pdf(file="zoo.contMap.pdf",width=10,height=10, res = 300)
#tiff(ile="zoo.contMap.pdf", width = 10, height = 10, )
plot(obj,type="fan",outline=FALSE)
dev.off()

