% this m file reproduces the ellipses and the stick diagram of figure 1 A
% for both hindlimb and forelimb, depending on the users choise. 
% run the LocomotionCloud.m file in its folder 
% Giovanna Catavitello
% 9/10/2018 
% email g.catavitello@gmail.com

clear
close all
% foldernameSD1 = insert folder path of Source Data 1-Figure 1
foldernameSD1 = cd;
S = what(foldernameSD1);
loadingname = '';
if not(isempty(S.mat))
    cont = 1;
    while cont <= length(S.mat)
        if strfind(S.mat{cont},'data')
            loadingname = S.mat{cont};
            cont = length(S.mat)+1;
        end
        cont = cont + 1;
    end
else
    error('wrong path: select Source Data 1-Figure 1 folder');
end
if isempty(loadingname)
    error('wrong path: select Source Data 1-Figure 1 folder');
else
    
end
cd(foldernameSD1)

load(loadingname,'ELIFEdati');
dati = ELIFEdati;
markersize = 6;
marker = {'^','o'}; % ^ per l'ampiezza, o per la fase
fontsize = 8;
nomiangoli = {'E1', 'E2', 'E3'};
casi = {'from loaded data'; 'randomly';  'as Ui hypothesis'; 'insert manually'};

commenti = cell(1,2);
nn = 1;
motionlabel = dati(1,1).motionlabel(nn);
gambe = dati(1,1).gambe;
commenti{1,1} = 'load data';
commenti{1,2} = dati;

soggetti = {'Elefante'; 'Mandrillo';  'Cammello'; 'Leone';  'Mara'; 'Asino'; 'Avocetta';'Uomo'};
cd(foldernameSD1)
labelgamabscelta = gambe{menu('pick a limb?',gambe)};
SourdataFig1temp = load(['Figure1A', labelgamabscelta,'.mat'],'SourdataFig1');
SourdataFig1 = SourdataFig1temp.SourdataFig1;
disp(['Figure1A', labelgamabscelta,'.mat loaded'])

numerosoggett = length(soggetti);
sbjlabelsel = cell(numerosoggett,1);
sbjlabelSpecies = dati(1,1).colore.OrderLabel(:,6);
ns = 1;
while ns<=numerosoggett
    sbjlabelsel{ns,1} = sbjlabelSpecies{strcmp(soggetti{ns},dati(1,1).colore.OrderLabel(:,1))};
    ns = ns+1;
end
%%
traiettoria = 'horizontal';
tipo.label = traiettoria;
close all
hfigALL = figure('Name','all ellipses'); clf; hold on
for ns = 1:numerosoggett
    hfigcasisingoli = figure('Name',['Fig1 ', sbjlabelsel{ns,1}]); clf; hold on;
    hfigellisse = figure('Name',['ellisse-', sbjlabelsel{ns,1}]); clf; hold on;
    tipodati = 'built';
    Kinem.Length = SourdataFig1{1,ns};
    if ~isempty(Kinem.Length)
        
        L = Kinem.Length.matrice;
        L1 = L(1);
        L2 = L(2);
        L3 = L(3);
        colori = lines(3);
        lunghezzamassima = L1+L2+L3; %  max length
        
        sbjlabel = Kinem.Length.subject;
        n = 1;
        LunghezzePossibili = SourdataFig1{2,ns};
        
        LI = length(LunghezzePossibili);
        %% calcolo
        confspecchio = 'Yes';
        switch confspecchio
            case 'Yes'
                CF = 2;
            case 'No'
                CF = 1;
        end
        angolisimulati = cell(LI,3,CF); % mirror configuration
        puntigamba = cell(LI,CF);
        pesicolori = cell(LI,1);
        nn = 100;
        y = retta([0,0],[0,100],nn);
        x = retta([0,0],[100,0],nn);
        % subplot(3,1,1)
        % hold on
        % plot(real(y),imag(y),'k')
        % hold on
        % plot(real(x),imag(x),':k')
        % axis equal
        np = 40;
        z0 = complex(0,0);
        dl3z0 = cerchio(z0,L3,np);
        % ragioniamo partendo da VM = (0,0)
        dl3z0 = dl3z0(angle(dl3z0)>=-0.000001);
        %plot(real(z0),imag(z0),'ko','MarkerSize',6);
        %plot(real(dl3z0),imag(dl3z0),'Color',colori(3,:),'LineWidth',2);
        
        nSP = 10; % numero di spostamento
        configuraz = cell(LI,1);
        switch Kinem.Length.gambasel
            case 'hindlimb'
                gg = 1;
            case 'forelimb'
                gg = 2;
        end
        for ll = 1:LI
            switch tipo.label
                case 'horizontal'
                    tipo.var.H = LunghezzePossibili(ll); 
                    
            end
            [SPostamentoX, SPostamentoY] = traiettoriaEP(tipo,L1+L2+L3,nSP);
            
            %plot(SPostamento,repmat(H,1,length(SPostamento)),'om','MarkerSize',6)
            if not(isempty(SPostamentoX))
                for t = 1:length(SPostamentoX)
                    H = SPostamentoY(t);
                    z1F = complex(SPostamentoX(t),H);
                    %plot(SPostamento(t),H,'sk','MarkerSize',6)
                    configuraz{ll,t} = trovaConfiguration(z1F,L);
                end 
            end
        end
        
        %% figure
        
        rowsub = 1;
        colsub = 1;%numerosoggett;
        
        s1 = length(LunghezzePossibili);
        s2 = 1;
        s3 = LI;
        gp = 100;
        
        for s = s1:s2:s3
            colorold  = dati(1,1).colore.color2(n,:,strcmp(sbjlabel,dati.sbjlabel));
            coloritemp = calcolacolori([0.3 .3 .3],colorold,size(configuraz,2)*2+2);
            %                     coloritemp = gray(size(configuraz,2)*2+2);
            cont = 2;
            angoli = cell(1);
            for k = 1:size(configuraz,2)
                Ctot = size(configuraz{s,k},1);
                if Ctot ~= 0
                    Cnew = calcolacolori(coloritemp(cont,:),coloritemp(cont+1,:),Ctot);
                    %                         Cnew = calcolacolori([0 0 0],dati(1,1).colore.color2(n,:,strcmp(sbjlabel,dati.sbjlabel)),Ctot);
                    
                    figure(hfigcasisingoli)
                    if not(ishold), hold on; end
                    set(get(gca,'Title'),'String',sprintf([sbjlabel,' dl = %f '],LunghezzePossibili(s)),'FontSize',9)
                    
                    switch gambe{gg}
                        case 'hindlimb'
                            Ctotplot = Ctot;
                        case 'forelimb'
                            Ctotplot = 1;
                    end
                    for t = Ctotplot
                        punti_gamba = configuraz{s,k}(t,1).punti;
                        hold on
                        for kc = 1:size(punti_gamba,1)
                            hold on
                            plot(punti_gamba(kc,:),'Color',Cnew(t,:),'LineWidth',1);
                            if kc == 1
                                plot(real(punti_gamba(kc,1)),imag(punti_gamba(kc,1)),'.','Color',Cnew(t,:),'LineWidth',1);
                            end
                        end
                    end
                    set(gca,'YLim',[0 100])
                    axis equal
                    cont = cont + 2;
                    for t = 1:Ctot
                        angolisimtemp = configuraz{s,k}(t,1).angoli;
                        angoli{1,1} = [angoli{1,1}; angolisimtemp];
                    end
                end
            end
            
            mezziangoli = angoli{1,1};
            for k = 1:size(configuraz,2)
                Ctot = size(configuraz{s,k},1);
                for t = 1:Ctot
                    angoli{1,1} = [angoli{1,1}; configuraz{s,k}(t,2).angoli];
                end
            end
            
            facecolor = dati(1,1).colore.color2(n,:,strcmp(sbjlabel,dati.sbjlabel));
            tuttiangoli = angoli{1,1};
            figure(hfigellisse)
            if not(ishold), hold on; end
            DT_A= delaunayTriangulation(tuttiangoli(:,1),tuttiangoli(:,2),tuttiangoli(:,3));
            [tri, XA]= freeBoundary(DT_A);
            trisurf(tri,XA(:,1),XA(:,2),XA(:,3), 'FaceColor',facecolor.*[.7 .7 .7], 'faceAlpha', 0.2,'EdgeColor','none');
            set(gca,'XLim',[-gp,gp],'YLim',[-gp,gp],'ZLim',[-gp,gp])
            set(gca,'XTickLabel','','YTickLabel','','ZTickLabel','')
            
            axis square
            azim_view = -15;
            elev_view = 20;
            light('Position',[-40 -30 45]);
            lighting gouraud
            view(azim_view,elev_view)
            
            set(plot3([gp -gp],[0 0],[0 0]),'linewidth',1,'color',[0, 0 0]);
            set(plot3([0 0],[gp -gp],[0 0]),'linewidth',1,'color',[0, 0 0]);
            set(plot3([0 0],[0 0],[gp -gp]),'linewidth',1,'color',[0, 0 0]);
            box off
            grid off
            axis off
            
            tuttiangoli = angoli{1,1};
            DT_A = delaunayTriangulation(tuttiangoli(:,1),tuttiangoli(:,2),tuttiangoli(:,3));
            [tri, XA]= freeBoundary(DT_A);
            figure(hfigALL)
            if not(ishold), hold on; end
            trisurf(tri,XA(:,1),XA(:,2),XA(:,3), 'FaceColor',facecolor.*[.7 .7 .7], 'faceAlpha', 0.2,'EdgeColor','none');
            set(gca,'XLim',[-gp,gp],'YLim',[-gp,gp],'ZLim',[-gp,gp])
            set(gca,'XTickLabel','','YTickLabel','','ZTickLabel','')
            
            if ns == 1
                axis square
                azim_view = -15;
                elev_view = 20;
                view(azim_view,elev_view)
                light('Position',[-40 -30 45]);
                lighting phong
                
                set(plot3([gp -gp],[0 0],[0 0]),'linewidth',1,'color',[0, 0 0]);
                set(plot3([0 0],[gp -gp],[0 0]),'linewidth',1,'color',[0, 0 0]);
                set(plot3([0 0],[0 0],[gp -gp]),'linewidth',1,'color',[0, 0 0]);
                box off
                grid off
                axis off
                
                grid off
            end
        end
    end
end
