function y = cerchio(z1,rho,nargin)
%  y = cerchio(z1,rho,n)
% this function returns the point of the disc of radius tho and centre z1

% Giovanna Catavitello
% 9/10/2018 
% email g.catavitello@gmail.com

if not(isempty(nargin))
    n = nargin;
else
    n = 180;
end
theta = -pi:2*pi/n:pi;

if isreal(z1)
    if size(z1,2)== 2
        z1 = complex(z1(1),z1(2));
    elseif size(z1,2)==1
        z1 = complex(z1,0);
    end 
end

y = z1 + rho.*exp(1i*theta);
