% this file reproduces the stick diagram in Figure 1B right panel
% Giovanna Catavitello
% 9/10/2018 
% email g.catavitello@gmail.com


clear
close all
% foldernameSD1 = insert folder path of Source Data 1-Figure 1
foldernameSD1 = cd;
S = what(foldernameSD1);
loadingname = '';
if not(isempty(S.mat))
    cont = 1;
    while cont <= length(S.mat)
        if strfind(S.mat{cont},'dati')
            loadingname = S.mat{cont};
            cont = length(S.mat)+1;
        end
        cont = cont + 1;
    end
else
    error('wrong path: select Source Data 1-Figure 1 folder');
end
if isempty(loadingname)
    error('wrong path: select Source Data 1-Figure 1 folder');
else
    
end
cd(foldernameSD1)

load(loadingname,'dati');

markersize = 6;
marker = {'^','o'}; % ^ per l'ampiezza, o per la fase
fontsize = 8;
nomiangoli = {'uno', 'due', 'tre'};
casi = {'from loaded data'};% 'randomly';  'as Ui hypothesis'; 'insert manually'};

%% data

commenti = cell(1,2);
n = 1;
motionlabel = {'walking'};
gamba = {'hindlimb';'forelimb'};
commenti{1,1} = 'load data';
commenti{1,2} = dati;

sbjlabel = {'Cammello','Fenicottero'};

load([foldernameSD1, '/Figure1BrighthindlimbCamelVShindlimbFlamingo.mat'],'SourdataFig1B')
disp([foldernameSD1, '/Figure1BrighthindlimbCamelVShindlimbFlamingo.mat loaded'])


Kinem = SourdataFig1B{1,1};

HF = figure('Name','KinematicModel original vs built');

colori = [0 0 1; .8 0 0];
scrnsz = get(0,'ScreenSize');
% set(HF,'Position',[scrnsz(1),scrnsz(2), scrnsz(3)-100, scrnsz(4)-100]);

h = zeros(2,1);
for k = 1:2
    h(k) = subplot(1,2,k);
end

subplot(h(1));
hold on
set(get(gca,'Title'),'String','Camel HL','FontSize',fontsize)

subplot(h(2));
hold on
set(get(gca,'Title'),'String','Camel HL Flamingo HL','FontSize',fontsize)


%for k = 1:2
k = 1;

NEWkinem = SourdataFig1B{2,1};
X = NEWkinem.AngoliRicostruiti.X;
L = Kinem(1,k).Length.matrice;
P = complex(zeros(size(X,1),size(X,2)+1));

ReEP = SourdataFig1B{3,1};

P(:,1) = complex(nanmean(detrend(ReEP(1,1).X,0),2),nanmean(detrend(ReEP(1,1).Y,0),2));
for z = 1:3
    P(:,z+1) = sum([P(:,z),complex(L(z)*sin(X(:,z)*(pi/180)),-L(z)*cos(X(:,z)*(pi/180)))],2);
end

    
numstickdiag = 10;
% stick diagram
coloristick = repmat(colori(k,:),(length(1:numstickdiag:101)),1);
subplot(h(1));
hold on
cont = 1;
for t = 1:numstickdiag:101
    plot(P(t,:),'Color',coloristick(cont,:));
    cont = cont + 1;
end
%     coloript = flipud(gray(5));
%     coloript = coloript(2:end,:);
coloript = repmat(colori(k,:),size(P,2),1);
for p = [1, size(P,2)]
    if not(ishold), hold on; end
    plot(real(P(:,p)) ,imag(P(:,p)),'Color',coloript(p,:));
end
axis equal
xlinea = get(gca,'XLim');
xlinea = [xlinea(1)-.3, xlinea(2)+.3];
ylineaEP = [min(imag(P(:,end))) min(imag(P(:,end)))];
ylineaROOT = [nanmean(nanmean(detrend(ReEP(1,1).X,0),2)) nanmean(nanmean(detrend(ReEP(1,1).X,0),2))];
plot(xlinea,ylineaEP,'Color',[.35 0 0])
plot(xlinea,ylineaROOT,'Color',[0 .6 .8])
axis off

k = 2;
NEWkinem = SourdataFig1B{4,1};
X = NEWkinem.AngoliRicostruiti.X;
jjaltro = find(~strcmp(sbjlabel{1,k},sbjlabel));
if isempty(jjaltro)
    jjaltro = 1:2;
    jjaltro = jjaltro(k~=jjaltro);
end
L = Kinem(1,jjaltro).Length.matrice;
    
ReEP = SourdataFig1B{5,1};
 

    
% EP di primo sogg
P = complex(zeros(size(X,1),size(X,2)+1));
MMM = ylineaEP(1) - (nanmin(nanmean(detrend(ReEP(1,2).Y,0),2))) - nanmean(nanmean(detrend(ReEP(1,2).Y,0),2));
P(:,4) = complex(nanmean(detrend(ReEP(1,2).X,0),2)+MMM,nanmean(detrend(ReEP(1,2).Y,0),2)+MMM);
for z = 3:-1:1
    P(:,z) = sum([P(:,z+1),complex(-L(z)*sin(X(:,z)*(pi/180)),+L(z)*cos(X(:,z)*(pi/180)))],2); %L(z).*exp(1j*(X(:,z)./(pi/180))).*exp(pi/2)],2);
end
Paltragamba = [(P(round(size(P,1)/2):end,:) - complex(real(P(round(size(P,1)/2),1))-real(P(1,1)),0)); (P(1:round(size(P,1)/2)-1,:) + complex(real(P(end,1))-real(P(round(size(P,1)/2),1)),0))];


numstickdiag = 10;
% stick diagram
coloristick = repmat(colori(k,:),(length(1:numstickdiag:101)),1);
subplot(h(2));
%set(get(gca,'Title'),'String',[NEWkinem.AngoliRicostruiti.label{:},'A', Kinem(1,jjaltro).Length.subject,'L'] ,'FontSize',fontsize)
hold on
cont = 1;
for t = 1:numstickdiag:101
    plot(P(t,:),'Color',coloristick(cont,:));
    plot(Paltragamba(t,:),'Color',[.5 .5 .5]);
    cont = cont + 1;
end
%     coloript = flipud(gray(5));
%     coloript = coloript(2:end,:);
coloript = repmat(colori(k,:),size(P,2),1);
for p = [1, size(P,2)]
    if not(ishold), hold on; end
    plot(real(P(:,p)) ,imag(P(:,p)),'Color',coloript(p,:));
    plot(real(Paltragamba(:,p)) ,imag(Paltragamba(:,p)),'Color',[.5 .5 .5]);
end
axis equal
xlinea = get(gca,'XLim');
xlinea = [xlinea(1)-.3, xlinea(2)+.3];

plot(xlinea,ylineaEP,'Color',[.35 0 0])
plot(xlinea,ylineaROOT,'Color',[0 .6 .8])
axis off


