% this function plot the stick diagram as they are in Figure 1 B left panel
% Giovanna Catavitello
% 10/10/2018 
% email g.catavitello@gmail.com

clear
close all
% foldernameSD1 = insert folder path of Source Data 1-Figure 1
foldernameSD1 = cd;
S = what(foldernameSD1);
loadingname = '';
if not(isempty(S.mat))
    cont = 1;
    while cont <= length(S.mat)
        if strfind(S.mat{cont},'dati')
            loadingname = S.mat{cont};
            cont = length(S.mat)+1;
        end
        cont = cont + 1;
    end
else
    error('wrong path: select Source Data 1-Figure 1 folder');
end
if isempty(loadingname)
    error('wrong path: select Source Data 1-Figure 1 folder');
else
    
end
cd(foldernameSD1)


marker = {'^','o'}; % ^ per l'ampiezza, o per la fase
fontsize = 8;
nomiangoli = {'one', 'two', 'three'};
casi = 'from loaded data';

load([foldernameSD1, '/Figure1BlefthindlimbVSforelimbCheetah.mat'],'SourdataFig1B')
disp('Figure1BlefthindlimbVSforelimbCheetah.mat loaded')

%% data

commenti = cell(1,2);
load('/Users/gionna/Desktop/Work/Matlab/zoo/statistica per Results/datipronti.mat','dati')
switch dati(1,1).project
    case 'zoo'
        n = 1;
    otherwise
        n = menu('choose motion',length(dati(1,1).motionlabel));
end
motionlabel = dati(1,1).motionlabel(n);
gamba = dati(1,1).gambe;
commenti{1,1} = 'load data';
commenti{1,2} = dati;

soggetti = {'Ghepardo'};

solitiangoli = 'soliti'; % se vuoi fare thigh,shank foot o shank foot toes
%soggetti = {'Uomo'; 'Elefante'; 'Gatto'; 'Leone'; 'Mandrillo'; 'Cammello';  'Mara'; 'Asino'; 'Avocetta'};
for ns = 1:length(soggetti)
    
    Kinem = SourdataFig1B{1,ns};
    
    HF = figure('Name',['KinematicModel hindlimb vs forelimb', soggetti{ns}]);
    colori = [0 0 1; .8 0 0];
    scrnsz = get(0,'ScreenSize');
    % set(HF,'Position',[scrnsz(1),scrnsz(2), scrnsz(3)-100, scrnsz(4)-100]);
    h = zeros(2,1);
    for k = 1:2
        h(k) = subplot(1,2,k);
    end
    
    
    tipodati = 'built';
    for k = length(gamba)
        
        subplot(h(1));
        hold on
        set(get(gca,'Title'),'String',gamba{k},'FontSize',fontsize)
        
        k2 = 1:length(gamba);
        k2 = k2(k~=k2);
        
        NEWkinem = SourdataFig1B{2,ns};
        
        X = NEWkinem.AngoliRicostruiti.X;
        
        L = Kinem(1,k).Length.matrice/100;
        P = complex(zeros(size(X,1),size(X,2)+1));        
        
        ReEP = SourdataFig1B{3,ns};
        
        P(:,1) = complex(nanmean(detrend(ReEP(1,1).X,0),2),nanmean(detrend(ReEP(1,1).Y,0),2));
        for z = 1:3
            P(:,z+1) = sum([P(:,z),complex(L(z)*sin(X(:,z)*(pi/180)),-L(z)*cos(X(:,z)*(pi/180)))],2); %L(z).*exp(1j*(X(:,z)./(pi/180))).*exp(pi/2)],2);
        end
        
        numstickdiag = 10;
        % stick diagram
        coloristick = repmat(colori(k,:),(length(1:numstickdiag:101)),1);
        subplot(h(1));
        set(get(gca,'Title'),'String',gamba{k} ,'FontSize',fontsize)
        hold on
        cont = 1;
        for t = 1:numstickdiag:101
            plot(P(t,:),'Color',coloristick(cont,:));
            cont = cont + 1;
        end
        %     coloript = flipud(gray(5));
        %     coloript = coloript(2:end,:);
        coloript = repmat(colori(k,:),size(P,2),1);
        for p = [1, size(P,2)]
            if not(ishold), hold on; end
            plot(real(P(:,p)) ,imag(P(:,p)),'Color',coloript(p,:));
        end
        axis equal
        xlinea = get(gca,'XLim');
        xlinea = [xlinea(1)-.3, xlinea(2)+.3];
        ylineaEP = [min(imag(P(:,end))) min(imag(P(:,end)))];
        ylineaROOT = [nanmean(nanmean(detrend(ReEP(1,1).X,0),2)) nanmean(nanmean(detrend(ReEP(1,1).X,0),2))];
        plot(xlinea,ylineaEP,'Color',[.35 0 0])
        plot(xlinea,ylineaROOT,'Color',[0 .6 .8])
        axis off
        
        
        NEWkinem = SourdataFig1B{4,ns};
        
        nomiangoli = cell(3,1);
        for a = 1:length(nomiangoli)
            nomiangoli{a} = [Kinem(1,k).Amplitude.info.label{a} , '-',Kinem(1,k2).Amplitude.info.label{a} ];
        end
        X = NEWkinem.AngoliRicostruiti.X;
        
        L = Kinem(1,k).Length.matrice/100;
        
        ReEP = SourdataFig1B{5,ns};
        
        % EP di primo sogg
        P = complex(zeros(size(X,1),size(X,2)+1));
        MMM = ylineaEP(1) - (nanmin(nanmean(detrend(ReEP(1,2).Y,0),2))) - nanmean(nanmean(detrend(ReEP(1,2).Y,0),2));
        P(:,4) = complex(nanmean(detrend(ReEP(1,2).X,0),2)+MMM,nanmean(detrend(ReEP(1,2).Y,0),2)+MMM);
        for z = 3:-1:1
            P(:,z) = sum([P(:,z+1),complex(-L(z)*sin(X(:,z)*(pi/180)),+L(z)*cos(X(:,z)*(pi/180)))],2); %L(z).*exp(1j*(X(:,z)./(pi/180))).*exp(pi/2)],2);
        end
        Paltragamba = [(P(round(size(P,1)/2):end,:) - complex(real(P(round(size(P,1)/2),1))-real(P(1,1)),0)); (P(1:round(size(P,1)/2)-1,:) + complex(real(P(end,1))-real(P(round(size(P,1)/2),1)),0))];
        
        
        numstickdiag = 10;
        % stick diagram
        coloristick = repmat(colori(k,:),(length(1:numstickdiag:101)),1);
        subplot(h(2));
        set(get(gca,'Title'),'String',[gamba{k},'-',gamba{k2}] ,'FontSize',fontsize)
        hold on
        cont = 1;
        for t = 1:numstickdiag:101
            plot(P(t,:),'Color',coloristick(cont,:));
            plot(Paltragamba(t,:),'Color',[.5 .5 .5]);
            cont = cont + 1;
        end
        %     coloript = flipud(gray(5));
        %     coloript = coloript(2:end,:);
        coloript = repmat(colori(k,:),size(P,2),1);
        for p = [1, size(P,2)]
            if not(ishold), hold on; end
            plot(real(P(:,p)) ,imag(P(:,p)),'Color',coloript(p,:));
            plot(real(Paltragamba(:,p)) ,imag(Paltragamba(:,p)),'Color',[.5 .5 .5]);
        end
        axis equal
        xlinea = get(gca,'XLim');
        xlinea = [xlinea(1)-.3, xlinea(2)+.3];
        
        plot(xlinea,ylineaEP,'Color',[.35 0 0])
        plot(xlinea,ylineaROOT,'Color',[0 .6 .8])
        axis off
        
    end
end