function [th11,th12] = trovaTheta1eTheta2(dl,L1,L2)
% returns th1 and th2 such that the two segment of length L1 and L2 are
% dl = L1*sin(th1)+L2*sin(th2); e L1*cos(th1)=L2*cos(th2)
% this function is called in trovaConfiguration.m file

% Giovanna Catavitello
% 9/10/2018 
% email g.catavitello@gmail.com


if dl > L1+L2 || L2 == 0 || dl == 0
    error('invalid input parameters')
end

[th11,th12] = risolvi(dl,L1,L2);



%th1 = asin((dl^2 + L2^2 - L1^2)/(2*dl*L2));
%th2 = asin((dl - L1*sin(th1))/(L2));

end 

function [th11,th12] = risolvi(dl,l1,l2)

th11 = 2*atan((2*dl*l1 - 2*dl*l2 + (dl^2*(2*dl*l2 -...
    ((dl + l1 + l2)*(dl + l1 - l2)*(dl - l1 + ...
    l2)*(l1 - dl + l2))^(1/2)))/(dl^2 - l1^2 + l2^2) -...
    (l1^2*(2*dl*l2 - ((dl + l1 + l2)*(dl + l1 - l2)*(dl -...
    l1 + l2)*(l1 - dl + l2))^(1/2)))/(dl^2 - l1^2 + l2^2) + ...
    (l2^2*(2*dl*l2 - ((dl + l1 + l2)*(dl + l1 - l2)*(dl - l1 + l2)*(l1 - dl +...
    l2))^(1/2)))/(dl^2 - l1^2 + l2^2))/(dl^2 + l1^2 - l2^2));

th12 = 2*atan((2*dl*l1 - 2*dl*l2 + (dl^2*(2*dl*l2 +...
    ((dl + l1 + l2)*(dl + l1 - l2)*(dl - l1 + l2)*(l1 -...
    dl + l2))^(1/2)))/(dl^2 - l1^2 + l2^2) - (l1^2*(2*dl*l2 +...
    ((dl + l1 + l2)*(dl + l1 - l2)*(dl - l1 + l2)*(l1 - dl +...
    l2))^(1/2)))/(dl^2 - l1^2 + l2^2) + (l2^2*(2*dl*l2 + ((dl ...
    + l1 + l2)*(dl + l1 - l2)*(dl - l1 + l2)*(l1 - dl + ...
    l2))^(1/2)))/(dl^2 - l1^2 + l2^2))/(dl^2 + l1^2 - l2^2));

end
