function Cnew = calcolacolori(C1,C2,n)
% computes the new color matrix of n color between C1 and C2. C1 and C2 are
% in hsv format
% Giovanna Catavitello
% 10/10/2018 
% email g.catavitello@gmail.com


Cnew = zeros(n,3,size(C1,1));
for cc = 1:size(C1,1)
    for k = 1:3
        if C1(cc,k) > C2(cc,k)
            Cnew(:,k,cc) = C2(cc,k):(C1(cc,k)-C2(cc,k))/(n-1):C1(cc,k);
        elseif C1(cc,k) < C2(cc,k)
            Cnew(:,k,cc) = fliplr(C1(cc,k):(C2(cc,k)-C1(cc,k))/(n-1):C2(cc,k));
        else
            Cnew(:,k,cc) = C1(cc,k);
        end
    end
end
end