function theta = calcolo_angles(varargin)
% th = calcolo_angles(p1,p2,p3)
% calcolo angolo p3-p2-p1 dati in input tre punti, centro in p2, calcolo
% angolo alpha di segmento p2-p3, ruoto di -alpha tutto e prendo angolo che
% viene
% nowrap = 's' di default per fare unwrap dell'angolo
% nowrap = 'no' restituisce l'angolo senza unwrap
% Giovanna Catavitello
% 9/10/2018 
% email g.catavitello@gmail.com


p1 = varargin{1};
p2 = varargin{2};
p3 = varargin{3};
if length(varargin) > 3
    nowrap = varargin{4};
else
    nowrap = 's';
end

if isreal(p1)&&isreal(p2)&&isreal(p3)
    
    dimpt = size(p1,1);
%     
%     f1 = zeros(dimpt,2);
%     f2 = zeros(dimpt,2);
%     f3 = zeros(dimpt,2);
%     
%     x2 = zeros(dimpt,1);
%     y2 = zeros(dimpt,1);
    
    x2 = p2(:,1);
    y2 = p2(:,2);
    % traslazione
    f1 = [p1(:,1)- x2, p1(:,2) - y2];
    f2 = [p2(:,1)- x2, p2(:,2) - y2];
    f3 = [p3(:,1)- x2, p3(:,2) - y2];
    
    z1 = complex(f1(:,1),f1(:,2));
    z2 = complex(f2(:,1),f2(:,2));
    z3 = complex(f3(:,1),f3(:,2));

else
    % traslazione
    z1 = p1-p2;
    z2 = p2-p2;
    z3 = p3-p2;
end


alpha = angle(z3); %./(pi/180);% per avere l'angolo in gradi
% rotazione


g1 = z1.*exp(1j.*(-alpha));
g2 = z2.*exp(1j.*(-alpha));
g3 = z3.*exp(1j.*(-alpha));

switch nowrap
    case 's'
        theta = unwrap(angle(g1),[],1)./(pi/180);
    case 'no'
        theta = angle(g1)./(pi/180);
end
