function p = intersezionerettadisco(p1,p2,p3,epsilon)
% this function computes intersection points between the 2d ball with
% centre p3 and radius epsilon, and the rect line that passes on p1 and p2.
% If no intersection the function returns NaN values.
% p1 = [x1, y1]; p2 = [x2, y2]; p3 = [x3, y3];

% Giovanna Catavitello
% 9/10/2018 
% email g.catavitello@gmail.com

if not(isreal(p1))
    x1 = real(p1);
    y1 = imag(p1);
    x2 = real(p2);
    y2 = imag(p2);
    x3 = real(p3);
    y3 = imag(p3);
else
    x1 = p1(1);
    y1 = p1(2);
    x2 = p2(1);
    y2 = p2(2);
    x3 = p3(1);
    y3 = p3(2);
end

a = y2 - y1;
b = x2 - x1;
c = x3 - x1;
d = y1 - y3;

if b ~= 0
    m = a/b;
    
    alpha = 1 + m^2;
    beta = c*m^2 + m*d - x3;
    gamma = x3^2 + (c*m)^2 + d^2 + 2*(a*d*c)/b - epsilon^2;
    
    delta = beta^2 - alpha*gamma;
    y = @(x) ((x + c)*m + d + y3);
    
    if delta < 0
        p = NaN;
    elseif delta == 0
        p = [-beta/alpha  y(-beta/alpha)];
    else
        xsol1 = (-beta + sqrt(delta))/alpha;
        xsol2 = (-beta - sqrt(delta))/alpha;
        ysol1 = y(xsol1);
        ysol2 = y(xsol2);
        p = [xsol1, ysol1; xsol2, ysol2];
    end
else
    % se la retta è verticale
    del = x3-x1; % distanza del cerchio dalla retta verticale
    if abs(del) > epsilon
        p = NaN;
    else
        %         c = x3-x1;
        %         d = y3-y1;
        %         if c == 0
        %             p = epsilon*cos(c)
        %         th = atan(d/c)
        %         b2 = acos(del/epsilon);
        %         if abs(b2) == pi || abs(b2) == 0
        %             p = [del, epsilon*sin(b2)];
        %         else
        %             p = [x1, epsilon*sin(b2) + y3; x1, epsilon*(sin(-b2)) + y3];
        %         end
        %     end
        if x3 == x1
            p = [x3+epsilon*cos(pi/2), y3 + epsilon*sin(pi/2); ...
                x3+epsilon*cos(3*pi/2), y3 + epsilon*sin(3*pi/2)];
        else
            if y3 == y1 && x3 == epsilon
                p = [x3 + epsilon(cos(pi)), y3 + epsilon*sin(pi)];
            elseif y3 == y1 && x3 == -epsilon
                p = [x3 + epsilon(cos(0)), y3 + epsilon*sin(0)];
            else
                if x3>x1
                    th = acos((x3-x1)/epsilon);
                    p = [x3 + epsilon*cos(pi-th), y3 + epsilon*sin(pi-th); ...
                        x3 + epsilon*cos(pi+th), y3 + epsilon*sin(pi+th)];
                else
                    th = acos((x1-x3)/epsilon);
                    p = [x3 + epsilon*cos(th), y3 + epsilon*sin(th); ...
                        x3 + epsilon*cos(-th), y3 + epsilon*sin(-th)];
                end
                    
            end
        end
    end
end
    

return
    