function y = retta(z1,z2,n)
% restituisce n punti della retta passante per z1 e z2 in R^2
% Giovanna Catavitello
% 9/10/2018 
% email g.catavitello@gmail.com

if isreal(z1)
    z1 = complex(z1(1),z1(2));
    z2 = complex(z2(1),z2(2));
end

% d = sqrt((real(z1)-real(z2))^2 + (imag(z1)-imag(z2))^2); se voglio la
% retta dal primo punto al secondo senza averla tutta per intero
rho = -n:1:n;

y = rho.*exp(1i*angle(z2-z1)) + z1;