function [SpostamentoX, SpostamentoY] = traiettoriaEP(tipo,L,nSP)
% tipo.label(1) = 'horizontal'
%
% when the trajectory of the z3 segment is horizontal, this function take
% sin input L = L1+L2+L3, nSP is the total number of point in the
% trajectory for which we are computing the configuration. 
% The tipo struct as the following field: 
%       tipo.label - in this case is horizontal, I've also the code for vertical
%                   and curved trajectory but it is not for this figure. The reader interested
%                   can contact me. 
%       tipo.var.H - the horizontal limb displacement

% Giovanna Catavitello
% 9/10/2018 
% email g.catavitello@gmail.com



switch tipo.label
    case 'horizontal'
        H = tipo.var.H;
        
        p1 = [-100 H];
        p2 = [100, H];
        p3 = [0, 0];
        
        p = intersezionerettadisco(p1,p2,p3,L);
        SpostamentoX = min(p(:,1)):(max(p(:,1))-min(p(:,1)))/(nSP-1):max(p(:,1));
        SpostamentoY = repmat(H,1,nSP);
            
end