function varargout = trovaConfiguration(varargin)
% configuraz = trovaConfiguration(z1,L)
% starting from the centre z0 = (0,0), this function computes all the
% possible combination of a three segmented limb L = [L1,L2,L3] 
% between z0 = (0,0) and z1

% Giovanna Catavitello
% 9/10/2018 
% email g.catavitello@gmail.com

configuraz = struct('label',{},'punti',[],'angoli',[]);
% trova configurazione centrata in z0 = (0,0)
if not(isempty(varargin{2}))
    L = varargin{2};
    L1 = L(1);%Ltot/3;
    L2 = L(2);%Ltot/3;
    L3 = L(3);%Ltot/3;
else
    Ltot = 100;
    L1 = Ltot/3;
    L2 = Ltot/3;
    L3 = Ltot/3;
end
z0 = complex(0,0);
z1F = varargin{1};
np = 100;
dl3z0 = cerchio(z0,L3,np);
% ragioniamo partendo da VM = (0,0)
dl3z0 = dl3z0(angle(dl3z0)>=-0.000001);
%     dlprimo = dlprimo(Ind_dlprimo);
l = abs(z1F-z0);
z1 = l*exp(1j*pi/2); 
dlprimo = sqrt((real(dl3z0)-real(z1)).^2 + (imag(dl3z0)-imag(z1)).^2);
Ind_dlprimo = find(dlprimo <= L1+L2); % per quali elementi del cerchio la distanza è valida


ppp1 = complex(0,imag(z1F));
ppp2 = z0;
angoloz1F = calcolo_angles(ppp1,ppp2,z1F)*(pi/180);
if not(isempty(Ind_dlprimo))
    for d = 1:length(Ind_dlprimo)
        
        [th11,th12] = trovaTheta1eTheta2(dlprimo(Ind_dlprimo(d)),L1,L2);
        
        th1 = th11;
        
        z3 = dl3z0(Ind_dlprimo(d));
        
        ppp1 = z3;
        ppp2 = z1;
        ppp3 = complex(real(z1),imag(z1)-40);
        ALpha = calcolo_angles(ppp1,ppp2,ppp3)*(pi/180);
        
        % configurazione 1
        z2 = L2*exp(1j*th1)*exp(1j*(ALpha)) + z3;
        
        %plot(real(z1),imag(z1),'s','MarkerSize',6)
        % hold on
        %plot(real(z2),imag(z2),'s','MarkerSize',6)
        %plot(real(z3),imag(z3),'s','MarkerSize',6)
        
        z1F = (z1-z0)*exp(1j*(-angoloz1F));
        z2F = (z2-z0)*exp(1j*(-angoloz1F));
        z3F = (z3-z0)*exp(1j*(-angoloz1F));
        
        %plot(real(z1F),imag(z1F),'s','MarkerSize',6)
        % hold on
        %plot(real(z2F),imag(z2F),'s','MarkerSize',6)
        %plot(real(z3F),imag(z3F),'s','MarkerSize',6)
        
        punti_gamba = [z1F, z2F; z2F, z3F; z3F, z0];
        %         configuraz(1,1).label = {'z1', 'z2'; 'z2', 'z3'; 'z3','z0'};
        configuraz(d,1).label = {'primo'; {'z1', 'z2'; 'z2', 'z3'; 'z3','z0'}};
        configuraz(d,1).punti = punti_gamba;
        configuraz(d,1).angoli = zeros(1,3);
        Z = [z1F; z2F; z3F; z0];
        for k = 2:length(Z)
            ppp1 = Z(k);
            ppp2 = Z(k-1);
            ppp3 = complex(real(Z(k-1)),imag(Z(k-1))-40);
            ZA = calcolo_angles(ppp1,ppp2,ppp3);
            configuraz(d,1).angoli(1,k-1) = ZA;
        end
        
        
        % configurazione a specchio
        th1 = th12;
        
        z2 = L2*exp(1j*th1)*exp(1j*(ALpha)) + z3;
        
        z1F = (z1-z0)*exp(1j*(angoloz1F));
        z2F = (z2-z0)*exp(1j*(angoloz1F));
        z3F = (z3-z0)*exp(1j*(angoloz1F));
        
        
        punti_gamba = [z1F, z2F; z2F, z3F; z3F, z0];
        configuraz(d,2).label = {'specchio'; {'z1', 'z2'; 'z2', 'z3'; 'z3','z0'}};
        configuraz(d,2).punti = punti_gamba;
        configuraz(d,2).angoli = zeros(1,3);
        Z = [z1F; z2F; z3F; z0];
        for k = 2:length(Z)
            ppp1 = Z(k);
            ppp2 = Z(k-1);
            ppp3 = complex(real(Z(k-1)),imag(Z(k-1))-40);
            ZA = calcolo_angles(ppp1,ppp2,ppp3);
            configuraz(d,2).angoli(1,k-1) = ZA;
        end
    end
end

varargout{1} = configuraz;
