% Giovanna Catavitello
% 9/10/2018 
% email g.catavitello@gmail.com

clear
close all

marker = {'^','o'}; % ^ per l'ampiezza, o per la fase
fontsize = 8;
nomiangoli = {'uno', 'due', 'tre'};
tipodati = 'built';
casi = 'as Ui hypothesis';

%% data
% foldernameSD1 = insert folder path of Source Data 1-Figure 1
foldernameSD1 = cd;
S = what(foldernameSD1);
loadingname = '';
if not(isempty(S.mat))
    cont = 1;
    while cont <= length(S.mat)
        if strfind(S.mat{cont},'data')
            loadingname = S.mat{cont};
            cont = length(S.mat)+1;
        end
        cont = cont + 1;
    end
else
    error('wrong path: select Source Data 1-Figure 1 folder');
end
if isempty(loadingname)
    error('wrong path: select Source Data 1-Figure 1 folder');
else
    
end
cd(foldernameSD1)

load(loadingname,'ELIFEdati');
dati = ELIFEdati;

load([foldernameSD1, '/Figure6C.mat'],'SourceDataFig6C')
disp([foldernameSD1, '/Figure6C.mat loaded'])

commenti = cell(1,2);
n = 1;
motionlabel = dati(1,1).motionlabel(n);
gamba = {'hindlimb';'forelimb'};
commenti{1,1} = 'load data';
commenti{1,2} = dati;

solitiangoli = 'soliti'; % se vuoi fare thigh,shank foot o shank foot toes
soggetti = {'Gibbone','Lince','Capybara'};

g = 1;
gambasel = gamba{g};
gp = 60;
HFT = figure('Name',['traiettorie', gambasel]);
hft = zeros(length(soggetti),1);

for k = 1:2
    for ns = 1:length(soggetti)
        
        sbjlabel = soggetti{ns};
        hft(k,ns) = subplot(2,length(soggetti),ns+length(soggetti)*(k-1));
        if k == 1
            set(get(gca,'Title'),'String',[sbjlabel, sprintf(' U_%d',k)],'FontSize',fontsize)
        else
            set(get(gca,'Title'),'String',sprintf(' U_%d',k),'FontSize',fontsize)
        end
    end
end
scont = 1;
for k = 1:2
    for ns = 1:length(soggetti)
        sbjlabel = soggetti{ns};
        
        colori = [0 0 1; .8 0 0; 0 1 0];
        % scrnsz = get(0,'ScreenSize');
        % set(HF,'Position',[scrnsz(1),scrnsz(2), scrnsz(3)-100, scrnsz(4)-100]);
        
        Kinem = SourceDataFig6C{1,scont};
        scont = scont + 1;
        X = SourceDataFig6C{1,scont};
        scont = scont + 1;
        
        nomiangoli = Kinem(1,1).Amplitude.info.label;
        L = Kinem(1,1).Length.matrice;
        P = complex(zeros(size(X,1),size(X,2)+1));
        % for z = 1:3
        %     P(:,z) = complex(L(z)*sin(X(:,z)),-L(z)*cos(X(:,z)));
        % end
        for z = 1:3
            P(:,z+1) = sum([P(:,z),complex(L(z)*sin(X(:,z)*(pi/180)),-L(z)*cos(X(:,z)*(pi/180)))],2); %L(z).*exp(1j*(X(:,z)./(pi/180))).*exp(pi/2)],2);
        end
        
        figure(HFT)
        get(hft(k,ns));
        if not(ishold),hold on; end
        
            
        numstickdiag = 10;
        % stick diagram
        coloristick = repmat(colori(k,:),(length(1:numstickdiag:101)),1);
        subplot(hft(k,ns));
        hold on
        cont = 1;
        for t = 1:numstickdiag:101
            plot(P(t,:),'Color',coloristick(cont,:));
            cont = cont + 1;
        end
        coloript = repmat([0 0 0],size(P,2),1);
        for p = size(P,2)
            if not(ishold), hold on; end
            plot(real(P(:,p)) ,imag(P(:,p)),'Color',coloript(p,:));
            %plot(real(P(end,p)),imag(P(end,p)),'>','Color','m');
        end
        axis equal
        set(gca,'XLim',[-gp,gp],'xtick',[-gp,0,gp],'YLim',[-100,0],'ytick',[-100,0])
        axis square
        set(gca,'Color','none')
    end
end