function figurehandle = PCA_sin_model_figure6A
% Yury Ivanenko
% 9/10/2018 
% PCA modelfor 3 sinusoidal elevation angles

close all;

numpun=200;
t=(0:numpun-1)/numpun; 


figurehandle = figure; 
hold on; clf;

for ii=1:8
    ph1=30/(180/pi);  % phase (in radians) of the first (thigh) elevation angle sin wafeform
    ph2=70/(180/pi);
    ph3=(80+(ii-7)*10)/(180/pi);
    a1=0.7;   % amplitude of the first (thigh) elevation angle sin wafeform
    a2=1;
    a3=1;
    
    thigh=a1*cos(2*pi*t-ph1);
    shank=a2*cos(2*pi*t-ph2);
    foot =a3*cos(2*pi*t-ph3);
    
    array=[thigh',shank',foot']';
    Delta = (ph3-ph2)*(180/pi);
    
    % PCA
    pc(figurehandle, array*50,1,9-ii,Delta);
    % pause
end



function pc(figurehandle,array,covorcorr,ij,Delta)
x = detrend(array',0)';
npc = min(size(x)); 

%---------------singular value decomposition-----------
if covorcorr == 1
    [u,lam,~] = svd(cov(x'));
else
    [u,lam,~] = svd(corrcoef(x')); 
end
eig_val = zeros(1, npc);
for i = 1:npc
    eig_val(i) = lam(i,i)./sum(sum(lam))*100;
end
%--------------------------------------------------

figure(figurehandle); %clf;
colors='kgbmcryb';
for i=1:npc
    subplot(3,8,ij);  hold on;
    title(sprintf('delta=%2.0f°',Delta),'Fontsize', 10)
    plot(x(i,:),'color',colors(i));
    axis off
end
if ij == 1
    legend({'thigh','shank','foot'});
end
%title(ccc);

handlesub = subplot(3,8,ij+8);  hold on;
hold on;
gp = 70;   % scale (cube) and grid limits
lg = 10;
[xxgrid,z3] = faigriglia(gp,lg,u(:,3));
set(surf(xxgrid,xxgrid,z3),'Facecolor','none','edgecolor',[0.6 0.6 0.6],'LineWidth',0.5);
lighting phong
plot3(x(1,:),x(2,:),x(3,:),'Color','black','LineWidth',2)

azim_view = -40;
elev_view = 15;
view(azim_view ,elev_view)


axis([-gp gp -gp gp -gp gp]); axis('square');
set(gca,'Color','none')
box on
set(handlesub,'Box','on');
%   xlabel('thigh'); ylabel('shank'); zlabel('foot'); 
set(handlesub,'xtick',[-gp,0,gp],'xticklabel',''); set(handlesub,'ytick',[-gp,0,gp],'yticklabel',''); set(handlesub,'ztick',[-gp,0,gp],'zticklabel','');
for i = 1:3
    % plot3([0 u(1,i)*60],[0 u(2,i)*60],[0 u(3,i)*60],'r')
end

return; 

