% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <https://www.gnu.org/licenses/>.

function [all_cell_data]  = tfm_process
%% Specify the images to be analyzed
main = cd;


%%% Use this to select files
%  [bf_cell_prefix,path] = uigetfile('*.*','Select the bright field image','MultiSelect','on');
%  cd(path);
%  [fluor_bef_prefix,~] = uigetfile('*.*','Select the before image');
%  [fluor_aft_prefix,~] = uigetfile('*.*','Select the after image');

%cd('E:\lab_members\ian\TFM Data\2017_5_01\')
[cell_prefix,path] = uigetfile('*.*','Select the bright field image','MultiSelect','on');

bf_cell_file= [path, cell_prefix{3}];
fluor_bef_file= [path, cell_prefix{2}];
fluor_aft_file= [path, cell_prefix{1}];

cd(main)
addpath('bfmatlab')
%bfmatlab folder and associated files avaialble for download at http://downloads.openmicroscopy.org/bio-formats/5.3.4/

reader_bf = bfGetReader(bf_cell_file);
reader_bef = bfGetReader(fluor_bef_file);
reader_aft = bfGetReader(fluor_aft_file);
omeMeta = reader_bf.getMetadataStore();
SeriesCount = reader_bf.getSeriesCount();
pixelsize = double(omeMeta.getPixelsPhysicalSizeX(0).value()); % in micron

for i = 1:SeriesCount
Xposition(i) = double(omeMeta.getPlanePositionX(i-1,0).value());
Yposition(i) = double(omeMeta.getPlanePositionY(i-1,0).value());
str{i} = num2str(i);
end



figure;
hold on
plot(Xposition, Yposition,'.')
text(Xposition, Yposition, str)
axis equal
title(cell_prefix{1});


varPrompt = {
'Experiment',...
'Date/ID',...
'Soluble Factor'...
'Number of Arrayed Conditions'...
'dish number'...
'time',...
'Young''s Modulus (Pa) of gel:', ...
'Poisson''s Ratio:'...
'islands                                                                                             .'...
    };
varTitle = 'Input variables';
varLineNo = 1;
varDefAns = {
'BMEL Mechano',...
'091717',...
'DMSO',...
'4',...
'D1',...
'72hrs',...
'30000', ...
'0.48'...,
num2str(1:SeriesCount)...
    };

varResize = 'on';
varInputs = inputdlg(varPrompt, varTitle, varLineNo, varDefAns, varResize);

if ~isempty('varInputs'),
    experiment = (varInputs{1});
    date_ID = (varInputs{2});
    soluble = (varInputs{3});
    num_array = str2num(varInputs{4});
    dish_num = (varInputs{5});
    time = varInputs{6};
    young = str2num(varInputs{7});
    pois = str2num(varInputs{8});
    numbers = str2num(varInputs{9});
end;

young_kpa = young/1000;

save_file_name = [date_ID, '_', experiment, '_', num2str(young_kpa),'kPa_',time '_', soluble, '_', dish_num];




for cycle_i = 1:length(numbers);

count_i = numbers(cycle_i);
map(cycle_i) = count_i;


close all

%%Choose the current image

reader_bf.setSeries(count_i-1);
reader_bef.setSeries(count_i-1);
reader_aft.setSeries(count_i-1);

cell_info.young = young;
cell_info.pois = pois;
cell_info.pixelsize = pixelsize;
cell_info.experiment = experiment;
cell_info.date_ID = date_ID;
cell_info.soluble = soluble;
cell_info.dish_num = dish_num;
cell_info.time = time;
cell_info.Xposition = Xposition(count_i);
cell_info.Yposition = Yposition(count_i);
cell_info.num = count_i;
cell_info.file = bf_cell_file;

bf_cell = bfGetPlane(reader_bf, 1);
fluor_nocell = bfGetPlane(reader_aft, 1);
fluor_cell = bfGetPlane(reader_bef, 1);
% fluor_cell = bfGetPlane(reader_bef, 1);

% Orig_Images{1} = fluor_nocell;
% Orig_Images{2} = fluor_cell;
% Orig_Images{3} = bf_cell;
%cell_info.Orig_Images = Orig_Images;


%% Correct Frame Shift between two images
% Frame shift between stress and relaxed images corrected per methods
% described in Butler et. al 2002
[im_cell, im_nocell, im_bf,shift] = correct_shift(fluor_cell, fluor_nocell, bf_cell,'n');

Images{1} = mat2gray(im_cell);
Images{2} = mat2gray(im_nocell);
Images{3} = mat2gray(im_bf);

clear('fluor_cell', 'fluor_nocell', 'bf_cell','im_cell','im_nocell','im_bf');



%% Estimate displacements using DIC

if max(abs(size(Images{1})-size(Images{2})))==0

% Displacement field between stress and relaxed images calculated per methods
% described in Bar-Kobcha et. al 2014

sSize = [272 272];
sSize = size(Images{1})./8;
% %sSize = [252 252];
u0 = num2cell(zeros(1,2)); %initial displacement guess, set to 0
dm = 8;                    %block size of output
spacing = dm*pixelsize;
cell_info.dm = dm;
[u, ~, ~, dm] = IDIC(Images, sSize, u0, 'c',dm);
u{1} = u{1}-shift(2,1);
u{2} = u{2}+shift(2,2);
u{3} = (u{1}.^2+u{2}.^2).^.5;

else
    u{1} = zeros(273, 273);
    u{2} = zeros(273, 273);
    u{3} = zeros(273, 273);
end

cell_displacements.raw_displacements = u;
Images{1} = [];
Images{2} = [];
cell_info.Images = Images;
dm = 8 ;
cell_info.dm = dm;


%% Save data
cell_data.cell_info = cell_info;
cell_data.cell_displacements = cell_displacements;


all_cell_data{cycle_i} = cell_data;
display(cycle_i)

end
save(save_file_name,'all_cell_data','-v7.3')

for array_ind = 1:num_array

figure;
hold on
plot(Xposition, Yposition,'.')
text(Xposition, Yposition, str)
axis equal

varPrompt = {
    'Experiment',...
    'Date/ID',...
    'Condition',...
    'Arrayed Ligand/ECM',...
    'dish number',...
    'time',...
    'Young''s Modulus (Pa) of gel:', ...
    'Poisson''s Ratio:',...
    'islands                                               .',...
    'File Name',...
    };

varTitle = 'Input variables';
    varLineNo = 1;
    varDefAns = {
    experiment,...
    date_ID,...
    soluble,...
    'Enter Condition',...
    dish_num,...
    time,...
    num2str(young), ...
    num2str(pois),...
    num2str(numbers),...
    save_file_name,...
    };

varResize = 'on';
varInputs = inputdlg(varPrompt, varTitle, varLineNo, varDefAns, varResize);


    experiment = (varInputs{1});
    date_ID = (varInputs{2});
    soluble = (varInputs{3});
    arrayed_con = (varInputs{4});
    dish_num = (varInputs{5});
    time = varInputs{6};
    young = str2num(varInputs{7});
    pois = str2num(varInputs{8});
    numbers_i = str2num(varInputs{9})
    save_file_name = (varInputs{10});


temp_cell_info.young = young;
temp_cell_info.pois = pois;
temp_cell_info.pixelsize = pixelsize;
temp_cell_info.experiment = experiment;
temp_cell_info.date_ID = date_ID;
temp_cell_info.soluble = soluble;
temp_cell_info.dish_num = dish_num;
temp_cell_info.time = time;
temp_cell_info.arrayed_con = arrayed_con;


for cycle_i = 1:length(numbers_i);

count_i = numbers_i(cycle_i)
data_ind = find(map == count_i)

close all

%% initialize info
cell_data = all_cell_data{data_ind};
cell_info = cell_data.cell_info;

pixelsize = cell_info.pixelsize;
Images = cell_info.Images;
dm = cell_info.dm;

temp_cell_info.pixelsize = pixelsize;
temp_cell_info.dm = dm;
temp_cell_info.Xposition = cell_info.Xposition;
temp_cell_info.Yposition = cell_info.Yposition;
temp_cell_info.num = cell_info.num;
temp_cell_info.file = cell_info.file;
temp_cell_info.Images = Images;


young = temp_cell_info.young;
pois = temp_cell_info.pois ;

cell_info = temp_cell_info;

cell_displacements =cell_data.cell_displacements;
u = cell_displacements.raw_displacements;


%% Draw Boundary Around Cell

screensize = get( groot, 'Screensize' );
figsize = min(screensize(3), screensize(4))*0.9;

is_ok = 'n';
sigma = 300;
cny = 0.025;
di = 5;

while 1

    [boundary_points,mask] = cell_boundary(Images{3}, sigma, cny, di);

    cell_boundaries.outline = boundary_points;
    cell_boundaries.mask = mask;
    boundary = boundary_points{1};
    xrub = boundary(:,2);
    %xrub = pixelsize.*xrub;
    yrub = boundary(:,1);
    %yrub = pixelsize.*yrub;

    h = figure;
    hold on
    imagesc(Images{3}); colormap gray; axis equal; axis tight;
    plot(xrub, yrub);
    truesize(h,[figsize figsize])


    varPrompt = {
        'border fit ok?', ...
        'Draw Manually?', ...
        };
    varTitle = 'Input variables';
    varLineNo = 1;
    varDefAns = {
        'y', ...
        'n', ...
        };
    varResize = 'off';
    varInputs = inputdlg(varPrompt, varTitle, varLineNo, varDefAns, varResize);

    if ~isempty('varInputs'),
        is_ok = varInputs{1};
        draw = varInputs{2};
    end;

    if is_ok == 'y'
        break
    end

    if draw == 'n'

    varPrompt = {
        'cny', ...
        'sigma'...
        'di' ...
        };
    varTitle = 'Input variables';
    varLineNo = 1;
    varDefAns = {
        num2str(cny), ...
        num2str(sigma) ...
        num2str(di) ...
        };
    varResize = 'off';
    varInputs = inputdlg(varPrompt, varTitle, varLineNo, varDefAns, varResize);

    if ~isempty('varInputs'),
        cny = str2num(varInputs{1});
        sigma = str2num(varInputs{2});
        di = str2num(varInputs{3});
    end;

    else

im = double(Images{3});
im = im - min(min((im)));                 % calls on function min2
im = im./max(max((im))).*255;             % calls on function max2
im = uint8(im);
imshow(im);                         % draws phase image
[BW, ~, ~] = roipoly(im);     % enables user to draw boundary
BW = double(BW);
H = fspecial('gaussian', 300/2, 300);
BW_filt = imfilter(BW,H,'replicate');
im_fill = mat2gray(BW_filt);
im_fill = im2bw(im_fill,.1);
im_fill= double(imfill(im_fill,'holes'));
seD = strel('diamond',10);
im_fill = imerode(im_fill,seD);
simp = bwareaopen(im_fill,1000);
[boundary_points,mask] = bwboundaries(simp,'noholes');


cell_boundaries.outline = boundary_points;
cell_boundaries.mask = mask;
boundary = boundary_points{1};
xrub = boundary(:,2);
%xrub = pixelsize.*xrub;
yrub = boundary(:,1);


h = figure;
hold on
imagesc(Images{3}); colormap gray; axis equal; axis tight;
plot(xrub, yrub);
truesize(h,[figsize figsize])


    varPrompt = {
        'border fit ok?', ...
        'Draw Manually?', ...
        };
    varTitle = 'Input variables';
    varLineNo = 1;
    varDefAns = {
        'y', ...
        'n', ...
        };
    varResize = 'off';
    varInputs = inputdlg(varPrompt, varTitle, varLineNo, varDefAns, varResize);

    if ~isempty('varInputs'),
        is_ok = varInputs{1};
        draw = varInputs{1};
    end;

    if is_ok == 'y'
        break
    end


    end
end

cell_boundaries.cny = cny;
cell_boundaries.sigma = sigma;
cell_boundaries.di = di;

close all
%% Calculate traction forces from displacement field with unconstrained FTTC
% per methods described in Butler et. al 2002
% software avaiable for download at https://github.com/FranckLab/FIDVC

[tractions, displacements, rmst, a_sym, lambda, theta,Trace_moment] = FTTC_TFM(u, dm, pixelsize, young, pois);

tx = tractions{1};
ty = tractions{2};
ux = displacements{1};
uy = displacements{2};
rmst_uncon = rmst;

cell_displacements.displacements = displacements;
cell_tractions.unconstrained_tractions = tractions;
cell_tractions.unconstrained_RMS = rmst_uncon;
cell_tractions.unconstrained_Trace_moment = Trace_moment;


%% Calculate traction forces from displacement field with constrained FTTC
% per methods described in Butler et. al 2002

[tractions_con, ~, rmst_iterative, Trace_moment, Uecm] = con_FTTC_TFM(u, dm, pixelsize, young, pois, mask, boundary);


cell_tractions.constrained_tractions = tractions_con_new;
cell_tractions.constrained_rms = rmst_iterative;
cell_tractions.constrained_Trace_moment = Trace_moment;
cell_tractions.constrained_Uecm = Uecm;


%% Fit an eplipse to the cell boundary

boundary = boundary_points{1};
xrub = boundary(:,2);
yrub = boundary(:,1);

%fit elipse available for download at https://www.mathworks.com/matlabcentral/fileexchange/3215-fit_ellipse
[a, b, phi, X0_in, Y0_in, X0, Y0] = fit_ellipse(xrub, yrub);

major_axis = max(a,b);
minor_axis = min(a,b);

if b == major_axis
    phi = phi+pi/2;
end

ellipse_fit.phi = phi;
ellipse_fit.X_center = X0_in;
ellipse_fit.Y_center = Y0_in;
ellipse_fit.X0 = X0;
ellipse_fit.Y0 = Y0;
ellipse_fit.major_axis = major_axis*pixelsize;
ellipse_fit.minor_axis = minor_axis*pixelsize;

cell_boundaries.ellipse_fit=ellipse_fit;
R = [ cos(phi) sin(phi); -sin(phi) cos(phi) ];
xrub_0 = xrub-X0_in;
yrub_0 = yrub-Y0_in;
rotated_bound = R'*[xrub_0'; yrub_0'];
cell_boundaries.rotated_bound = rotated_bound;


%% Rotate displacements and tractions to align along longest axis
im_size = size(Images{3});
displacements_rr = rotate_and_center(phi,X0_in, Y0_in, im_size, displacements);
tractions_rr = rotate_and_center(phi,X0_in,Y0_in, im_size, tractions);
tractions_con_rr = rotate_and_center(phi,X0_in,Y0_in, im_size, tractions_con_new);

cell_displacements.rotated_displacements = displacements_rr;
cell_tractions.rotated_tractions = tractions_rr;
cell_tractions.rotated_con_tractions = tractions_con_rr;

    %% Save data
    cell_data.cell_info = cell_info;
    cell_data.cell_boundaries = cell_boundaries;
    cell_data.cell_displacements = cell_displacements;
    cell_data.cell_tractions = cell_tractions;

    all_cell_data{data_ind} = cell_data;

    display(cycle_i)


end
save(save_file_name,'all_cell_data','-v7.3')
close all

end

end
