% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <https://www.gnu.org/licenses/>.

function [RAD, tractx, tracty, T, con,Tnew, TnewSEM, Unew] = data_analysis(all_cell_data,list,num);


%con_names = {'24hrs_DMSO', '24hrs_GSI', '72hrs_DMSO', '72hrs_GSI', '72hrs_ERK', '72hrs_Bleb'};
colors = {'-r', '-g', '-b', '-c', '-m'};
colors1 = {':r', ':g', ':b', ':c', ':m'};
%num = 1;

tractx{1} = zeros(272, 272);
tracty{1} = zeros(272, 272);
ux{1} = zeros(272, 272);
uy{1} = zeros(272, 272);

tractx{2} = zeros(272, 272);
tracty{2} = zeros(272, 272);
ux{2} = zeros(272, 272);
uy{2} = zeros(272, 272);

tractx{3} = zeros(272, 272);
tracty{3} = zeros(272, 272);
ux{3} = zeros(272, 272);
uy{3} = zeros(272, 272);

tractx{4} = zeros(272, 272);
tracty{4} = zeros(272, 272);
ux{4} = zeros(272, 272);
uy{4} = zeros(272, 272);

RMS{1}=[];
RMS{2}=[];
RMS{3}=[];
RMS{4}=[];


%load(file);

list = 1:length(all_cell_data);

s1 = 0;
s2 = 0;
s3 = 0;
s4 = 0;

for ii = 1:length(list)
    i = list(ii);

    current_cell = all_cell_data{i};
    u = current_cell.cell_displacements.rotated_displacements;
    pixelsize = current_cell.cell_info.pixelsize;
    dm = current_cell.cell_info.dm;
    %im_bf = im2double(current_cell.cell_info.Images{3});
    arrayed_con = current_cell.cell_info.arrayed_con;
    young = current_cell.cell_info.young;
    pois = current_cell.cell_info.pois;
    experiment = current_cell.cell_info.experiment;
    date_ID = current_cell.cell_info.date_ID;
    soluble = current_cell.cell_info.soluble;
    dish_num = current_cell.cell_info.dish_num;
    time = current_cell.cell_info.time;
    czi_num = current_cell.cell_info.num;
    czi_file = current_cell.cell_info.file;


    con{ii,1} = experiment;
    con{ii,2} = date_ID;
    con{ii,3} = young;
    con{ii,4} = soluble;
    con{ii,5} = time;
    con{ii,6} = arrayed_con;
    con{ii,7} = dish_num;
    con{ii,8} = i;
    con{ii,9} = czi_num;
    con{ii,10} = czi_file;




    switch arrayed_con
    case 'IgG'
        sort = 1;
        s1 = s1+1;
        ct = s1;
    case 'JAG1'
        sort = 2;
        s2 = s2+1;
        ct = s2;
    case 'DLL1'
        sort = 3;
        s3 = s3+1;
        ct = s3;
    case 'DLL4'
        sort = 4;
        s4 = s4+1;
        ct = s4;
    end


   t = current_cell.cell_tractions.rotated_con_tractions;
    %t = current_cell.cell_tractions.rotated_tractions;
    RMS{sort}(ct) = current_cell.cell_tractions.constrained_rms;
    trace{sort}(ct) = current_cell.cell_tractions.constrained_Trace_moment;

    ellipse_fit = current_cell.cell_boundaries.ellipse_fit;
    phi = ellipse_fit.phi;
    X0_in = ellipse_fit.X_center;
    Y0_in = ellipse_fit.Y_center;

    a = ellipse_fit.major_axis;
    b = ellipse_fit.minor_axis;
    boundary = current_cell.cell_boundaries.outline{1}*pixelsize;
    xrub_0 = boundary(:,2)-X0_in*pixelsize;
    yrub_0 = boundary(:,1)-Y0_in*pixelsize;


    A{ct,sort} = a;
    B{ct,sort} = b;
    tractx{ct,sort} = t{1};
    tracty{ct,sort} = t{2};
    ux{ct, sort} =u{1};
    uy{ct, sort} = u{2};

    U{ct,sort} = (u{1}.^2+u{2}.^2).^(1/2);
    T{ct,sort} = (t{1}.^2+t{2}.^2).^(1/2);

    RAD{ct,sort} = (a+b)/2;
    rad = (a+b)/2;

    [x,y] = meshgrid(0:dm:size(U{ct,sort},1)*dm-dm,0:dm:size(U{ct,sort},2)*dm-dm);
    x = x-mean(mean(x));
    y = y - mean(mean(y));
    r = (x.^2+y.^2).^(1/2);
    r = r.*pixelsize;
    r = r./rad;

    s = size(r,2);
    Rv{ct,sort} = round(100.*reshape(r,[s^2,1]))./100;
    Uv{ct,sort} = [Rv{ct,sort} reshape(U{ct,sort},[s^2,1])];
    Tv{ct,sort} = [Rv{ct,sort} reshape(T{ct,sort},[s^2,1])];
    %Tv{ct,sort} = Tv{ct,sort}./rad;

    [RVnew,~,idx] = unique(Rv{ct,sort});
    RVnews{ct,sort} = RVnew;
    Uvnew{ct,sort} = [RVnew,accumarray(idx,Uv{ct,sort}(:,2),[],@mean)];
    Tvnew{ct,sort} = [RVnew,accumarray(idx,Tv{ct,sort}(:,2),[],@mean)];
    Tvnewstd{ct,sort} = [RVnew,accumarray(idx,Tv{ct,sort}(:,2),[],@std)];
    Tvnewnumelrt{ct,sort} = ([RVnew,accumarray(idx,Tv{ct,sort}(:,2),[],@numel)]);
    TvnewSEM{ct,sort} = Tvnewstd{ct,sort}(:,2)./(Tvnewnumelrt{ct,sort}(:,2)).^.5;

    %Tvnew{ct,sort} = Tvnew{ct,sort}./rad;

    numb(ct,sort) = i;

    con{ii,11} = rad;
    con{ii,12} = max(Tvnew{ct,sort}(:,2));
    con{ii,13} = mean(Tvnew{ct,sort}(:,2));
    con{ii,14} = max(Uvnew{ct,sort}(:,2));
    con{ii,15} = mean(Uvnew{ct,sort}(:,2));
    con{ii,16} = current_cell.cell_tractions.constrained_rms;


end

counts = [s1 s2 s3 s4];

for i = 1:4

    ct = counts(i);

    RRv = [];
    UUv = [];
    TTv = [];

    for k = 1:ct;

        RRv = [RRv;RVnews{k,i}];
        UUv = [UUv;Uvnew{k,i}];
        TTv = [TTv;Tvnew{k,i}];

    end



[Rnew,~,idx] = unique(RRv(:,1));
Unew{i} = [Rnew,accumarray(idx,UUv(:,2),[],@mean)];
Tnew{i} = [Rnew,accumarray(idx,TTv(:,2),[],@mean)];
Tnewstd{i} = [Rnew,accumarray(idx,TTv(:,2),[],@std)];
Tnewnumel{i} = ([Rnew,accumarray(idx,TTv(:,2),[],@numel)]);
TnewSEM{i} = Tnewstd{i}(:,2)./(Tnewnumel{i}(:,2)).^.5;

Unewstd{i} = [Rnew,accumarray(idx,UUv(:,2),[],@std)];
Unewnumel{i} = ([Rnew,accumarray(idx,UUv(:,2),[],@numel)]);
UnewSEM{i} = Unewstd{i}(:,2)./(Unewnumel{i}(:,2)).^.5;

end



 labels = {'IgG', 'JAG1', 'DLL1', 'DLL4'};


%figure; hold on;
%figure(1);hold on;
for i=1:4
%figure(i);hold on;
ax = subplot(2,2,i);
hold on;

ct = counts(i);

for j = 1:ct
%figure
hold on
%yyaxis left
%plot(Unew{i}(:,1),Unew{i}(:,2));
xlabel('r/R ','FontSize',10,'FontWeight','bold');
% plot(Tvnew{j,i}(:,1),Tvnew{j,i}(:,2),colors{num});
%ylabel('Traction (Pa)','FontSize',10,'FontWeight','bold');

%ind = randi([0 100],1,1);
% text(Tvnew{j,i}(60,1),Tvnew{j,i}(60,2),num2str(numb(j,i)))
% text(Tvnew{j,i}(1,1),Tvnew{j,i}(1,2),num2str(numb(j,i)))
axis([0 1 0 2.5]);axis square;
%title(num2str(numb(j,i)));

end

plot(Unew{i}(:,1),Unew{i}(:,2),colors{num},'Linewidth',2);
plot(Unew{i}(:,1),Unew{i}(:,2)+1.96.*UnewSEM{i},colors1{num},'Linewidth',1);
plot(Unew{i}(:,1),Unew{i}(:,2)-1.96.*UnewSEM{i},colors1{num},'Linewidth',1);

title(labels{i})


end



%save(save_name);

%end
