% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <https://www.gnu.org/licenses/>.

function [boundary_points,mask] = cell_boundary(im_bf, sigma, cny,di);


%%% Draw Boundary Around Cell using a series of filters
%%% Created by Ian Berg 3/18/2016
window = size(im_bf);
center = window/2;


is = mat2gray(im_bf);

[h, wi] = size(im_bf);

offseth = ones(h,1)*median(is);
offsetv = median(is,2)*ones(1,wi);
offset = (offseth+offsetv)./2;

im_off = abs(is - 1*offset);

im_soft = im_off;%imgaussfilt(im_off,4);
im_edge = double(edge(im_soft,'canny', cny));

im_fill = mat2gray(im_edge);
im_fill = imgaussfilt(im_fill,sigma);

im_fill = im2bw(im_fill,.1);
im_fill= double(imfill(im_fill,'holes'));

im_fill = bwareaopen(im_fill,100);

im_fill = mat2gray(im_fill);
im_fill = imgaussfilt(im_fill,sigma);

seD = strel('diamond',di);
im_fill = imerode(im_fill,seD);

th2 = .5;

im_fill = im2bw(im_fill, th2);
im_fill= imfill(im_fill,'holes');
im_fill = double(im_fill);

simp = bwareaopen(im_fill,1000);


[boundary_points,mask] = bwboundaries(simp,'noholes');

for i = 1:size(boundary_points,1)
    bounds = boundary_points{i};
    %size_check(i,1) = size(bounds,1);
    cen = mean(bounds);
    dist(i) = sqrt((cen(1)-center(1))^2+(cen(2)-center(2))^2);
end

if isempty(boundary_points);
    boundary_points{1} = [1,1];
    ind = 1;
else

[~, ind] = min(dist);
boundary_points{1} = boundary_points{ind};
mask = mask == ind;
mask = double(mask);
end


end

function Im = imgaussfilt(I, sigma)

H = fspecial('gaussian', sigma/2, sigma);
Im = imfilter(I,H,'replicate');

end
