%% Preprocced fMRI Data of pFs is stored in:
load('NNLOCOmb.mat') %=> GET FILE FROM MVPA_pFs.zip => 'NNLOCOmb.mat' => pFs Open Science Framework. May 31. osf.io/hcp47.
%This structure was created based on the output of the FSL Firstlevel
%analyses, before running the firstlevel analyses, we used BetCrawler(0.4), motion correction and slice time
%correction, registration, transformed the subjects space to standard space MNI
%we ran the FSL First Level, with no convolution and created EV's (PE's Predictor Estimates )on each TR of each trial.

%Has the NNLOComb, which is a structure as follows:
%NN =   NNStruct.Participants.ROIs.activity(Voxels X Predictor Estimates(PEs))
%       NNStruct.Participants.ROIs.index (voxel index in MNI space)
%       .........P01...............................
%       .........P02...............................
%       .........etc...............................
%       NNStruct.Participants.PE are the names of the PEs per trial and TR
%       example and also used for the EV's in the FSL Firslevel:
%       ParticipantNumber (P01,P02,.....P24)
%       P01FWM2-fMRITemplateN_2TEyeFTrig_tr1_111_11_1
%       P02..........................................
%          RunNumber(WM1,WM2,WM3,WM4,WM5,WM6,WM7,WM8)
%       ....WM3......................................
%                                      interval(tr1, tr2)
%       ................................_tr2.........
%                                          condition(111,222,333,444,555,666)
%                                                    111 = Cow Current
%                                                    222 = Cow Prospective
%                                                    333 = Dresser Current
%                                                    444 = dresser Prospective
%                                                    555 = Skate Current
%                                                    666 = Skate Prospective
%       .....................................222.....
%                                               examplar (cow:11,12,13,14,
%                                               dresser:21,22,23,24
%                                               skate:31,32,33,34
%       .........................................11..
%                                                  TR(1,2,3,5,6,7,8,9,10,11,12,13,14,15)
%       ............................................1
%       P01FWM2-fMRITemplateN_2TEyeFTrig_tr1_111_11_1
%
%           P01-P24 = Paricipant Identity
%           WM1-WM8 = Indicates Run number
%           tr     = where in the trial tr1 => first 6 TRs of the trial:
%               1 = Cue
%               2 = Delay_Tr1
%               3 = Delay_Tr2
%               4 = Delay_Tr3
%               5 = Delay_Tr4
%               6 = Search1_display
%            and tr2 => next 9 TRs of the trial:
%               1(7) = Search1_Tr1
%               2(8) = Search1_Tr2
%               3(9) = Search1_Tr3
%               4(10) = Search1_Tr4
%               5(11) = Search2_Display
%               6(12) = Search2_Tr1
%               7(13) = Search2_Tr2
%               8(14) = Search2_Tr3
%               9(15) = Search2_Tr4
%
% It also contains subjTemp which is a Template to perform the classifier,
% indicating the start of the different RUNs, and PE's in order to run the
% cross validation, based on the princeton-mvpa-toolbox-master (Detre at
% al. 2006)

%% CLASSIFIER USING LOGISTIC REGRESSION BASED ON THE PRINCETON MVPA TOOLBOX (Figure 2A & Figure 2B)
%see Figure2_WithinCrossRelevanceDecoding.xlsx, sheet withindecoding (Figure 2A) &
%crossdecoding (Figure 2B)

% you need the NNLOComb  of you want to run the scripts so:
%load('NNLOCOmb.mat')) =>pFs data

%to get the output:
load('WithinCrossDecoding_pFs_Figure2.mat') 

%Requires a template subject: subjTemp & the output from the FSL firstlevel in a datastructure called an NNstruct with
%Participants => ROIs & Predictor Estimates (PE) => activity (voxels x
%PE's) & index (which refers to the voxels in the brain.
%settings for the classifier
%condition codes:
% 111 = Cow Current
% 222 = Cow Prospective
% 333 = Dresser Current
% 444 = dresser Prospective
% 555 = Skate Current
% 666 = Skate Prospective

class_args.train_funct_name = 'train_logreg';
class_args.test_funct_name = 'test_logreg';
class_args.penalty = 0.05;

%This scripts saves for each participant a seperate .mat file with it's output stored.  Where you can see the classifier performace for each category 
%(cow, dresser & skate seperatly, also for each run). The output variable
%perf = participants x TRs => 24 X 15.
conArCur = {'111','333','555'};
[perfNCurrNTOFM_LR] = cross_validationAnoukRoiS(subjTemp,'epi','conds','runs_xval','epi_z_thresh0.05',class_args,{},NNLOComb, conArCur,1,'TOFMCur',1,24);

conArPros = {'222','444','666'};
[perfNProsNTOFM_LR] = cross_validationAnoukRoiS(subjTemp,'epi','conds','runs_xval','epi_z_thresh0.05',class_args,{},NNLOComb, conArPros,1,'TOFMPros',1,24);

%Here there is cross validation, trained on Prospective, test on Current
%trials
conArPC = {'111','333','555','222','444','666'};
[perfNPCNTOFM_LR] = cross_validationAnoukCrossRoiS(subjTemp,'epi','conds','runs_xval','epi_z_thresh0.05',class_args,{},NNLOComb, conArPC,1,'TOFMPC',1,24);

%Here there is cross validation, trained on Current, test on Prospective
%trials
conArCP = {'222','444','666','111','333','555',};
[perfNCPNTOFM_LR] = cross_validationAnoukCrossRoiS(subjTemp,'epi','conds','runs_xval','epi_z_thresh0.05',class_args,{},NNLOComb, conArCP,1,'TOFMCP',1,24);

%Here trained purely on status irrespective of category
[perfNStatTOFM_LR] = cross_validationAnoukStatusRoiS(subjTemp,'epi','conds','runs_xval','epi_z_thresh0.05',class_args,{},NNLOComb, conArPC,1,'TOFMStat',1,24);


%% Figure 2A & 2B
meanCur = mean(perfNCurrNTOFM_LR,1)*100;
meanPros = mean(perfNProsNTOFM_LR,1)*100;
meanPC = mean(perfNPCNTOFM_LR,1)*100;
meanCP = mean(perfNCPNTOFM_LR,1)*100;

%Old SE plotting
% SECur = std(perfNCurrNTOFM_LR,1)/sqrt(24);
% SEPros = std(perfNProsNTOFM_LR,1)/sqrt(24);
% SEPC = std(perfNPCNTOFM_LR,1)/sqrt(24);
% SECP = std(perfNCPNTOFM_LR,1)/sqrt(24);

%
%This function calculates the standard error of the mean for bar plots of
%within-subject (repeated measure) designs, properly taking into account 
%between-subject variability. It is based on the method described by 
%Cousineau (2005) and includes a debiasing factor described by Morey (2008).
%Implementation of the method is described in O'Brian & Cousineau (2014). 
figure
hold on
for decoding = 1:2;
    if decoding == 1; %within-relevance   
        perf1 = perfNCurrNTOFM_LR*100; 
        perf2 = perfNProsNTOFM_LR*100; 
    elseif decoding == 2; %Cross-relevance decoding  
        perf1 = perfNPCNTOFM_LR*100;
        perf2 = perfNCPNTOFM_LR*100;
    end
    
    N = size(perf1,1);
    for cTR = 1:size(perf1,2)
        X(:,1) = perf1(:,cTR);
        X(:,2) = perf2(:,cTR);
        
        %This function calculates the standard error of the mean for bar plots of
        %within-subject (repeated measure) designs, properly taking into account 
        %between-subject variability. It is based on the method described by 
        %Cousineau (2005) and includes a debiasing factor described by Morey (2008).
        %Implementation of the method is described in O'Brian & Cousineau (2014). 

        W = SEM_MC(X);

        Error1 = std(W(:,1),1)/sqrt(N);
        Error2 = std(W(:,2),1)/sqrt(N);

        if decoding == 1; %within-relevance 
           SECur(:,cTR) = Error1;
           SEPros(:,cTR) = Error2;
        elseif decoding == 2; %cross-relevance   
           SEPC(:,cTR) = Error1;
           SECP(:,cTR) = Error2;
        end
    end %cTR
    
 %Colors of the lines
blue = [57 72 155]/255;
pink = [227 73 151]/255;

names = {'Cue'; 'TR1'; 'TR2'; 'TR3'; 'TR4';'Search 1';'TR1'; 'TR2'; 'TR3'; 'TR4';'Search 2';'TR1'; 'TR2'; 'TR3'; 'TR4'};

if decoding == 1 %within-relevance
    subplot(2,1,1)
    lh1=shadedErrorBarfunc([1:15],meanCur,SECur,blue,0);
    lh2=shadedErrorBarfunc([1:15],meanPros,SEPros,pink,0);
    title({'Within-Relevance Decoding'},'FontSize',10, 'fontweight','bold')
elseif decoding == 2 %cross-relevance
    subplot(2,1,2)
    lh1=shadedErrorBarfunc([1:15],meanPC,SEPC,blue,0);
    lh2=shadedErrorBarfunc([1:15],meanCP,SECP,pink,0);
    title({'Cross-Relevance Decoding'},'FontSize',10, 'fontweight','bold')
end
lgd=legend([lh1.mainLine,lh2.mainLine], 'Current','Prospective','location', 'northwest', 'orientation', 'vertical');
set(lgd,'FontSize',9); 
legend('boxoff')
set(gca, 'Ylim', [15 65])
set(gca, 'Ytick', [15:10:65],'FontSize', 9)
set(gca ,'TickDir','in')
ylabel({'Classification Performance (%)'},'FontSize',10, 'fontweight','bold')
plot([0,16],[33.3333,33.3333],':k')

set(gca, 'Xlim', [0.5 15.5],'FontSize', 9)
set(gca ,'TickDir','in')
set(gca,'Xtick',[1:15], 'xticklabel',names)


box off
hold on
pbaspect([2.5 1 1])
end

print('-dpdf','-r600',  'Figure2AC_Matlab');
%%
%Average over the TR's to create the windows of interest
TRArrayC = [3 8 13]; %3 = Delay_TR2, 8 = Search1_Tr2, 13 = Search2_Tr2
figure
for decoding = 1:2;
    if decoding == 1 %within-relevance
        meanDecodeC = perfNCurrNTOFM_LR*100;;
        meanDecodeP = perfNProsNTOFM_LR*100;;
    elseif decoding == 2 %cross-relevance
        meanDecodeC = perfNCPNTOFM_LR*100;
        meanDecodeP = perfNPCNTOFM_LR*100;
    end

    count = 0;
    for cTR = 1:length(TRArrayC);
        count = count +1;
        meanDecode(:,count) = mean(meanDecodeC(:, TRArrayC(cTR): TRArrayC(cTR)+2),2);
        count = count +1;
        meanDecode(:,count) = mean(meanDecodeP(:, TRArrayC(cTR): TRArrayC(cTR)+2),2);    
    end
  
    meanDecode=sortrows(meanDecode);
    nSubjects = size(meanDecode,1);
    meanDecodeGA = mean(meanDecode,1);
    
    subplot(1,2,decoding)
    placeJ =  [1,2,4,5,7,8];
    for i = 1:length(meanDecodeGA);
        
        h = bar(placeJ(i),meanDecodeGA(i), 'BarWidth', 0.7,'FaceColor', 'none');
        if i == 1, hold on, end
        if  mod(i,2) == 1; %Current
            col = blue; %[165 165 165]/255;
        else  mod(i,2) == 0; %Pros
            col = pink;%[255 255 255]/255; 
        end 
        set(h, 'FaceColor', col)
    end
    
   meanDecodeS = sortrows(meanDecode);
   meanDecode2(:,1:2)=(meanDecodeS(:,1:2));
   meanDecode2(:,3) = NaN;
   meanDecode2(:,4:5)=(meanDecodeS(:,3:4));
   meanDecode2(:,6) = NaN;
   meanDecode2(:,7:8)=(meanDecodeS(:,5:6));

    plotSpreadAnoukCol(meanDecode2,[],[],{'Delay','','', 'Search 1','','','Search 2',''}, 'showMM', 10,'nSubjects',nSubjects)
    set(gca, 'Ylim', [10 75])
    set(gca, 'Ytick', [10:10:75],'FontSize', 9)
    ylabel({'Classification Performance (%)'},'FontSize',10, 'fontweight','bold')
    set(gca ,'TickDir','in')
    plot([-2,10],[33.3333,33.3333],':k')
    box off
    pbaspect([1 1 1])
    if decoding == 1
       title(['Within Relevance']) 
    elseif decoding == 2
       title(['Cross-relevance']) 
    end
     print('-dpdf','-r600','Figure2BD_Matlab') 
end %deocding  