function [W] = SEM_MC(X)
%This function calculates the standard error of the mean for bar plots of
%within-subject (repeated measure) designs, properly taking into account 
%between-subject variability. It is based on the method described by 
%Cousineau (2005) and includes a debiasing factor described by Morey (2008).
%Implementation of the method is described in O'Brian & Cousineau (2014). 

%Note: the number of conditions used for the debiasing factor (J) is the
%multiplication of factors * levels you used in the ANOVA, e.g. 2 factors
%with 3 levels each will give a J of 6. Or a RM t-test will give you a J of 2.
%So make sure to put in X only the conditions you use in your ANOVA. 

%NOTE: MAKE SURE NOT TO USE THE MODIFIED DATA ARRAY W FOR ANYTHING OTHER
%THAN CREATING BARGRAPHS WITH ERROR BARS!!! USE YOUR ORIGINAL DATA FOR YOUR 
%STATISTICAL TESTS!!!

%Ingmar de Vries (2016)

%INPUT
%X is a 2D matrix with a trial average value for each participant (rows)
%and each condition (colums).

%OUTPUT
%W is the modified data. It has for each condition the same mean as X, but
%the standard error now excludes the between-subject variability. Now you
%can use W for your bar graph and use SEM = STD/sqrt(num_sub) to calculate
%the standard error of the mean corrected for between-subject variability. 

Y = X - repmat(mean(X'),size(X,2),1)' + mean(mean(X));

J = size(X,2);
Z = sqrt(J/(J-1)) *  (Y - repmat(mean(Y), size(Y,1),1));
W = repmat(mean(Y), size(Y,1),1) + Z;


end
