%% Preprocced fMRI Data of pFs is stored in:
load('NNLOCOmb.mat')
%This structure was created based on the output of the FSL Firstlevel
%analyses, before running the firstlevel analyses, we used BetCrawler(0.4), motion correction and slice time
%correction, registration, transformed the subjects space to standard space MNI
%we ran the FSL First Level, with no convolution and created EV's (PE's Predictor Estimates )on each TR of each trial.

%Has the NNLOComb, which is a structure as follows:
%NN =   NNStruct.Participants.ROIs.activity(Voxels X Predictor Estimates(PEs))
%       NNStruct.Participants.ROIs.index (voxel index in MNI space)
%       .........P01...............................
%       .........P02...............................
%       .........etc...............................
%       NNStruct.Participants.PE are the names of the PEs per trial and TR
%       example and also used for the EV's in the FSL Firslevel:
%       ParticipantNumber (P01,P02,.....P24)
%       P01FWM2-fMRITemplateN_2TEyeFTrig_tr1_111_11_1
%       P02..........................................
%          RunNumber(WM1,WM2,WM3,WM4,WM5,WM6,WM7,WM8)
%       ....WM3......................................
%                                      interval(tr1, tr2)
%       ................................_tr2.........
%                                          condition(111,222,333,444,555,666)
%                                                    111 = Cow Current
%                                                    222 = Cow Prospective
%                                                    333 = Dresser Current
%                                                    444 = dresser Prospective
%                                                    555 = Skate Current
%                                                    666 = Skate Prospective
%       .....................................222.....
%                                               examplar (cow:11,12,13,14,
%                                               dresser:21,22,23,24
%                                               skate:31,32,33,34
%       .........................................11..
%                                                  TR(1,2,3,5,6,7,8,9,10,11,12,13,14,15)
%       ............................................1
%       P01FWM2-fMRITemplateN_2TEyeFTrig_tr1_111_11_1
%
%           P01-P24 = Paricipant Identity
%           WM1-WM8 = Indicates Run number
%           tr     = where in the trial tr1 => first 6 TRs of the trial:
%               1 = Cue
%               2 = Delay_Tr1
%               3 = Delay_Tr2
%               4 = Delay_Tr3
%               5 = Delay_Tr4
%               6 = Search1_display
%            and tr2 => next 9 TRs of the trial:
%               1(7) = Search1_Tr1
%               2(8) = Search1_Tr2
%               3(9) = Search1_Tr3
%               4(10) = Search1_Tr4
%               5(11) = Search2_Display
%               6(12) = Search2_Tr1
%               7(13) = Search2_Tr2
%               8(14) = Search2_Tr3
%               9(15) = Search2_Tr4
%
% It also contains subjTemp which is a Template to perform the classifier,
% indicating the start of the different RUNs, and PE's in order to run the
% cross validation, based on the princeton-mvpa-toolbox-master (Detre at
% al. 2006)

%% Representational dissimilarity analyses (RDM) & Multidimensional Scaling Figure 3AB and Figure S3ABCD
%see Figure3_RDM.xlsx, sheet RDM, for index of the RDM and coloring

%load('NNLOCOmb.mat') to get the NNLOComb =>pFs data
%load(WorkspaceVIPSALL_LR_Lisa.mat) => NNVIPSALLCombz containing both IPS
%and VC ROIs
%load('WorkspaceRMF_LR.mat') => NNRMFComb contains RMF ROI

%to get the output:
load('RDM_MDS_Figure3FigureS3.mat') %you also need the NNLOComb (load('NNLOCOmb.mat'))

%Array of all the 15 TR's in the trial
TRArray15 = {'1','2','3','4','5','6','1','2','3','4','5','6', '7', '8', '9'};
[gaRDMWMCombTRLO9ExSM,subjectRDMWMCombTLRLO9ExSM, uPECombTR] = OP2_GetRDMRetentionP3FlowerTRAll9Miss(NNLOComb, 2,  TRArray15, 1, 1);
%Fisher transform
[fgaRDMWMCombTRLO9ExSM, fsubjectRDMWMCombTLRLO9ExSM] = fisherRDMs(subjectRDMWMCombTLRLO9ExSM);

%% Creating Figure 3AB 
userOptions_AvL = projectOptions_AvL();
TRArrayC = [3 8 13]; %3 = Delay_TR2, 8 = Search1_Tr2, 13 = Search2_Tr2
grey = [0.35 0.35 0.35];

CurrC = [101 50 152]/255;
CurrD = [0 153 102]/255;
CurrS = [247 148 30]/255;

ProsC = [149 121 182]/255;
ProsD = [185 217 137]/255;
ProsS = [253 208 158]/255;
%
colorMark = {[CurrC], [CurrD], [CurrS], [ProsC], [ProsD], [ProsS]};
lineT = {'-'  '-'  '-'  ':'  ':'  ':' };

sz = 100;
countTR = 0;
meanY = 1;
%examplar shapes
ma = {'d'  'o'  's' '^'};
titleT = {'Delay'; 'Search 1'; 'Search 2'};
convexHulls = userOptions_AvL.convexHulls;
conditionColours = userOptions_AvL.conditionColours;
for cRoi = 1%:4
  figure;
  countTR = 0;
    if cRoi == 1;
        gaRDMWM = gaRDMWMCombTRLO9ExSM; 
    elseif cRoi == 2;
        gaRDMWM = gaRDMWMCombTRVAll9ExSM;
    elseif cRoi == 3;
        gaRDMWM = gaRDMWMCombTRIPS9ExSM;  
    elseif cRoi == 4;
         gaRDMWM = gaRDMWMCombTRRMF9ExSM; 
    end

    for cTR = 1:length(TRArrayC);
        markerO = 1;
        countTR = countTR +1;
        subplot(2,length(TRArrayC), countTR)
        if meanY == 1;
            %To average over TR2, TR3,& TR4 in each window of interest:
            %Delay, Search1 and Search 2
            RDM1 = squareform(gaRDMWM.RDM(TRArrayC(cTR),:));
            RDM2 = squareform(gaRDMWM.RDM(TRArrayC(cTR)+1,:));
            RDM3 = squareform(gaRDMWM.RDM(TRArrayC(cTR)+2,:));
            RDMS = (RDM1+RDM2+RDM3)/3;
        elseif meanY == 0;
             RDMS = squareform(gaRDMWM(cTR,:));
        end    
        alpha = ~isnan(RDMS);
        image(scale01(rankTransform_equalsStayEqual(RDMS,1)),'CDataMapping','scaled','AlphaData',alpha);
        set(gca,'CLim',[0 1],'CLimMode','manual');
        colormap(gca, colourScheme);
        set(gca,'XTick',[],'YTick',[]);
        axis('square')
        title (titleT(cTR))
        countTR2 = countTR +3;
        subplot(2,length(TRArrayC), countTR2)
      
        %Create the MDS plots 
        %Note that you have to remove the
        %princeton-mvpa-toolbox-master/netlab from your paths settings!
        %Otherwise there might be conflicting pca.m scripts.
        Y = mdscale(RDMS,2, 'criterion','metricsstress','options', struct('MaxIter', 1000));
        axis('square')
        hold on

        categories = unique(convexHulls);
        nCategories = numel(categories);
        colorC = 1;
        subtractC = 0;
        markerO = 1; 
        numbO =1;
        for icon = 1:24 
             plot(Y(icon,1), Y(icon,2),ma{numbO},'MarkerFaceColor',colorMark{markerO},'MarkerEdgeColor',colorMark{markerO},'MarkerSize', 8, 'LineWidth', 0.5); 
             if mod(icon,4) == 0
                markerO = markerO + 1;  
             end
  
            if mod(icon,4) == 0
                  numbO = 1; 
            else
                  numbO = numbO + 1; 
            end
             
        end


         for hullI = 1:nCategories
            thisHullLabel = categories(hullI);
            withinHullPointIs = find(convexHulls == thisHullLabel);
            withinHullPointCoords = Y(withinHullPointIs, :);
            hullBoundaryPointIs = convhull(withinHullPointCoords(:,1), withinHullPointCoords(:,2));
            plot(withinHullPointCoords(hullBoundaryPointIs, 1), withinHullPointCoords(hullBoundaryPointIs, 2), 'LineWidth', 2, 'Color', colorMark{hullI},'LineStyle', lineT{hullI});
         end
    
        if cRoi ==1;
            maxYX = 0.5; %For Figure 3B
        else   
            maxYX = 0.6; %For Figure S3ABCD
        end    
        set(gca, 'Ylim', [-maxYX maxYX])
        set(gca, 'Xlim', [-maxYX maxYX])
        set(gca, 'Xtick', [])
        set(gca, 'Ytick', [])
        title (titleT(cTR))
        box on

    end
end  
print('-dpdf','-r600', 'Figure3_Matlab');
%% Calculating average dissimilarity values Figure 3C
%see OverviewResults_pFs.xlsx, sheet RDM, for index of the RDM and coloring
nTR = 15;
subjectRDM= fsubjectRDMWMCombTLRLO9ExSM;

for cSub = 1:24
    for cTR = 1:nTR;%1:15%0%:length(nRois)-3;
        %Within Current/Current Within Category Dark Blue
        categoryExam(1).Diss(cSub,cTR) = nanmean(subjectRDM(cSub).rdm(cTR,[1:3,24,25,46, ...
         87:89,106,107,124,...
         157:159,172,173,186, ...
         ]));
      %Within Prospective/Prospective Within Category Dark Green
        categoryExam(2).Diss(cSub,cTR) = nanmean(subjectRDM(cSub).rdm(cTR,[211:213,222,223,232, ...
         249:251,256,257,262, ...,
         271:276, ...
         ]));
     %Between Current/Prospective Within Category Dark Red
        sqRDM = squareform(subjectRDM(cSub).rdm(cTR,:));
        categoryExam(3).Diss(cSub,cTR) =  nanmean(nanmean([sqRDM(1:4,13:16), ...
            sqRDM(5:8,17:20), ...
            sqRDM(9:12,21:24), ...
            ]));
      %Within Current, Between Catagory Light Blue
         categoryExam(4).Diss(cSub,cTR) =  nanmean(nanmean([sqRDM(1:4,5:8), ...
            sqRDM(1:4,9:12), ...
            sqRDM(5:8,9:12), ...
            ]));
        
        %Within Prospective, Between Catagory Light Green
       categoryExam(5).Diss(cSub,cTR) =  nanmean(nanmean([sqRDM(13:16,17:20), ...
            sqRDM(13:16,21:24), ...
            sqRDM(17:20,21:24), ...
            ]));

        %Between Current/Prospective Between Catagory Orange
        categoryExam(6).Diss(cSub,cTR) =  nanmean(nanmean([sqRDM(1:4,17:20), ...
            sqRDM(5:8,13:16), ...
            sqRDM(5:8,21:24), ...
            sqRDM(9:12,13:16), ...
            sqRDM(1:4,21:24), ...
            sqRDM(9:12,17:20), ...
            ]));
    end
end

%MEAN TR345
TR3Array = [3 8 13]; 
Delay = {'Delay', 'Seach1', 'Search2'};

for cTR = 1:length(TR3Array)%0%:length(nRois)-3;
    %We only report this part of the RDM, the different Relevance
    %(Current x Prospective)
       meanTRDiss.(Delay{cTR})(:,1)= mean(categoryExam(3).Diss(:,TR3Array(cTR):TR3Array(cTR)+2),2);%bCurPro_wCat
       meanTRDiss.(Delay{cTR})(:,2)= mean(categoryExam(6).Diss(:,TR3Array(cTR):TR3Array(cTR)+2),2);%bCurPro_BCat
      % meanTRDiss.(Delay{cTR})(:,3)= mean(categoryExam(1).Diss(:,TR3Array(cTR):TR3Array(cTR)+2),2); %wCur_wCat
      % meanTRDiss.(Delay{cTR})(:,4)= mean(categoryExam(4).Diss(:,TR3Array(cTR):TR3Array(cTR)+2),2);%wCur_BCat
      % meanTRDiss.(Delay{cTR})(:,5)= mean(categoryExam(2).Diss(:,TR3Array(cTR):TR3Array(cTR)+2),2);%wPro_wCat
      % meanTRDiss.(Delay{cTR})(:,6)= mean(categoryExam(5).Diss(:,TR3Array(cTR):TR3Array(cTR)+2),2);%wPro_BCat
end

%% Creating Figure 3C
%So that the data is sorted according to the first colom, namely Same
%Category Different Relevance in the Delay
DissDiffRelevance=sortrows(DissDiffRelevance);
nSubjects = size(DissDiffRelevance,1);
meanDissDiffRelevance = mean(DissDiffRelevance,1);
figure
placeJ =  [1,2,4,5,7,8];
for i = 1:length(meanDissDiffRelevance);

    h = bar(placeJ(i),meanDissDiffRelevance(i), 'BarWidth', 0.7,'FaceColor', 'none');
    if i == 1, hold on, end
    if  mod(i,2) == 1; %Same Category
        col = [165 165 165]/255;
    else  mod(i,2) == 0; %Different Category
        col = [255 255 255]/255; 
    end 
    set(h, 'FaceColor', col)
end
 DissDiffRelevanceS = sortrows(DissDiffRelevance);
 DissDiffRelevance2(:,1:2)=(DissDiffRelevanceS(:,1:2));
 DissDiffRelevance2(:,3) = NaN;
 DissDiffRelevance2(:,4:5)=(DissDiffRelevanceS(:,3:4));
 DissDiffRelevance2(:,6) = NaN;
 DissDiffRelevance2(:,7:8)=(DissDiffRelevanceS(:,5:6));

 plotSpreadAnoukCol(DissDiffRelevance2,[],[],{'DelayS','DelayD','', 'Search 1S','Search 1D','','Search 2S','Search 2D'}, 'showMM', 10,'nSubjects',nSubjects)
 set(gca, 'ylim', [0.3 1.1]) 
 box off
 title(['Current vs Prosp']) 
 print('-dpdf','-r600','Figure3CDiss_CP') 

