% projectOptions_demo is a nullary function which initialises a struct
% containing the preferences and details for a particular project; in this case
% the demo for the toolbox. It should be edited to taste before a project is
% run, and a new one created for each substantially different project (though
% the options struct will be saved each time the project is run under a new
% name, so all will not be lost if you don't do this).
%
% For a guide to how to fill out the fields in this file, consult the
% documentation pages.
%
% Cai Wingfield 11-2009, 6-2010, 7-2010
%__________________________________________________________________________
% Copyright (C) 2010 Medical Research Council

function userOptions = projectOptions_AvL();

%% Project details
% This name identifies a collection of files which all belong to the same run of a project.
userOptions.analysisName = 'DEMO2'; % this is renamed in the code for demos 3-4.

% This is the root directory of the project.
 userOptions.rootPath = ['/Volumes/AM.van.Loon/fmriWorkingMemory/PilotFlowerExamplar/AllPP/MDS_Analysis'];

% The path leading to where the scans are stored (not including subject-specific identifiers).
% "[[subjectName]]" should be used as a placeholder to denote an entry in userOptions.subjectNames
% "[[betaIdentifier]]" should be used as a placeholder to denote an output of betaCorrespondence.m if SPM is not being used; or an arbitrary filename if SPM is being used.
%userOptions.betaPath = [pwd,filesep,'demoTest',filesep,'[[subjectName]]',filesep,'[[betaIdentifier]]'];

%%%%%%%%%%%%%%%%%%%%%%%%
%% EXPERIMENTAL SETUP %%
%%%%%%%%%%%%%%%%%%%%%%%%

% The list of subjects to be included in the study.
userOptions.subjectNames = { ...
	'subject1', ...
	'subject2', ...
	'subject3', ...
	'subject4', ...
	'subject5', ...
	'subject6', ...
	'subject7', ...
	'subject8', ...
	'subject9', ...
	'subject10', ...
	'subject11', ...
	'subject12' ...
    'subject13', ...
	'subject14', ...
	'subject15', ...
	'subject16', ...
	'subject17', ...
	'subject18', ...
	'subject19', ...
	'subject20', ...
	'subject21', ...
	'subject22', ...
	'subject23', ...
	'subject24' ...
	};

% The default colour label for RDMs corresponding to RoI masks (as opposed to models).
userOptions.RoIColor = [0 0 1];
userOptions.ModelColor = [0 1 0];

%%%%%%%%%%%%%%%%%%%%%%%%%%
%% ANALYSIS PREFERENCES %%
%%%%%%%%%%%%%%%%%%%%%%%%%%

%% First-order analysis
userOptions.TRLabels = { ...
    'Cue', ...
    'D1_1', ...
    'D1_2', ...
    'D1_3', ...
    'D1_4', ...
    'Search1', ...
    'D2_1', ...
    'D2_2', ...
    'D2_3', ...
    'D2_4', ...
    'Search2', ...
    'D3_1', ...
    'D3_2', ...
    'D3_3', ...
    'D3_4', ...
	};
% Text lables which may be attached to the conditions for MDS plots.
userOptions.conditionLabels = { ...
	'TCow01', ...
	'TCow02', ...
	'TCow03', ...
	'TCow04', ...
	'ACow01', ...
	'ACow02', ...
	'ACow03', ...
	'ACow04', ...
	'TDres01', ...
	'TDres02', ...
	'TDres03', ...
	'TDres04', ...
	'ADres01', ...
	'ADres02', ...
	'ADres03', ...
	'ADres04', ...
	'TSka01', ...
	'TSka02', ...
	'TSka03', ...
	'TSka04', ...
	'ASka01', ...
	'ASka02', ...
	'ASka03', ...
	'ASka04', ...
	};
[userOptions.alternativeConditionLabels{1:24}] = deal(' ');
userOptions.useAlternativeConditionLabels = true;

% Colours for the conditions.
%userOptions.conditionColours = kron([1 0 0; 0 1 0; 0 0 1; 1 .7 0], ones(16,1));
%userOptions.conditionColours = kron([1 0 0; 0.7 0 0; 0 1 0; 0 .7 0; 0 0 1; 0 0 0.7], ones(4,1));
userOptions.conditionColours = kron([1 0 0; 0.5 0 0; 0 1 0; 0 .5 0; 0 0 1; 0 0 0.5], ones(4,1));
% Groups to plot convex hulls around
%userOptions.convexHulls = [ones(1,16) 2*ones(1,16) 3*ones(1,16) 4*ones(1,16)];
userOptions.convexHulls = [ones(1,4) 2*ones(1,4) 3*ones(1,4) 4*ones(1,4) 5*ones(1,4) 6*ones(1,4)];
% Which distance measure to use when calculating first-order RDMs.
userOptions.distance = 'Correlation';

%% Second-order analysis

% Which similarity-measure is used for the second-order comparison.
userOptions.distanceMeasure = 'Spearman';

% How many permutations should be used to test the significance of the fits?  (10,000 highly recommended.)
userOptions.significanceTestPermutations = 1000; % should be 10000

% Should RDMs' entries be rank transformed into [0,1] before they're displayed?
userOptions.rankTransform = true;

% RDM Colourscheme
userOptions.colourScheme = jet(64);

% Should rubber bands be shown on the MDS plot?
userOptions.rubberbands = false;

% What criterion shoud be minimised in MDS display?
userOptions.criterion = 'metricstress';

% How should figures be outputted?
userOptions.displayFigures = true;
userOptions.saveFiguresPDF = true;
userOptions.saveFiguresFig = false;
userOptions.saveFiguresPS = false;
userOptions.saveFiguresEps = false;

% Bootstrap options
userOptions.nResamplings = 1000;
userOptions.resampleSubjects = true;
userOptions.resampleConditions = true;

% Ceiling Estimation
% Ceiling Estimation
userOptions.RDMname = 'referenceRDM';
userOptions.plottingStyle = 2;

% userOptions.forcePromptReply = 'R';