function [total_perf] = cross_validationAnoukTR_GATefS(subj,patin,regsname,selname,maskgroup,class_args,varargin,NNAll, conAr, fileNadd,startSub,endSub)
%[subj, output,total_perf] = cross_validationAnoukTR_GAT(subj,patin,regsname,selname,maskgroup,class_args,varargin,NNAll, conAr, Zscore)

% Cross-validation classification
%
% [SUBJ RESULTS] = CROSS_VALIDATION(SUBJ,PATIN,REGSNAME,SELNAME,MASKGROUP,CLASS_ARGS...)
%
% Calls the classifier multiple times, training and testing on
% different subsets of the data each time
%
% Adds the following objects:
% - results structure
%
% PATIN is the data that the classifier will be fed as its
% input. This can be either a single pattern or the name of a group
% of patterns.  If it is the name of a group of patterns, the size
% of this group must be consistent across patterns, selectors and
% masks. Most of the time, you'll want to feed in a single pattern
% - however, this pattern group functionality is useful for when
% your features depend on the n-minus-one themselves, e.g. when
% feeding in PCA components, where the results of the PCA will
% depend on the subset of the data used to create them.
% The same check for single object vs group is also used below for
% MASKGROUP.
%
% REGSNAME contains the targets that the classifier will be taught
% and then tested with. It will create one output unit per row. For pure
% classification, these should be binary, one condition per
% timepoint, but there is no error-checking or removal of rest
% built-in here deliberately.
%
% SELNAME is the group of selectors that determine which are testing
% and which are training TRs for a given iteration. One selector
% per iteration. 1s = training, 2s = testing. TRs labelled with 0s
% and other values will be excluded from the classification
% Think of each set of selectors in the cell array as a kind of
% temporal mask. Each set of selectors should have the same number
% of TRs as the patterns and regressors, with 1s for the training
% TRs, 2s for the testing TRs and 0s for the TRs that you want to
% ignore. CREATE_XVALID_INDICES will create such a group.
%
% MASKGROUP is the group of masks, one per iteration, that will be
% used to decide which features are fed to the classifier. For
% instance, NOPEEKING_MULTI_ANOVA generates such a set of masks.
%
% Note: if you ran a peeking feature selection, you'll only have one
% mask, rather than a group. If this can't find any members of a group
% called MASKGROUP, it will treat MASKGROUP as the name of an object,
% and look instead for a single mask called MASKGROUP.
%
% PERFMET_FUNCTS(optional,default = {'perfmet_maxclass'}). The names of the
% performance metric(s) you want to use to decide how well your
% classifier did. Feed in as a cell array of strings containing
% function names that get turned into function handles later
%
% PERFMET_ARGS(optional,default = {[]}. Accompanying argument-structures, one
% for each optional perfmet_funct
%
% RAND_STATE_INT (optional, default = sum(100*clock)). If your classifier
% is non-deterministic, then you want it to initialise differently
% every time, e.g. by generating a seed based on the current time,
% which is the default. If you feed in the RAND_STATE_INT, then you can
% reproduce an analysis exactly multiple times. Either way, the state
% used is saved in results.header. Note, RAND_STATE_INT should be an
% integer, not the vector state that you get from calling
% rand('state'). Thanks to ELN for the reminder about random number
% seeds.
%
% POSTPROC_FUNCT (optional, default = ''). If you specify
% the name of a function here, it will be fed the ACTS
% and SCRATCHPAD after testing but before measuring
% performance. For instance, you might call a smoothing
% function on the ACTS here.
%
% IGNORE_UNKNOWNS (optional, default = false). By default,
% CROSS_VALIDATION.M will warn you if your selectors contain
% anything other than 0s, 1s and 2s. However, if you're
% using the spherical spotlight code, you may have some
% 3s. To avoid being spuriously warned, set this to true,
% and it will ignore these.
%
% ALLOW_SINGLE_OBJECT (optional, default = false). By default,
% CROSS_VALIDATION requires SELNAME to be a group. If
% ALLOW_SINGLE_OBJECT == true, SELNAME can be a single object.

% See the manual for more documentation about the results
% structure.

% License:
%=====================================================================
%
% This is part of the Princeton MVPA toolbox, released under
% the GPL. See http://www.csbmb.princeton.edu/mvpa for more
% information.
% 
% The Princeton MVPA toolbox is available free and
% unsupported to those who might find it useful. We do not
% take any responsibility whatsoever for any problems that
% you have related to the use of the MVPA toolbox.
%
% ======================================================================


results.header.clock = clock;

defaults.rand_state_int = sum(100*results.header.clock);
defaults.perfmet_functs = {'perfmet_maxclass'};
defaults.perfmet_args = struct([]);
defaults.postproc_funct = '';
defaults.ignore_unknowns = false;
defaults.allow_single_object = false;
args = propval(varargin,defaults);

%ANOUK
TRArray = {'Ret1_TR1','Ret1_TR2','Ret1_TR3','Ret1_TR4','Ret1_TR5','Ret1_TR6','Ret2_TR1','Ret2TR2',...
    'Ret2_TR3','Ret2_TR4','Ret2_TR5','Ret2_TR6', 'Ret2_TR7','Ret2_TR8', 'Ret2_TR9'};
subjects = fieldnames(NNAll);
nSubjects = length(subjects);

total_perf = zeros(nSubjects, length(TRArray),length(TRArray));
for cSubjects = startSub:endSub;   %    cSubjects = 1;
    clear output
   % disp('subject:');  
   % fprintf('\t%i\n',cSubjects);  

      PEs = NNAll.(subjects{cSubjects}).PE;
     uPEs = unique(PEs);
    for cPEs = 1:length(PEs);
        index = findstr(uPEs{cPEs},'_');
        if index > 0;
        stem = uPEs{cPEs}(index(2)+1:end);
        nPEs{cPEs} = stem;
        else
        nPEs{cPEs} = uPEs{cPEs};   
        end
    end
  

    for xPEs = 1:length(PEs)
      indexX(xPEs) = strmatch(uPEs{xPEs},PEs); 
    end

    roiNames = fieldnames(NNAll.(subjects{cSubjects}));
    nRois = length(roiNames);
    cRois = 1;
     for i = 1:length(indexX)
            NN.(subjects{cSubjects}).PE{i} = NNAll.(subjects{cSubjects}).PE{indexX(i)};
            NN.(subjects{cSubjects}).(roiNames{cRois}).activity(:,i) =  NNAll.(subjects{cSubjects}).(roiNames{cRois}).activity(:,indexX(i));
     end
    
    %To get all the combinations!
   
    countTr = 0;
    countTrTe = 0; 
    
    trIndex = [1:6,1:9];
    %here you start to loop testing and training on the TRs
for cTR = 1:length(trIndex)
     fprintf('\\%i\n',cTR);  
    for cTRTe = 1:length(trIndex)
       % fprintf('\\%i',cTRTe);
        
        
      %To get the index for the train set (one specific TR)
        count1R1 = 0;
        count2R1 = 0;
        count3R1 = 0;                     
        ind1R1 = [];
        ind2R1 = [];
        ind3R1 = [];
        if cTR <= 6
            retArTR = {'tr1'};    
        elseif cTR >= 7
             retArTR = {'tr2'};
        end
         %Here there's a reset of the TR count! Since in the retAr tr2 the TR starts counting again... 
         countTr = trIndex(cTR);  
          
       %To get the index for the test set (all other TRs) 
        count4R1 = 0;
        count5R1 = 0;
        count6R1 = 0;                     
        ind4R1 = [];
        ind5R1 = [];
        ind6R1 = [];

        if cTRTe <= 6
            retArTRTe = {'tr1'};
        elseif cTRTe >= 7
             retArTRTe = {'tr2'};   
        end   
          %Here there's a reset of the TR count! Since in the retAr tr2 the TR starts counting again... 
          countTrTe = trIndex(cTRTe);
   
        for i = 1:length(PEs); 
          if findstr(NN.(subjects{cSubjects}).PE{i}, retArTR{1}) > 0;
            %Indexing of Train set  
            %Note that in the retAr tr2 the TR starts counting again...
               if countTr == str2num(NN.(subjects{cSubjects}).PE{i}(end))
                    if findstr(NN.(subjects{cSubjects}).PE{i}, conAr{1}) > 0;
                        count1R1 = count1R1+1;
                        ind1R1(count1R1) = i;
                    elseif findstr(NN.(subjects{cSubjects}).PE{i}, conAr{2}) > 0;
                        count2R1 = count2R1+1;
                        ind2R1(count2R1) = i;  
                    elseif findstr(NN.(subjects{cSubjects}).PE{i}, conAr{3}) > 0;
                        count3R1 = count3R1+1;
                         ind3R1(count3R1) = i;  
                    end
               end  
          end   
           
            if findstr(NN.(subjects{cSubjects}).PE{i}, retArTRTe{1}) > 0;
               %Indexing of Test set
               if countTrTe == str2num(NN.(subjects{cSubjects}).PE{i}(end))
                    if findstr(NN.(subjects{cSubjects}).PE{i}, conAr{1}) > 0;
                        count4R1 = count4R1+1;
                        ind4R1(count4R1) = i;
                    elseif findstr(NN.(subjects{cSubjects}).PE{i}, conAr{2}) > 0;
                        count5R1 = count5R1+1;
                        ind5R1(count5R1) = i;  
                    elseif findstr(NN.(subjects{cSubjects}).PE{i}, conAr{3}) > 0;
                        count6R1 = count6R1+1;
                         ind6R1(count6R1) = i;     
                    end   
              end%TRLoop 
          end%retAr
        end  %PEs
     

    labelsTe= [];
    labelsTr= [];
    %To create training labels for category mapper
    labelsTr(ind1R1) = 1;
    labelsTr(ind2R1) = 2;
    labelsTr(ind3R1) = 3;

    labelsTe(ind4R1) = 1;
    labelsTe(ind5R1) = 2;
    labelsTe(ind6R1) = 3;

    ind0 = find(labelsTr == 0);
    labelsTr(ind0) = [];

    ind0 = find(labelsTe == 0);
    labelsTe(ind0) = [];

    EVsTr = [ind1R1 ind2R1 ind3R1];
    EVsTe = [ind4R1 ind5R1 ind6R1];
    EVsTr = sort(EVsTr); 
    EVsTe = sort(EVsTe);   
     
  
    %Or make 6?
    testTr = zeros(3,1440);
    
    testTr(1,ind1R1) = 1;
    testTr(2,ind2R1) = 1;
    testTr(3,ind3R1) = 1;
    
    regsATr = testTr;
    
    testTe = zeros(3,1440);
    
    testTe(1,ind4R1) = 1;
    testTe(2,ind5R1) = 1;
    testTe(3,ind6R1) = 1;
    
    regsATe = testTe;
    
% User-specified perfmet_args must be a cell array with a struct in
% each cell. If the user feeds in a struct, put it inside a cell array
if isstruct(args.perfmet_args)
    perfmet_args = args.perfmet_args;
    args = rmfield(args,'perfmet_args');
    for p=1:length(args.perfmet_functs)
      args.perfmet_args{p} = perfmet_args;
    end
    clear perfmet_args;
end

if args.rand_state_int ~= defaults.rand_state_int
  error('Rand state int argument doesn''t work properly yet');
end
rand('state',args.rand_state_int);
results.header.rand_state_int = args.rand_state_int;
results.header.rand_state_vec = rand('state');

% Load the regressors
regressorsTr = regsATr;%get_mat(subj,'regressors',regsname); Anouk
regressorsTe = regsATe;

% Get the names of the selectors
if args.allow_single_object
  % allow single object
  selnames = find_group_single(subj,'selector',selname);
else
  % require group
  selnames = find_group(subj,'selector',selname);
end
nIterations = length(selnames);
if ~nIterations
  error('No selector group to run cross-validation over - if you want to run cross_validation.m with just a single selector that you''ve created, then you need to turn it into a group first - see http://groups.google.com/group/mvpa-toolbox/browse_thread/thread/9c7dae2757205644');
end

% Parse patin to use either a single pattern or a group of
% patterns. If there's only one pattern found, tile it once for each
% iteration (because we're going to use the same pattern each time)
[patnames ispatgroup] = find_group_single(subj,'pattern',patin);
if ~ispatgroup
  patnames = cellstr(repmat(patnames{1},[nIterations 1]));
end

%Anouk
% [masknames ismaskgroup] = find_group_single(subj,'mask',maskgroup,'repmat_times',nIterations);
% if ~ismaskgroup
%   disp( sprintf('Using the %s mask each time',maskgroup) );
% end
% 
% if length(masknames) ~= length(selnames)
%   error('Your selector and mask groups have different numbers of items in them');
% end

% Initialize the results structure
results.header.experiment = subj.header.experiment;
results.header.subj_id    = subj.header.id;

% Just in case the user only has one perfmet and fed it in as a
% string rather than cell array
if ~iscell(args.perfmet_functs) && ischar(args.perfmet_functs)
  % warning('Perfmet_functs should be a cell array, not a string - fixing');
  args.perfmet_functs = {args.perfmet_functs};
end

nPerfs = length(args.perfmet_functs);

sanity_check(class_args);

% Initialize store_perfs - this is going to store all the
% performance scores from each of the iterations, separately
% for each performance metric
%
% nPerfs x nIterations
store_perfs = [];

% disp( sprintf('Starting %i cross-validation classification iterations - %s', ...
% 	      nIterations,class_args.train_funct_name) );
%    
   
for n=1:nIterations

  %fprintf('\t%i',n);  
  cur_iteration = [];

  cv_args.cur_iteration = n;
  cv_args.n_iterations = nIterations;
  
  % Set the current selector up
  cur_selsname = selnames{n};
  selectors = get_mat(subj,'selector',cur_selsname);

  % Set up the current pattern
  cur_patname = patnames{n};
  
  % Extract the training and testing indices from the selector
    array = (1:1440);
     train_idx1 = find(selectors==1);
     train_idx2= ismember(train_idx1,EVsTr);
     train_idx3=find(train_idx2==1);
     train_idx = array(train_idx1(train_idx3));
     
     test_idx1 = find(selectors==2);
     test_idx2= ismember(test_idx1,EVsTe);
     test_idx3=find(test_idx2==1);
     test_idx = array(test_idx1(test_idx3));
     
     
      unused_idx  = find(selectors==0);
      unknown_idx = selectors;
      unknown_idx([train_idx test_idx unused_idx]) = [];
%   if length(unknown_idx) & ~args.ignore_unknowns
%     warning( sprintf('There are unknown selector labels in %s',cur_selsname) );
%   end

  if isempty(train_idx) && isempty(test_idx)
    disp('No pats and targs timepoints for this iteration - skipping');
    continue
  end

  % Set the current mask up
%  cur_maskname = masknames{n}; %Anouk
  %masked_pats = get_masked_pattern(subj,cur_patname,cur_maskname);
 % masked_pats = double(subj.patterns{1,2}.mat);
  mVol = zeros(91, 109, 91);
  mVol(NNAll.(subjects{cSubjects}).(roiNames{cRois}).index) = 1;
  subj.masks{1,1}.name = (roiNames{cRois});
  subj.masks{1,1}.mat = mVol;
  masked_pats =double(NN.(subjects{cSubjects}).(roiNames{cRois}).activity);
 
%     if Zscore == 1;
%         subjZ = zscore_runs(subj,'epi','runs');
%     elseif  Zscore == 0;
% 
%     end 
  
  assert(strcmp(class(masked_pats),'double'));
  
  % Create the training patterns and targets
  trainpats  = masked_pats(:,train_idx);
  traintargs = regressorsTr( :,train_idx);
  testpats   = masked_pats(:,test_idx);
  testtargs  = regressorsTe( :,test_idx);
  
  % Create a function handle for the classifier training function
  %train_funct_hand = str2func(class_args.train_funct_name);

  % Call whichever training function
 % scratchpad = train_funct_hand(trainpats,traintargs,class_args,cv_args);
  scratchpad = train_logreg(trainpats,traintargs,class_args,cv_args);
  % Create a function handle for the classifier testing function
  %test_funct_hand = str2func(class_args.test_funct_name);
  
  % Call whichever testing function
  %[acts scratchpad] = test_funct_hand(testpats,testtargs,scratchpad);  
  [acts scratchpad] = test_logreg(testpats,testtargs,scratchpad);  
  % If a post-processing function has been specified,
  % call it on the acts and scratchpad.
  if ~isempty(args.postproc_funct)
    postproc_funct_hand = str2func(args.postproc_funct);
    [acts scratchpad] = postproc_funct_hand(acts,scratchpad);
  end
    
  % this is redundant, but it's the easiest way of
  % passing the current information to the perfmet
  scratchpad.cur_iteration = n;
  
  % Run all the perfmet functions on the classifier outputs
  % and store the resulting perfmet structure in a cell
  for p=1:nPerfs
    
    % Get the name of the perfmet function
    cur_pm_name = args.perfmet_functs{p};
    
    % Create a function handle to it
    %cur_pm_fh = str2func(cur_pm_name);
    
    % Run the perfmet function and get an object back
   % cur_pm = cur_pm_fh(acts,testtargs,scratchpad,args.perfmet_args{p});
    cur_pm = perfmet_maxclass(acts,testtargs,scratchpad,args.perfmet_args{p});
    % Add the function's name to the object
    cur_pm.function_name = cur_pm_name;
    
    % Append this perfmet object to the array of perfmet objects,
    % only using a cell array if necessary
    if nPerfs==1
      cur_iteration.perfmet = cur_pm;
    else
      cur_iteration.perfmet{p} = cur_pm;
    end

    % Store this iteration's performance. If it's a NaN, the NANMEAN
    % call below will ignore it. Updated on 080910 to store NaNs.
    cur_iteration.perf(p) = cur_pm.perf;
    % nPerfs x nIterations
    store_perfs(p,n) = cur_iteration.perf(p);

  end
  
  % Display the performance for this iteration
  %disp( sprintf('\t%.2f',cur_iteration.perf(p)) );

  % Book-keep the bountiful insight from this iteration
  cur_iteration.created.datetime  = datetime_mvpa(true);
  cur_iteration.train_idx         = train_idx;
  cur_iteration.test_idx          = test_idx;
  cur_iteration.unused_idx        = unused_idx;
  cur_iteration.unknown_idx       = unknown_idx;
  cur_iteration.acts              = acts;
  cur_iteration.scratchpad        = scratchpad;
  cur_iteration.header.history    = []; % should fill this in xxx
  cur_iteration.created.function  = 'cross_validation';
  cur_iteration.created.patname   = cur_patname;
  cur_iteration.created.regsname  = regsname;
%  cur_iteration.created.maskname  = cur_maskname;
  cur_iteration.created.selname   = cur_selsname;
  cur_iteration.train_funct_name  = class_args.train_funct_name;
  cur_iteration.test_funct_name   = class_args.test_funct_name;
  cur_iteration.args              = args;
  results.iterations(n) = cur_iteration;
  
end % for n nIterations  

%disp('\n');
% fprintf('\t%i',cGAT);  
% Show me the money
%results.total_perf = nanmean(store_perfs,2);
total_perf(cSubjects,cTR, cTRTe) = nanmean(store_perfs,2);

% mainhist = sprintf( ...
%     'Cross-validation using %s and %s - got total_perfs - %s', ...
%     class_args.train_funct_name,class_args.test_funct_name, ...
%     num2str(results.total_perf'));

%ANOUK TEST
%results = add_results_history(results,mainhist,true);

       output.(subjects{cSubjects}).(TRArray{cTR}).(TRArray{cTRTe}).results=results;
    end %cTR
  end %cTRTe  
  
  nameFile = strcat(subjects{cSubjects},'_',fileNadd, '_GAT')
save (nameFile, 'total_perf', 'output')
end %cSubjects
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = sanity_check(class_args)

if ~isstruct(class_args)
  error('Class_args should be a struct');
end

if ~isfield(class_args,'test_funct_name') || ~isfield(class_args,'train_funct_name')
  error('Need to supply training and testing function names');
end

if ~ischar(class_args.test_funct_name) || ~ischar(class_args.train_funct_name)
  error('Training or testing function names have to be strings');
end

