%% Preprocced fMRI Data of pFs is stored in:
load('NNLOCOmb.mat')
%This structure was created based on the output of the FSL Firstlevel
%analyses, before running the firstlevel analyses, we used BetCrawler(0.4), motion correction and slice time
%correction, registration, transformed the subjects space to standard space MNI
%we ran the FSL First Level, with no convolution and created EV's (PE's Predictor Estimates )on each TR of each trial.

%Has the NNLOComb, which is a structure as follows:
%NN =   NNStruct.Participants.ROIs.activity(Voxels X Predictor Estimates(PEs))
%       NNStruct.Participants.ROIs.index (voxel index in MNI space)
%       .........P01...............................
%       .........P02...............................
%       .........etc...............................
%       NNStruct.Participants.PE are the names of the PEs per trial and TR
%       example and also used for the EV's in the FSL Firslevel:
%       ParticipantNumber (P01,P02,.....P24)
%       P01FWM2-fMRITemplateN_2TEyeFTrig_tr1_111_11_1
%       P02..........................................
%          RunNumber(WM1,WM2,WM3,WM4,WM5,WM6,WM7,WM8)
%       ....WM3......................................
%                                      interval(tr1, tr2)
%       ................................_tr2.........
%                                          condition(111,222,333,444,555,666)
%                                                    111 = Cow Current
%                                                    222 = Cow Prospective
%                                                    333 = Dresser Current
%                                                    444 = dresser Prospective
%                                                    555 = Skate Current
%                                                    666 = Skate Prospective
%       .....................................222.....
%                                               examplar (cow:11,12,13,14,
%                                               dresser:21,22,23,24
%                                               skate:31,32,33,34
%       .........................................11..
%                                                  TR(1,2,3,5,6,7,8,9,10,11,12,13,14,15)
%       ............................................1
%       P01FWM2-fMRITemplateN_2TEyeFTrig_tr1_111_11_1
%
%           P01-P24 = Paricipant Identity
%           WM1-WM8 = Indicates Run number
%           tr     = where in the trial tr1 => first 6 TRs of the trial:
%               1 = Cue
%               2 = Delay_Tr1
%               3 = Delay_Tr2
%               4 = Delay_Tr3
%               5 = Delay_Tr4
%               6 = Search1_display
%            and tr2 => next 9 TRs of the trial:
%               1(7) = Search1_Tr1
%               2(8) = Search1_Tr2
%               3(9) = Search1_Tr3
%               4(10) = Search1_Tr4
%               5(11) = Search2_Display
%               6(12) = Search2_Tr1
%               7(13) = Search2_Tr2
%               8(14) = Search2_Tr3
%               9(15) = Search2_Tr4
%
% It also contains subjTemp which is a Template to perform the classifier,
% indicating the start of the different RUNs, and PE's in order to run the
% cross validation, based on the princeton-mvpa-toolbox-master (Detre at
% al. 2006)

%% Cross-temporal generalization of object category decoding (Figure S2)
%see FigureS2_CrossTemporalGeneralization.xlsx, sheet CrossTemporalGeneralization
load('Cross-temporal generalizationFigureS2.mat') 

%if you want to run the scripts you also need the NNLOComb (load('NNLOCOmb.mat')), but 
%these script require a lot of processing time, since you are training and
%test on each TR, so 15x15.

class_args.train_funct_name = 'train_logreg';
class_args.test_funct_name = 'test_logreg';
class_args.penalty = 0.05;

%total_perf = participants x TRs => 24 X 15 x 15
conArCur = {'111','333','555'};
[perfGATCurrAll_LR] = cross_validationAnoukTR_GATefS(subjTemp,'epi','conds','runs_xval','epi_z_thresh0.05',class_args,{},NNLOComb, conArCur, 'Cur',1,24);
conArPros = {'222','444','666'};
[perfGATProsAll_LR] = cross_validationAnoukTR_GATefS(subjTemp,'epi','conds','runs_xval','epi_z_thresh0.05',class_args,{},NNLOComb, conArPros, 'Pros',1,24);

conArCP = {'222','444','666','111','333','555',};
[perfGATCrossAllCP_LR] = cross_validationAnoukTR_GATefCrossS(subjTemp,'epi','conds','runs_xval','epi_z_thresh0.05',class_args,{},NNLOComb, conArCP, 'CP',1,24);
conArPC = {'111','333','555','222','444','666'};
[perfGATCrossAllPC_LR] = cross_validationAnoukTR_GATefCrossS(subjTemp,'epi','conds','runs_xval','epi_z_thresh0.05',class_args,{},NNLOComb, conArPC, 'PC',1,24);

%%
times{1} = (1:15);
times{2} = (1:15);

cfg = [];
%Defined in the cluster_based permutation
cfg.cluster_pval = 0.05;
cfg.paired = true;
cfg.iterations = 10000;

[clusterPvalsCurrLR, pStructPCurrLR] = cluster_based_permutationAnouk(perfGATCurrAll_LR,0.3333333333,cfg,times);
[clusterPvalsProsLR, pStructPProsLR ] = cluster_based_permutationAnouk(perfGATProsAll_LR,0.3333333333,cfg,times);

%Transpose PC
for isub = 1:24
   perfGATCrossAllPC_LRT(isub,:,:) = squeeze(perfGATCrossAllPC_LR(isub,:,:))'; 
end

perfGATCrossAllPCCP_LR = (perfGATCrossAllCP_LR + perfGATCrossAllPC_LRT)/2;
[clusterPvalsPCCPLR, pStructPvalsPCCPLR ] = cluster_based_permutationAnouk(perfGATCrossAllPCCP_LR,0.3333333333,cfg,times);

mGATPros = squeeze(mean(perfGATProsAll_LR,1));
mGATCurr = squeeze(mean(perfGATCurrAll_LR,1));
mGATCPPC = squeeze(mean(perfGATCrossAllPCCP_LR,1));

%% Creating Figure 2S
cmap = brewermap([],'RdBu');
cmap = cmap(end:-1:1,:);
pValue = 0.05;
for iplot =1:3;
   figure;
   hold on
    if iplot == 1;
       inputDat = squeeze(mean(perfGATCurrAll_LR,1));
       clusterPvals =clusterPvalsCurrLR;
       pStruct =pStructPCurrLR; 
    elseif iplot == 2;
       inputDat = squeeze(mean(perfGATProsAll_LR,1));
       clusterPvals = clusterPvalsProsLR;
       pStruct =pStructPProsLR;
    elseif iplot == 3;
       inputDat = squeeze(mean(perfGATCrossAllPCCP_LR,1));
       clusterPvals = clusterPvalsPCCPLR;
       pStruct =pStructPvalsPCCPLR;
    end  
   f = size(clusterPvals,1);
   box on
   contourf(1:f,1:f,inputDat,40,'linecolor','none')
   sizeP = size(pStruct.posclusters,2);
   sizeN = size(pStruct.negclusters,2);
   count = 0;
 
   for i = 1:sizeN;
       if pStruct.negclusters(i).clusterpval < 0.05
          count = count+1;
          clusterPvalsN(count,1) = pStruct.negclusters(i).clusterpval;
       end
   end
   
  count = 0;
   for i = 1:sizeP;
       if pStruct.posclusters(i).clusterpval < 0.05
           count = count+1;
           clusterPvalsP(count,1) = pStruct.posclusters(i).clusterpval;
       end     
   end 
   
    for i = 1:size(clusterPvalsP)
        [C, h] = contour(1:f,1:f,clusterPvals == clusterPvalsP(i,1),1,'linecolor','k','linewidth',1);
    end 
   
   for i = 1:size(clusterPvalsN)
        [C, h] = contour(1:f,1:f,clusterPvals == clusterPvalsN(i,1),1,'linecolor','k','linewidth',2);
        h.LineStyle = ':';
   end 
   '-',':','

    set(gca,'ydir','norm');
    axis square
    set(gca,'clim',[1/3-1/5 1/3+1/5]);

colormap(cmap);

end %iplot

