%% Preprocced fMRI Data of pFs is stored in:
load('NNLOCOmb.mat')
%This structure was created based on the output of the FSL Firstlevel
%analyses, before running the firstlevel analyses, we used BetCrawler(0.4), motion correction and slice time
%correction, registration, transformed the subjects space to standard space MNI
%we ran the FSL First Level, with no convolution and created EV's (PE's Predictor Estimates )on each TR of each trial.

%Has the NNLOComb, which is a structure as follows:
%NN =   NNStruct.Participants.ROIs.activity(Voxels X Predictor Estimates(PEs))
%       NNStruct.Participants.ROIs.index (voxel index in MNI space)
%       .........P01...............................
%       .........P02...............................
%       .........etc...............................
%       NNStruct.Participants.PE are the names of the PEs per trial and TR
%       example and also used for the EV's in the FSL Firslevel:
%       ParticipantNumber (P01,P02,.....P24)
%       P01FWM2-fMRITemplateN_2TEyeFTrig_tr1_111_11_1
%       P02..........................................
%          RunNumber(WM1,WM2,WM3,WM4,WM5,WM6,WM7,WM8)
%       ....WM3......................................
%                                      interval(tr1, tr2)
%       ................................_tr2.........
%                                          condition(111,222,333,444,555,666)
%                                                    111 = Cow Current
%                                                    222 = Cow Prospective
%                                                    333 = Dresser Current
%                                                    444 = dresser Prospective
%                                                    555 = Skate Current
%                                                    666 = Skate Prospective
%       .....................................222.....
%                                               examplar (cow:11,12,13,14,
%                                               dresser:21,22,23,24
%                                               skate:31,32,33,34
%       .........................................11..
%                                                  TR(1,2,3,5,6,7,8,9,10,11,12,13,14,15)
%       ............................................1
%       P01FWM2-fMRITemplateN_2TEyeFTrig_tr1_111_11_1
%
%           P01-P24 = Paricipant Identity
%           WM1-WM8 = Indicates Run number
%           tr     = where in the trial tr1 => first 6 TRs of the trial:
%               1 = Cue
%               2 = Delay_Tr1
%               3 = Delay_Tr2
%               4 = Delay_Tr3
%               5 = Delay_Tr4
%               6 = Search1_display
%            and tr2 => next 9 TRs of the trial:
%               1(7) = Search1_Tr1
%               2(8) = Search1_Tr2
%               3(9) = Search1_Tr3
%               4(10) = Search1_Tr4
%               5(11) = Search2_Display
%               6(12) = Search2_Tr1
%               7(13) = Search2_Tr2
%               8(14) = Search2_Tr3
%               9(15) = Search2_Tr4
%
% It also contains subjTemp which is a Template to perform the classifier,
% indicating the start of the different RUNs, and PE's in order to run the
% cross validation, based on the princeton-mvpa-toolbox-master (Detre at
% al. 2006)

%% Mean BOLD response (Figure S1)
%see FigureS1_MeanBold.xlsx, sheet MeanBOLD 
%load('NNLOCOmb.mat') to get the NNLOComb

%to get the output:
load('MeanBOLD_FigureS1.mat')


TRArray = {'1','2','3','4','5', '6'};
[subjectMeanBoldAllTR1_6, subjectMeanBoldAllConTR1_6, subjectMeanBoldConTR1_6] = MeanBoldRetention(NNLOComb, 1, TRArray, 0, 1);
TRArray = {'7','8', '9'};
[subjectMeanBoldAllTR7_9, subjectMeanBoldAllConTR7_9,subjectMeanBoldConTR7_9] = MeanBoldRetention(NNLOComb, 1, TRArray, 0, 1);

%% Creating Figure S1
%To create the figure data is copied from the excel sheet see OverviewResults_pFs.xlsx, sheet MeanBOLD 
%and variable names given such as meanBoldCurr, meanBoldPros

% Calutue the  error bars that represent standard mean errors for the standardized data (i.e., corrected for between-subjects variance based on:
% Cousineau, D. (2005). Confidence intervals in within-subject designs: A simpler solution to Loftus and Masson?s method. Tutorials in Quantitative Methods for Psychology, 1, 42?45.

perf1 = meanBoldCurr;
perf2 = meanBoldPros;
    
N = size(perf1,1);
    for cTR = 1:size(perf1,2)
        X(:,1) = perf1(:,cTR);
        X(:,2) = perf2(:,cTR);
        
        %This function calculates the standard error of the mean for bar plots of
        %within-subject (repeated measure) designs, properly taking into account 
        %between-subject variability. It is based on the method described by 
        %Cousineau (2005) and includes a debiasing factor described by Morey (2008).
        %Implementation of the method is described in O'Brian & Cousineau (2014). 

        W = SEM_MC(X);

        Error1 = std(W(:,1),1)/sqrt(N);
        Error2 = std(W(:,2),1)/sqrt(N);

       SEMBCurr(:,cTR) = Error1;
       SEMBPros(:,cTR) = Error2;
    end
    
GAmeanBoldCurr = mean(meanBoldCurr,1);
GAmeanBoldPros = mean(meanBoldPros,1);

 %Colors of the lines
blue = [57 72 155]/255;
pink = [227 73 151]/255;

figure
hold on
lh1=shadedErrorBarfunc([1:15],GAmeanBoldCurr,SEMBCurr,blue, 0);
lh2=shadedErrorBarfunc([1:15],GAmeanBoldPros,SEMBPros,pink,0);
lgd=legend([lh1.mainLine,lh2.mainLine], 'Current','Prospective','location', 'northwest', 'orientation', 'vertical');
set(lgd,'FontSize',9); 
legend('boxoff')
set(gca, 'Ylim', [15 65])
set(gca, 'Ytick', [15:10:65],'FontSize', 9)
set(gca ,'TickDir','in')
ylabel({'Mean Bold (t-value)'},'FontSize',10, 'fontweight','bold')

set(lgd,'FontSize',9); 
legend('boxoff')
set(gca, 'Ylim', [-0.6 0.8])
set(gca, 'Ytick', [-0.6:0.2:0.8])
ylabel({'Mean Bold (t-values)'})

set(gca, 'Xlim', [0.5 15.5])
set(gca,'xtick',[0.5:15.5],'xticklabel',names)
set(gca,'XTickLabelRotation',45)
box off

plot([0.5,15.5],[0,0],':k')

print('-dpdf','-r600',  'FigureS1A_Matlab');
%%
%Average over the TR's to create the windows of interest
TRArrayC = [3 8 13]; %3 = Delay_TR2, 8 = Search1_Tr2, 13 = Search2_Tr2
figure

    count = 0;
    for cTR = 1:length(TRArrayC);
        count = count +1;
        meanDecode(:,count) = mean(meanBoldCurr(:, TRArrayC(cTR): TRArrayC(cTR)+2),2);
        count = count +1;
        meanDecode(:,count) = mean(meanBoldPros(:, TRArrayC(cTR): TRArrayC(cTR)+2),2);    
    end
  
    meanDecode=sortrows(meanDecode);
    nSubjects = size(meanDecode,1);
    meanDecodeGA = mean(meanDecode,1);
    
    placeJ =  [1,2,4,5,7,8];
    for i = 1:length(meanDecodeGA);
        
        h = bar(placeJ(i),meanDecodeGA(i), 'BarWidth', 0.7,'FaceColor', 'none');
        if i == 1, hold on, end
        if  mod(i,2) == 1; %Current
            col = blue; %[165 165 165]/255;
        else  mod(i,2) == 0; %Pros
            col = pink;%[255 255 255]/255; 
        end 
        set(h, 'FaceColor', col)
    end
    
   meanDecodeS = sortrows(meanDecode);
   meanDecode2(:,1:2)=(meanDecodeS(:,1:2));
   meanDecode2(:,3) = NaN;
   meanDecode2(:,4:5)=(meanDecodeS(:,3:4));
   meanDecode2(:,6) = NaN;
   meanDecode2(:,7:8)=(meanDecodeS(:,5:6));

    plotSpreadAnoukCol(meanDecode2,[],[],{'Delay','','', 'Search 1','','','Search 2',''}, 'showMM', 10,'nSubjects',nSubjects)
    ylabel({'Mean Bold (t-value)'},'FontSize',10, 'fontweight','bold')
    set(gca, 'Ylim', [-0.5 0.6])
    set(gca, 'Ytick', [0-.5:0.1:0.6])
    set(gca ,'TickDir','in')
    box off
    pbaspect([1 1 1])
   
    title(['Mean BOLD pFs']) 

    print('-dpdf','-r600','FigureS1B_Matlab') 
 