%% permutation test, take the mean difference as threshold for forming clusters

function s = freq_statfun_relchange(cfg, dat, design)

sel1 = find(design(cfg.ivar,:)==1);
sel2 = find(design(cfg.ivar,:)==2);
n1  = length(sel1);
n2  = length(sel2);
if (n1+n2)<size(design,2) || (n1~=n2)
  error('Invalid specification of the design array.');
end
nunits = length(design(cfg.uvar, sel1));
df = nunits - 1;
if nunits<2
    error('The data must contain at least two units (usually subjects).')
end
if (nunits*2)~=(n1+n2)
  error('Invalid specification of the design array.');
end
nsmpls = size(dat,1);

% determine selection of the data
% store the positions of the 1-labels and the 2-labels in a nunits-by-2 array
poslabelsperunit = zeros(nunits,2);
poslabel1        = find(design(cfg.ivar,:)==1);
poslabel2        = find(design(cfg.ivar,:)==2);
[dum,i]          = sort(design(cfg.uvar,poslabel1), 'ascend');
poslabelsperunit(:,1) = poslabel1(i);
[dum,i]          = sort(design(cfg.uvar,poslabel2), 'ascend');
poslabelsperunit(:,2) = poslabel2(i);


datA = dat(:,poslabelsperunit(:,1));
datB = dat(:,poslabelsperunit(:,2));

s.stat = mean((datA - datB), 2);
% s.stat = mean((datA - datB) ./ ((datA + datB)./2), 2);

end