%% To produce the plots showing in Figures 2 - supplementary figure 2: subset of items to match SFW-1

%% add path
addpath fieldtrip-20150923;
addpath scripts;
addpath scripts/functions;
ft_defaults;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
load data/spatRSA_subset; %load within-category spatial similarity time series

Rwin_avg = mean(Rsubwin,1); % group-averaged within-pair time series
Rbtw_avg = mean(Rsubbtw,1); % group-averaged within-pair time series

timeWind = linspace(-2.0,2.0,4800); %% define the whole time window

figure;
subplot(3,3,1)
plot(timeWind, Rwin_avg,'r','LineWidth',2);
axis([-2 1.0 0 0.12]);
hold on;
plot(timeWind, Rbtw_avg,'b','LineWidth',2);
axis([-2 1.0 0 0.12]);
title ('subset: matched on SFW-1')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% statistically test within-pair vs within-category correlations
timeWind = linspace(-2.0,2.0,4800);
StartTime = find(abs(timeWind-(-0.88))==min(abs(timeWind-(-0.88))));
EndTime = find(abs(timeWind-(-0.485))==min(abs(timeWind-(-0.485))));

%% Average R-values within the window of interest: -0.88 - -0.485s
within = mean(Rsubwin(:,[StartTime:EndTime]),2);
between = mean(Rsubbtw(:,[StartTime:EndTime]),2);
[h p ic stat] = ttest(within,between)