%% To produce the plots showing in Figures 2 - supplementary figure 3, order effect

%% add path
addpath fieldtrip-20150923;
addpath scripts;
addpath scripts/functions;
ft_defaults;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
load data/spatRSA_order_effect; %load spatial similarity time series of four conditions

First_Rwin_avg = mean(Rsubwin_First,1); % group-averaged within-pair time series, expected words shown first
First_Rbtw_avg = mean(Rsubbtw_First,1); % group-averaged between-pair series, expected words shown first
Second_Rwin_avg = mean(Rsubwin_Second,1); % group-averaged within-pair time series, unexpected words shown first
Second_Rbtw_avg = mean(Rsubbtw_Second,1); % group-averaged between-pair series, unexpected words shown first

timeWind = linspace(-2.0,2.0,4800); %% define the whole time window

figure;
subplot(3,3,1)
plot(timeWind, First_Rwin_avg,'r','LineWidth',2);
axis([-2 1.0 0 0.12]);
hold on;
plot(timeWind, First_Rbtw_avg,'b','LineWidth',2);
axis([-2 1.0 0 0.12]);
hold on;
title ('expected words shown first')

subplot(3,3,2)
plot(timeWind, Second_Rwin_avg,'r','LineWidth',2);
axis([-2 1.0 0 0.12]);
hold on;
plot(timeWind, Second_Rbtw_avg,'b','LineWidth',2);
axis([-2 1.0 0 0.12]);
hold on;
title ('unexpected words shown first')


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% export data for ANOVA: Order (Expected SFW first, Unexpected SFW first) and Pairs (Within-pair, Between-pair)
timeWind = linspace(-2.0,2.0,4800);
StartTime = find(abs(timeWind-(-0.88))==min(abs(timeWind-(-0.88))));
EndTime = find(abs(timeWind-(-0.485))==min(abs(timeWind-(-0.485))));

%% Average R-values within the window of interest: -0.88 - -0.485s
ExFirst_within = mean(Rsubwin_First(:,[StartTime:EndTime]),2);
ExFirst_between = mean(Rsubbtw_First(:,[StartTime:EndTime]),2);
ExSecond_within = mean(Rsubwin_Second(:,[StartTime:EndTime]),2);
ExSecond_between = mean(Rsubbtw_Second(:,[StartTime:EndTime]),2);
allData = [ExFirst_within ExFirst_between ExSecond_within ExSecond_between];

