%% To produce the plots showing in Figure 3a, temporal similarity analysis at the sensor level

%% add path
addpath fieldtrip-20150923;
addpath scripts;
addpath scripts/functions;
ft_defaults;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Temporal RSA: calculate the between-pair and within-pair correlations for one subject i
%% load the paired data (trial x sensor x time) for subject i, with the corresponding trials of data_1 and data_2 predicting the same word   
i=10;
load(strcat('/source_trl_sub', sprintf('%02d', i)));
Rsubbtw_1 = PearsonCorrTemp_shift_BtwPair(data_1, data_1);
Rsubbtw_2 = PearsonCorrTemp_shift_BtwPair(data_2, data_2);
Rsubbtw_3 = PearsonCorrTemp_shift_BtwPair(data_1, data_2);
Rsubbtw(i,:) = (Rsubbtw_1 + Rsubbtw_2 + Rsubbtw_3)./3;
Rsubwin(i,:) = PearsonCorrTemp_WinPair(data_1, data_2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% use fieldtrip toolbox to get the topographical maps of the temporal similarity R-values
load data/tempRSA_sensor; %load within-pair spatial similarity time series
load data/template_topo;

for j = 1:size(Rsubbtw,1)
    Data_win = template_topo;
    Data_win.avg = Rsubwin(j,:)'; %put the temporal similarity values in the corresponding field    
    Data_btw = template_topo;
    Data_btw.avg = Rsubbtw(j,:)'; %put the temporal similarity values in the corresponding field    
	
    sub_win(j).corr = Data_win;
    sub_btw(j).corr = Data_btw;
end

cfg = [];
cfg.keepindividual  = 'yes';
grand_win = ft_timelockgrandaverage(cfg, sub_win(:).corr);
grand_btw = ft_timelockgrandaverage(cfg, sub_btw(:).corr);

%% get the neighborhood of the sensors
cfg = [];
cfg.method  = 'template';
cfg.layout = 'CTF275.lay';
neighbours = ft_prepare_neighbours(cfg);

%% permutation test
cfg = [];
cfg.neighbours = neighbours; 
cfg.channel = {'MEG'};
cfg.method = 'montecarlo';
cfg.design           = [1:26 1:26; ones(1,26), ones(1,26) * 2]; %number of subject = 26
cfg.numrandomization = 1000; %1000 permutations
cfg.correctm         = 'cluster';
cfg.clusteralpha     = 0.025;
cfg.clustertail             = 0; % one-or two-sided testing
cfg.clusterstatistic = 'maxsum'; % maximum sum of t-values within one cluster is the test statistic
cfg.clusterthreshold = 'nonparametric_individual';%'nonparametric_common';
cfg.alpha            = 0.05;
cfg.tail      = 0; % two-sided testing;
cfg.correcttail      = 'prob';
cfg.statistic        = 'freq_statfun_relchange';
cfg.uvar             = 1; % subject number (unit variable) on line 1 of the design matrix
cfg.ivar             = 2; % condition number (independent variable) on line 2 of the design matrix
cfg.minnbchan        = 2;
cfg.latency = [-0.5 -0.5];
cfg.avgovertime = 'yes';
stat = ft_timelockstatistics(cfg, grand_win, grand_btw);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% plot the R-values on topographies; Figure 3a
load data/tempRSA_sensor; %load temporal similarity R-values
load data/stat_tempRSA_sensor;
load data/template_topo;

%% average R-values across subjects
Rwin_avg = mean(Rsubwin,1);
Rbtw_avg = mean(Rsubbtw,1);

%% assign the group-averaged temporal similarity R-values to the data structure
plotData_Rwin = template_topo;
plotData_Rwin.avg = Rwin_avg';
plotData_Rbtw = template_topo;
plotData_Rbtw.avg = Rbtw_avg';
plotData_dif = template_topo;
plotData_dif.avg = Rwin_avg' - Rbtw_avg';

cfg = [];
cfg.xlim = [0 0];
cfg.zlim = [-0.12 0.12];
cfg.colorbar = 'no';
cfg.comment = 'no';
cfg.marker = 'off';
cfg.layout = 'CTF275.lay';

figure(3); 
subplot(1,3,1)
ft_topoplotER(cfg, plotData_Rwin);
title('within-pair')
subplot(1,3,2)
ft_topoplotER(cfg, plotData_Rbtw);
title('between-pair')
cfg.highlight = 'on';
cfg.highlightchannel = stat.label(find(stat.mask==1));%highlight the channels showing significant effect
subplot(1,3,3)
cfg.zlim = [-0.05 0.05];
ft_topoplotER(cfg, plotData_dif);
title('within-pair vs between-pair')

