%% To produce the plots showing in Figure 3b, figure 3 - supplementary figure 3a, temporal similarity analysis in the source space

%% add path
addpath fieldtrip-20150923;
addpath scripts;
addpath scripts/functions;
ft_defaults;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Temporal RSA: calculate the between-pair and within-pair correlations for one subject i
%% load the paired data (trial x grid point x time) for subject i, with the corresponding trials of data_1 and data_2 predicting the same word   
i=10;
load(strcat('/source_trl_sub', sprintf('%02d', i)));
Rsubbtw_1 = PearsonCorrTemp_shift_BtwPair(data_1, data_1);
Rsubbtw_2 = PearsonCorrTemp_shift_BtwPair(data_2, data_2);
Rsubbtw_3 = PearsonCorrTemp_shift_BtwPair(data_1, data_2);
Rsubbtw(i,:) = (Rsubbtw_1 + Rsubbtw_2 + Rsubbtw_3)./3;
Rsubwin(i,:) = PearsonCorrTemp_WinPair(data_1, data_2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% use fieldtrip toolbox to get the source maps of the temporal similarity R-values
%% Get temporal similarity R-values to the source space
load data/tempRSA_source; %load within-pair and between-pair temporal similarity R-values at the source level
load data/template_source;
load data/template_grid;

for j=1:size(Rsubbtw,1)
    % assign the correlation values to the source grids
    sourceCorr_win = template_source;
    sourceCorr_win.pow(template_source.inside) = Rsubwin(j,:)';
    sourceCorr_win.pos = template_grid.pos;    
    sourceCorr_btw = template_source;
    sourceCorr_btw.pow(template_source.inside) = Rsubbtw(j,:)';
    sourceCorr_btw.pos = template_grid.pos;    
    sub_win(j).source = sourceCorr_win;
    sub_btw(j).source = sourceCorr_btw;
end

cfg = [];
cfg.keepindividual = 'yes';
grand_sourceCorr_win = ft_sourcegrandaverage(cfg, sub_win(:).source);
grand_sourceCorr_win.cfg = rmfield(grand_sourceCorr_win.cfg,'previous');
grand_sourceCorr_btw = ft_sourcegrandaverage(cfg, sub_btw(:).source);
grand_sourceCorr_btw.cfg = rmfield(grand_sourceCorr_btw.cfg,'previous');

%% statistical test
cfg=[];
cfg.dim         = grand_sourceCorr_win.dim;
cfg.method      = 'montecarlo';
cfg.statistic   = 'freq_statfun_relchange';
cfg.clusterthreshold = 'nonparametric_individual';
cfg.parameter   = 'pow';
cfg.correctm    = 'cluster';
cfg.clusterstatistic = 'maxsum';
cfg.numrandomization = 1000;
cfg.clusteralpha       = 0.025; % note that this only implies single-sided testing
cfg.clustertail        = 0;
cfg.tail        = 0;
cfg.alpha       = 0.05;
cfg.correcttail      = 'prob';
cfg.design           = [1:26 1:26; ones(1,26), ones(1,26) * 2]; %number of subject
cfg.uvar             = 1; % subject number (unit variable) on line 1 of the design matrix
cfg.ivar             = 2; % condition number (independent variable) on line 2 of the design matrix
statSource = ft_sourcestatistics(cfg, grand_sourceCorr_win, grand_sourceCorr_btw);

%% interpolation to MNI space
load data/template_mri;
mri = ft_volumereslice([], template_mri);

cfg = [];
cfg.downsample = 2;
cfg.parameter  = 'stat';
statSource_int  = ft_sourceinterpolate(cfg, statSource, mri);
cfg.parameter  = 'mask';
mask  = ft_sourceinterpolate(cfg,statSource, mri);
statSource_int.mask = mask.mask;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% plot the stat results for figure 3b
load data/stat_tempRSA_source;

%% plot the source stats, masked by the significant cluster
plotFigure = statSource_int;
cfg = [];
cfg.atlas = 'scripts/fieldtrip-20150923/template/atlas/aal/ROI_MNI_V4.nii';
cfg.method        = 'ortho';
cfg.funparameter  = 'stat';
cfg.maskparameter = 'mask';
cfg.funcolorlim   = [-0.03 0.03];
cfg.opacitymap    = 'rampup'; 
cfg.crosshair     = 'no';
cfg.location = [-39.5 -19.5 -29.5]; %inferior temporal
cfg.locationcoordinates = 'head';
ft_sourceplot(cfg, plotFigure);
title('temporal RSA stats')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% plot the source stats, masked by 85% maximum activation, figure 3 - supplementary figure 2
cfg = [];
plotFigure.mask = [plotFigure.stat > max(abs(plotFigure.stat(:)))*.85 | plotFigure.stat < -(max(abs(plotFigure.stat(:)))*.85)].*plotFigure.mask;% 85 % of maximum
cfg.atlas = 'scripts/fieldtrip-20150923/template/atlas/aal/ROI_MNI_V4.nii';
cfg.method        = 'ortho';
cfg.funparameter  = 'stat';
cfg.maskparameter = 'mask';
cfg.funcolorlim   = [-0.03 0.03];
cfg.opacitymap    = 'rampup'; 
cfg.crosshair     = 'no';
cfg.location = [-39.5 -19.5 -29.5]; %inferior temporal
cfg.locationcoordinates = 'head';
ft_sourceplot(cfg, plotFigure);
title('temporal RSA stats: 85% maximum')



