%% This function is to build a permutation distribution and get the critical t value
%% following parameters need to be defined
% data_dif = data_1-data_2; % the difference of two conditions: sub*time*freq
% permN=1000; %number of permutation
% n_subs=32; %number of subjects
% alph = 0.05; %sig threshold
% tail: 0=two-tailed; 1=upper tailed; -1=lower tailed

function [Perm,tmx_ptile] = twoDpermute(data_dif,permN,n_subs,alph,tail)
clear Perm;
%% permute and get the biggest T-sum for each permutation
for indPerm = 1:permN
    %assign either 1 or -1 to each subject (1=no relable, 0=relabel)
    sn(1:n_subs,1,1)=(rand(1,n_subs)>.5)*2-1;
    sn_mtrx=repmat(sn,[1 size(data_dif,2) size(data_dif,3)]);
    data_perm = data_dif.* sn_mtrx; %swap the label of conditions
    
    %stats
    [h,p,ci,stats] = ttest(data_perm,zeros(n_subs,size(data_dif,2),size(data_dif,3)),'alpha',0.05,'dim',1);    
    hvalues = squeeze(h);
    tvalues = squeeze(stats.tstat);
    
    %find all the clusters and calculate the sum of the t-values
    [L,n] = bwlabel(hvalues,4);
    for k = 1:n
        if size(find(L==k),1) >= 1 & ~isnan(hvalues(find(L==k)))
            clusterPerm(k) = sum(tvalues(find(L==k)));
        end
    end
    if exist('clusterPerm')
        maxsum(indPerm) = nanmax(clusterPerm); %find the largest sumT
    else
        maxsum(indPerm) = 0;
    end
    clear L n k data_perm sn* stats h* tvalues p ci clusterPerm
end

%% get the permuation distribution
Perm = [-maxsum maxsum]; %assum the null hypothesis distribution is symmetric

%% find the critical t-value
if tail==0,
    %two-tailed
    tmx_ptile(1)=prctile(Perm,100*alph/2);
    tmx_ptile(2)=-tmx_ptile(1);
elseif tail==1,
    %upper tailed
    tmx_ptile=prctile(Perm,100-100*alph);
else
    %tail=-1, lower tailed
    tmx_ptile=prctile(Perm,alph*100);
end