cls
subjects = {}
times = {'PRE';'POST'};
stimtypes = {};

glmdir = 'glm';
torbet = 'Ntvals';
thr = 0.7; % minimum correlation with coarse grid functions to attempt fitting
hemi = {'lh';'rh'};
gofmode = 'corr';
doinitialize = 1;
dofit = 1;
fitfun = 'fitPRF1d';
name4file = 'all';

%% define stimulus movie

res = 400;
x = linspace(0,10,res);
nTRs = 6;
stim_movie = repmat(x*0,nTRs,1);
stim_movie(1,:) = x<0.9;
stim_movie(2,:) = x>=0.9 & x<1.8;
stim_movie(3,:) = x>=1.8 & x<3.3;
stim_movie(4,:) = x>=3.3 & x<4.7;
stim_movie(5,:) = x>=4.7 & x<6.48;
stim_movie(6,:) = x>=6.48 & x<9;
figure(1)
imagesc(x,1:nTRs,stim_movie)

%% define coarse grid search
startRF.center = 0;
startRF.sig = 10;
startRF.shutup = 1;


centers = logspace(-1,1,20);
sigs = [0.1 0.3 1 3 10];
[cc,ss] = meshgrid(centers,sigs);
for iii = 1:numel(cc)
    initRFs(iii).center = cc(iii);
    initRFs(iii).sig = ss(iii);
    initRFs(iii).shutup = 1;
    [~,PredResp(:,iii)] = fitPRF1d(initRFs(iii),x,stim_movie);
end

%%
for r = 1:length(stimtypes)
    
    for s = 1:length(subjects)
        tic
        subj = subjects{s}; disp(subj)

        [leftdeprived,PROJECT_DIR] = findeprivedeye(subj);
        sessdir = [subj '_PRE'];
        subject = ['md_' subj];
        session_dir = sprintf('%s%s/',PROJECT_DIR,sessdir);
        
        targetfolder = sprintf('%sbold_afterBV2/%s/',session_dir,stimtypes{r});
        disp(targetfolder)
        %% load data
        for h = 1:length(hemi)
            
            targetfile = sprintf('%s.%s.%s_white_sm3.nii.gz',stimtypes{r},torbet,hemi{h});
            outputfile = sprintf('%s_%s.%s.%s',fitfun,gofmode,name4file,targetfile);
            
            hdr = load_nifti(sprintf('%sbold_afterBV2/%s/%s',session_dir,stimtypes{r},targetfile));
            
            if ~strcmp(name4file,'all')
                selected = [];
                for ir = 1:length(rois)
                    path2roi = sprintf('%s.%s',hemi{h},rois{ir});
                    l = read_label(subject,path2roi);
                    selected = [selected; l(:,1) + 1];
                end
                mybetas = hdr.vol(:,:,:,1:6)*0;
                mybetas(selected,:,:,:) = hdr.vol(selected,:,:,1:6);
            else
                mybetas = hdr.vol(:,:,:,1:6);
            end
            mybetas(isnan(mybetas)) = 0;
            
            sz = size(mybetas);
            gofmap = NaN(sz(1:3));
            eccmap = NaN(sz(1:3));
            sigmap = NaN(sz(1:3));
            
            
            % loop through selected vertices
            disp(sprintf('total n vertices: %i',size(mybetas,1)))
            parfor ind = 1 : size(mybetas,1)
                obs = squeeze(mybetas(ind,:,:,:));
                if mod(ind,10^4)==0, disp(ind); end
                if ~sum(obs)==0
                    
                    if min(obs)<0
                        obs = obs - min(obs);
                    end
                    obs = obs / max(obs);
                    
                    R = corr(obs,PredResp);
                    [maxval,peak] = max(R);
                    if maxval > thr
                        
                        [tmpRF,err] = fit('fitPRF1d',initRFs(peak),{'center';'sig'},x,stim_movie,obs,gofmode);
                        gofmap(ind) = 1-err;
                        eccmap(ind) = tmpRF.center;
                        sigmap(ind) = tmpRF.sig;
                    end
                end
            end
            newvol = cat(4,eccmap,sigmap,gofmap);
            
            out_file = sprintf('%sbold_afterBV2/%s/%s',session_dir,stimtypes{r},outputfile);
            hdr.vol = newvol;
            save_nifti(hdr,out_file)
            
        end
    end
    toc
end
