function [err,PredResp,out] = fitPRF1d(RF,x,stim_movie,ObsResp,gofmode)

out = exp( -( (x-RF.center).^2 ) / (2*RF.sig^2) );
PredResp = stim_movie * out'; %predict betas
PredResp = PredResp / max(PredResp);

if nargin>3
    if strcmp(gofmode,'varexplained')

        SSE =  nansum((ObsResp-PredResp).^2);
        TOT = nansum((ObsResp-0).^2);
        unexplainedvar = SSE/TOT;
        err = unexplainedvar;
    else
        err = -corr(ObsResp,PredResp);
    end
else
    err = NaN;
end

if (RF.sig/RF.center < 0.09) || (RF.sig/RF.center > 9.99) || RF.center > 20 || RF.sig < 0.1
    err = Inf;
end

