function [err,PredResp,out,TOT,TOTp] = fitprf_SF_1param(RF,x,stim_movie,ObsResp,gofmode)

alpha = 1;
sig = 2 * RF.sig ^ 2;
y = exp((-x.^2)/sig) - alpha * exp((-x.^2)/(sig/50)) ;
y = y * (sig);
out = y;


PredResp = stim_movie * out'; % predict betas
PredResp = PredResp / max(PredResp);

err = NaN;
TOTp = NaN;
TOT = NaN;
if nargin>3
    if strcmp(gofmode,'varexplained')
        SSE =  sum((ObsResp-PredResp).^2);
        TOT = sum((ObsResp-mean(ObsResp)).^2);
        TOTp = sum((PredResp-mean(PredResp)).^2);
        
        unexplainedvar = SSE/TOT;
        err = unexplainedvar;
    else
        err = -corr(ObsResp,PredResp);
    end
end
if log10(sig) < -.5 || log10(sig) > 4
    err = Inf;
end
