cls
subjects = {}; %
subjects = subjects(2);
times = {'PRE','POST'};
stimtypes = {'BAND_RE','BAND_LE'};


glmdir = 'glm';
torbet = 'Ntvals';
thr = 0.5; % minimum correlation with coarse grid functions to attempt fitting
hemi = {'lh';'rh'};
doinitialize = 1;
dofit = 1;
fitfun = 'fitprf_SF_1param';
gofmode = 'corrconstr';
suff = '';
roiname ={'V1_bv'};
smoothlev = 3;

%% define stimulus movie

load('bins_fft_not_norm');
xx = mean(bins,2)';
spec.bin = load('avgspec_band_not_norm'); %load bin curves


nTRs = 5;
stim_movie = repmat(xx*0,nTRs,1); % make a stimulus representation.
% each stimulus is defined by its own spectrum (x = SFs). there are five
% spectra per stimulus type (binary or bandpass) corresponding to the five
% beta values we get
for i = 1:nTRs
    stim_movie(i,:) = spec.band.avgspec(:,end-(i-1));
end

figure(1)
plot(xx,stim_movie)
set(gca,'xscale','log')

% imagesc(xx,1:nTRs,stim_movie)
%% define coarse grid search
if doinitialize
    centers = NaN;
    sigs = logspace(-1,3,100);
    sigs = sqrt(sigs/2);

    [cc,ss] = meshgrid(centers,sigs);
    clear initRFs PredResp
    for iii = 1:numel(cc)
        initRFs(iii).center = cc(iii);
        initRFs(iii).sig = ss(iii);
        initRFs(iii).shutup = 1;
        [~,CoarseGrid(:,iii)] = fitprf_SF_1param(initRFs(iii),xx,stim_movie);
    end
end

%% loop across subjects
for s = 1:length(subjects)
    subj = subjects{s}; 
    disp(subj)
    [leftdeprived,PROJECT_DIR] = findeprivedeye(subj);
    subject = ['md_' subj];  
    for t = 1:length(times)
        time = times{t};
        session_dir = sprintf('%s%s_%s/',PROJECT_DIR,subj,time);
        
        % load data
        for r = 1:length(stimtypes)
            targetfolder = sprintf('%sbold_afterBV2/%s_%s/%s/',session_dir,stimtypes{r},time,glmdir);
            disp(targetfolder)
            for h = 1:length(hemi)
                targetfile = sprintf('%s.%s.%s%s.%s_white_sm%i.nii.gz',...
                    'all',stimtypes{r},torbet,suff,hemi{h},smoothlev);
                outputfile = sprintf('%s_%s.%s.%s.%s%s.%s_white_sm%i.nii.gz',...
                    fitfun,gofmode,name4file,stimtypes{r},torbet,suff,hemi{h},smoothlev);
               
                tic
                clear allbrain tmp % free up memory - only necessary for AD oscill or rings
                tmp = load_nifti([targetfolder targetfile]);
                allbrain = tmp.vol(:,:,:,1:5); 
                siz = size(allbrain);
                % define roi
                roi = [];
                for ir = 1 : length(roiname)
                    try path2roi = sprintf('%s.%s',hemi{h},roiname{ir});
                        l = read_label(subject,path2roi);
                        roi = [roi; l(:,1) + 1];
                    end
                end
                
                if isempty(roi)
                    occmask = ones(siz(1:3));
                else
                    occmask = zeros(siz(1:3));
                    occmask(roi) = 1;
                end
                gofmap = NaN(siz(1:3));
                eccmap = NaN(siz(1:3));
                sigmap = NaN(siz(1:3));
                varmap = NaN(siz(1:3));
                
                
                parfor ind = 1:siz(1)
                    obs = squeeze(allbrain(ind,:,:,:));
                    if any(isnan(obs)), obs = zeros(size(obs)); end
                    if occmask(ind) > 0 && ~sum(obs)==0 && max(obs)>0
                        
                        obs = obs / max(obs);
                        % initialize
                        R = corr(obs,CoarseGrid);
                        [maxval,peak] = max(R);
                        if maxval > thr
                            [tmpRF,err] = fit(fitfun,initRFs(peak),{'sig'},xx,stim_movie,obs,gofmode);
                            gofmap(ind,1,1,1) = -err;
                            eccmap(ind,1,1,1) = tmpRF.center;
                            sigmap(ind,1,1,1) = tmpRF.sig;
                            varmap(ind,1,1,1) = sum((obs-mean(obs)).^2);
                        end
                    end
                end
                
                newvol = cat(4,eccmap,sigmap,gofmap,varmap);
                tmp.vol = newvol;
                save_nifti(tmp,[targetfolder outputfile]);
                disp(outputfile)
                toc
                
            end
        end
    end
end
