//macro 1 of 3 macros: “Gyradius and intensity normalization”,“Golgi mini-stack alignment” and “Radial mean intensity profile”.
//Images must be square.
//before executing the macro, select the giantin channel as the active window.
//created on 28 September 2018
//modified on 20181005
macro "gyradius and intensity normalization"
{
folder_path=getDirectory("Choose a Directory")

run("Clear Results");
title=getTitle;
selectWindow(title);

run("Properties...", "channels=3 slices=1 frames=1 unit=pixel pixel_width=1 pixel_height=1 voxel_depth=1");		
//20181005: This sentence is added to change the image property of the image so that the dimension unit is pixel instead of micrometer.


Image_h=getHeight();
Qx=0;
Qy=0;
Total_Intensity=0;
//below is the module to calculate the center of mass, mx and my.
for (i=0; i<Image_h;  i++ )
{	for (j=0;  j<Image_h; j++)
		{Intensity=getPixel(i, j);
			 
				{Total_Intensity=Total_Intensity+Intensity;
				Qx=Qx+i*Intensity;
				Qy=Qy+j*Intensity;}
		}
}

mx=Qx/Total_Intensity;  		//center of mass along the x-axis
my=Qy/Total_Intensity;  		//center of mass along the y-axis
								//there is 0.5 pixel shift for the center of mass calculation in comparison to imageJ
								//the mass is assumed to be at the upper left corner of each pixel.
//below is the module to calculate the gyradius
Q=0;								
Total_Intensity=0;

for (i=0; i<Image_h; i++)
{	for (j=0;  j<Image_h; j++)
		{Intensity=getPixel(i,j);
			 
				{Total_Intensity=Total_Intensity+Intensity;
				Q=Q+((i-mx)*(i-mx)+(j-my)*(j-my))*Intensity;}
		}
}

gyradius=sqrt(Q/Total_Intensity);

print("image=", title);
print("center of mass ", "x=", mx, ", y=", my);
print("gyradius in pixels=", gyradius);

//below is the module to resize the image to normalize the gyradius to 100 pixels
selectWindow(title);
Image_h=getHeight();
New_h=Image_h*100/gyradius;
print("Original height of the image= ", Image_h, "; Expanded height of the new image= ", New_h);
run("Size...", "width=&New_h height=&New_h depth=3 constrain average interpolation=None");  //did it resize the makeoval box?

//below is the command to make the image a 701x701 square.
run("Canvas Size...", "width=701 height=701 position=Center zero");
print("Canvas size is further expanded to 700x700 pixel.");

//below is the module to normalize the integrated intensity to 200M by using Process->Math
getDimensions(width1, height1, channels, slice1, frame1);
for (channel_i=1; channel_i<=channels; channel_i++)
{
Stack.setChannel(channel_i);

run("Set Measurements...", "integrated redirect=None decimal=4");
run("Select All");
run("Measure");
Integrated_intensity=getResult("IntDen", nResults-1);
I_factor=200000000/Integrated_intensity;
run("Multiply...", "value=&I_factor slice");
print("channel=", channel_i," done.");
}
print("Channel integrated intensity normalized to 200,000,000.");

//below is the modeule to split channels and save each channel image to a specified path.
getDimensions(width1, height1, channels, slice1, frame1);
run("Split Channels");
for (channel_i=1; channel_i<=channels; channel_i++)
{selectWindow("C"+channel_i+"-"+title);
saveAs("Tiff", folder_path+"C"+channel_i+"-"+title);  //string concatenation
}
print("files are saved at= ", folder_path);
print("--------------------------------------------------------------------------------------------------------------------------");

run("Clear Results");

} 