////macro 3 of 3 macros: “Gyradius and intensity normalization”,“Golgi mini-stack alignment” and “Radial mean intensity profile”.
//It requires the averaged single color image that has been treated with "gyradius and intensity normalization" and "Golgi mini-stack alignment" macros.
//Select the averaged image as the active one.
//A list of intensity values are generated in the Results window and mean intensity values (the 4th column) can be copied to Excel or Origin for plotting and analysis.
//the first column is the radius (in pixel); the fourth column is the mean intensity at a radius; only the first and the fourth column are useful.

macro "radial intensity profile"

{


run("Clear Results");


xm=349.5;
ym=349.5;

for (k=0; k<=499; k++)
{
	setResult("total intensity", k, 0);
	setResult("No. pixels", k, 0);
	setResult("mean intensity", k, 0);
}



for (i=0;i<=700;i++)
{	for (j=0; j<=700; j++)
	{ 	radius=sqrt((i-xm)*(i-xm)+(j-ym)*(j-ym));
		n=floor(radius);
		intensity=getPixel(i,j);
		cumulative_intensity=getResult("total intensity", n)+intensity;
		setResult("total intensity", n, cumulative_intensity);
		cumulative_pixel=getResult("No. pixels", n)+1;
		setResult("No. pixels", n, cumulative_pixel);
	}
}

for (i=0; i<nResults; i++)
{
		cumulative_pixel=getResult("No. pixels", i);
		cumulative_intensity=getResult("total intensity", i);
		if (cumulative_pixel!=0)
			{
				average_intensity=cumulative_intensity/cumulative_pixel;
				setResult("mean intensity", i, average_intensity);
			}
		else
		{
				setResult("mean intensity", i, 0);
		}

		
}



}