function [energy_state, energy_all, statepop, lifetime, rate]=TPM2en(transmat,km,dt)
      % Calculate the energy (including energy of all folding state and their association energy barrier) 
      % corresponding to a Markov model.
      % Input:
      % transmat: given the transition probability matrix transmat
      % km: the maximum transition rate in the absence of any
      %     transition energy barrier 
      % dt: sampling time 
      
      % Output: energy_state, statepop, and lifetime are all colum vector
      % energy_state: energy of state
      % energy_all: energy of state and transition state
      % statepop: state population
      % lifetime: state lifetime
      % rate: transition rate matrix
      
      % The transition probability matrix a=exp(q.*t) where q is the
      % transition rate matrix and t the sampling time.
      [col,rol]=size(transmat); % Number of state
      if(col==rol)
          Nst=col;
      else
          disp('Not a sqare matrix.')
          energy_state=[]; energy_all=[]; statepop=[]; lifetime=[]; rate=[];
          return
      end
      ld=diag(true(Nst,1)); % Diagonal true matrix
      q=logm(transmat)./dt;  % transition rate matrix
      %disp(q)
      
      % If any rate element is negative, calculate the rate matrix by
      % transmat/dt.
      c=q;
      c(ld)=1;
      if(any(any(c<=0)))
          q=transmat./dt;
          q(ld)=0;
          q(ld)=-sum(q');
      end 
     [v,d]=eigs(transmat',1);
     if(abs(d-1)<1e-5)
         statepop=v./sum(v);
     else
         disp('The maximum eigenvalue is not one!')
         return
     end
      
      % Calculate state energy relative to state Nst
      energy_state=-log(statepop./statepop(end));
      energy_all=zeros(Nst);
      for i=1:Nst
          for j=1:Nst
              if(i==j)
                  energy_all(i,i)=energy_state(i);
              else
                  energy_all(i,j)=energy_state(i)-log(q(i,j)./km);
              end
          end
      end
      rate=q;
      r=rate;
      r(ld)=0;
      lifetime=1000./sum(r');
      lifetime=lifetime';
return
   


