function [obs, hidden] = mhmm_sample_YZ(T, initial_prob, transmat, mu, Sigma)
% SAMPLE_MHMM Generate random sequences from an HMM with (mixtures of) Gaussian output.
% [obs, hidden] = sample_mhmm(T, numex, initial_prob, transmat, mu, Sigma, mixmat)
%
% INPUTS:
% T - length of each sequence
% init_state_prob(i) = Pr(Q(1) = i)
% transmat(i,j) = Pr(Q(t+1)=j | Q(t)=i)
% mu(i) = mean of Y(t) given Q(t)=i
% Sigma(i) = fluctuation of Y(t) given Q(t)=i
%
% OUTPUT:
% obs(t) = observation vector at time t 
% hidden(t) = the hidden state at time t 

Q = length(initial_prob);
hidden = zeros(1,T);
obs = zeros(1,T);

hidden = mc_sample(initial_prob, transmat, T, 1)';
sig=sqrt(Sigma);
r=randn(1,T);
for t=1:T
  q = hidden(t);
  obs(t) =mu(q)+sig(q)*r(t);
end

