function [obs, hidden] = mhmm_sample_YZ_skew(T, initial_prob, transmat, mu, Sigma, skew)
% SAMPLE_MHMM_YZ_skew Generate random sequences from an HMM with skew Gaussian output.
% [obs, hidden] = sample_mhmm_YZ_skew(T, numex, initial_prob, transmat, mu, Sigma, skew)
%
% INPUTS:
% T - length of each sequence
% init_state_prob(i) = Pr(Q(1) = i)
% transmat(i,j) = Pr(Q(t+1)=j | Q(t)=i)
% mu(i) = mean of Y(t) given Q(t)=i
% Sigma(i) = fluctuation of Y(t) given Q(t)=i
% skew(i)= Shape of Y(t) given Q(t)=i
% See the link on skew normal distribution: https://en.wikipedia.org/wiki/Skew_normal_distribution
%
% OUTPUT:
% obs(t) = observation vector at time t 
% hidden(t) = the hidden state at time t 

Q = length(initial_prob);
hidden = zeros(1,T);
obs = zeros(1,T);
hidden = mc_sample(initial_prob, transmat, T, 1)';
sig=sqrt(Sigma);
delta=skew./sqrt(1+skew.*skew);
r1=randn(1,T);
r2=randn(1,T);
for t=1:T
    q = hidden(t);  % state
    % General random numbers with the skew normal distribution 
    z=delta(q)*r1(t)+sqrt(1-delta(q)*delta(q))*r2(t);
    if(r1(t)<0)
        z=-z;
    end
    obs(t) =mu(q)+sig(q)*z;
end


