
function [statepop,lifetime,rates]=state_info_grad(km,g)
% This function calculate the state population (statepop), lifetime (ms), 
% and reaction rates (1/s) of a Markov process, given its symmetric energy matrix obtained 
% from HMM optimization based upon gradient search and the molecular reaction rate
% constant.  Note that the outputs are row arrays fro statepop and
% lifetime. Also note that the diagonal entry of rates is the lifetime of
% each state in ms.
     [N,Nc]=size(g);
     gs=zeros(1,N);
     lifetime=zeros(1,N);
     rates=zeros(N);
     for i=1:N
         gs(i)=g(i,i);
         ind=gs(i)<g(i,:);
         rates(i,ind)=km.*exp(gs(i)-g(i,ind));
         rates(i,~ind)=km;   % Barrierless diffusion rate      
         rates(i,i)=0;
         lifetime(i)=1000./sum(rates(i,:));
         rates(i,i)=lifetime(i);
     end
     statepop=exp(-gs)./sum(exp(-gs));   
end
     